/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.entity.EditableEntity;
import com.dmgame.entity.KuriboShoe;
import com.dmgame.entity.Spring;
import com.dmgame.entity.ThrowBox;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.OrderedTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import com.dmgame.map.Warp;
import com.dmgame.map.interactivetiles.AbstractOnOffBlock;
import com.dmgame.map.interactivetiles.BlueThrowBlock;
import com.dmgame.map.interactivetiles.BrickBlock;
import com.dmgame.map.interactivetiles.ClearItemBlock;
import com.dmgame.map.interactivetiles.GrayThrowBlock;
import com.dmgame.map.interactivetiles.QuestionBlock;
import com.dmgame.map.interactivetiles.RedThrowBlock;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.undo.StateEditable;

public class Map
implements Serializable,
StateEditable {
    private static final long serialVersionUID = -4689424233981078135L;
    public static final int DEF_MAP_WIDTH = 1024;
    public static final int DEF_MAP_HEIGHT = 768;
    public static final byte TILE_SIZE = 32;
    public static int DEF_REL_WIDTH = 32;
    public static int DEF_REL_HEIGHT = 24;
    public final int MAP_WIDTH;
    public final int MAP_HEIGHT;
    public final int REL_WIDTH;
    public final int REL_HEIGHT;
    public static final transient byte MAX_LAYERS = 9;
    public static final transient byte MAP_CONSTANT = -1;
    public static final transient String[] MUSIC_CATEGORIES = new String[]{"overworld", "underground", "underwater", "castle", "athletic", "ghost house", "bonus", "boss battle", "desert", "clouds", "winter"};
    public static final transient String CLOUD = "cloud";
    public static final transient String FISH = "fish";
    public static final transient String LEAF = "leaf";
    public static final transient String GHOST = "ghost";
    public static final transient String BUBBLE = "bubble";
    public static final transient String RAIN = "rain";
    public static final transient String SNOW = "snow";
    public String mapName;
    public String creatorName;
    public String specificSong;
    public String musicCategory = MUSIC_CATEGORIES[0];
    public transient BufferedImage background;
    public String backgroundName;
    public Color bgColor;
    public LinkedList<OrderedTile[][]> tilesBackground;
    public LinkedList<OrderedTile[][]> tilesForeground;
    public InteractiveTile[][] iTiles;
    public boolean[][] spawnLocs;
    public Warp[][][] warps;
    public HashMap<String, Float> eyeCandyValues;
    public LinkedList<Platform> platforms;
    public LinkedList<EditableEntity> mapEntities;
    public static final String KILL_TILE = "killtile";
    public static final String SLIPPERY_TILE = "slippery";
    public static final String WARP = "warp";
    public static final String BRICKS = "bricks";
    public static final String ITEM = "items";
    public static final String THROW = "throwblocks";
    public static final String ONOFF = "onoff";
    public static final String PLATFORMS = "platforms";
    public static final String HAZARDS = "hazards";
    public static final String MAPITEMS = "mapitems";
    public transient HashSet<String> metadata;

    public Map() {
        this(32, 24);
    }

    public Map(int widthInTiles, int heightInTiles) {
        this.REL_WIDTH = widthInTiles;
        this.REL_HEIGHT = heightInTiles;
        this.MAP_WIDTH = this.REL_WIDTH * 32;
        this.MAP_HEIGHT = this.REL_HEIGHT * 32;
        this.mapName = "Untitled Map";
        this.creatorName = "Anonymous";
        this.backgroundName = "Overworld/JunosatoRyu1.png";
        this.bgColor = Color.BLUE;
        this.tilesBackground = new LinkedList();
        this.tilesBackground.add(new OrderedTile[this.REL_WIDTH][this.REL_HEIGHT]);
        this.tilesForeground = new LinkedList();
        this.tilesForeground.add(new OrderedTile[this.REL_WIDTH][this.REL_HEIGHT]);
        this.iTiles = new InteractiveTile[this.REL_WIDTH][this.REL_HEIGHT];
        this.platforms = new LinkedList();
        this.spawnLocs = new boolean[this.REL_WIDTH][this.REL_HEIGHT];
        this.warps = new Warp[Warp.COLOR_IDS.length][this.REL_WIDTH][this.REL_HEIGHT];
        this.mapEntities = new LinkedList();
        this.eyeCandyValues = new HashMap();
        Map.setDefaults(this.eyeCandyValues);
    }

    public static void setDefaults(HashMap<String, Float> hm) {
        hm.put(CLOUD, Float.valueOf(0.0f));
        hm.put(FISH, Float.valueOf(0.0f));
        hm.put(LEAF, Float.valueOf(0.0f));
        hm.put(GHOST, Float.valueOf(0.0f));
        hm.put(BUBBLE, Float.valueOf(0.0f));
        hm.put(RAIN, Float.valueOf(0.0f));
        hm.put(SNOW, Float.valueOf(0.0f));
    }

    public BufferedImage getBackground() {
        try {
            return this.backgroundName != null ? ImageIO.read(new File("res/gfx/backgrounds/" + this.backgroundName)) : null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<Warp> getWarpsByID(Warp w) {
        Warp[][] temp;
        ArrayList<Warp> toReturn = new ArrayList<Warp>();
        Warp[][] arr$ = temp = this.warps[w.colorID];
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Warp[] array;
            for (Warp warp : array = arr$[i$]) {
                if (warp == null || warp.isLocked()) continue;
                if (Warp.canWarpsCombine(w, warp)) {
                    toReturn.add(Warp.getCombinedWarp(w, warp));
                    continue;
                }
                toReturn.add(warp);
            }
        }
        return toReturn;
    }

    public Warp getRandomWarpByID(Warp w) {
        ArrayList<Warp> warps = this.getWarpsByID(w);
        Warp toReturn = w;
        while (Warp.canWarpsCombine(w, toReturn) && !toReturn.isLocked()) {
            toReturn = warps.get((int)(Math.random() * (double)warps.size()));
        }
        Warp combine = this.getCombiningWarp(toReturn);
        if (combine != null) {
            toReturn = Warp.getCombinedWarp(toReturn, combine);
        }
        return toReturn;
    }

    public Warp getCombiningWarp(Warp w1) {
        Warp[][] temp;
        Warp toReturn = null;
        Warp[][] arr$ = temp = this.warps[w1.colorID];
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Warp[] array;
            for (Warp w2 : array = arr$[i$]) {
                if (!Warp.canWarpsCombine(w1, w2) || w1.equals(w2)) continue;
                toReturn = w2;
                continue block0;
            }
        }
        return toReturn;
    }

    public String toString() {
        return this.mapName + " by " + this.creatorName;
    }

    public String getMapName() {
        return this.mapName;
    }

    public HashSet<String> createMetadata() {
        int i$;
        TileType t;
        OrderedTile[] array;
        int i$2;
        int len$;
        OrderedTile[][] arr$;
        OrderedTile[][] array2D;
        HashSet<String> meta = new HashSet<String>();
        Iterator<Object> i$3 = this.tilesForeground.iterator();
        block0: while (i$3.hasNext()) {
            arr$ = array2D = (OrderedTile[][])i$3.next();
            len$ = arr$.length;
            for (i$2 = 0; i$2 < len$; ++i$2) {
                for (OrderedTile ot : array = arr$[i$2]) {
                    if (ot == null || ot.getPhysicalTile() == null || (t = ot.getPhysicalTile().type) != TileType.KILL && t != TileType.KILLBOTTOM && t != TileType.KILLBOTTOM_SLIPPERY && t != TileType.KILLLEFT && t != TileType.KILLLEFT_SLIPPERY && t != TileType.KILLRIGHT && t != TileType.KILLRIGHT_SLIPPERY && t != TileType.KILLTOP) continue;
                    meta.add(KILL_TILE);
                    break block0;
                }
            }
        }
        i$3 = this.tilesForeground.iterator();
        block3: while (i$3.hasNext()) {
            arr$ = array2D = (OrderedTile[][])i$3.next();
            len$ = arr$.length;
            for (i$2 = 0; i$2 < len$; ++i$2) {
                for (OrderedTile ot : array = arr$[i$2]) {
                    if (ot == null || ot.getPhysicalTile() == null || (t = ot.getPhysicalTile().type) != TileType.SLIPPERY && t != TileType.FALLTHROUGH_SLIPPERY) continue;
                    meta.add(SLIPPERY_TILE);
                    break block3;
                }
            }
        }
        i$3 = this.tilesBackground.iterator();
        block6: while (i$3.hasNext()) {
            arr$ = array2D = (OrderedTile[][])i$3.next();
            len$ = arr$.length;
            for (i$2 = 0; i$2 < len$; ++i$2) {
                for (OrderedTile ot : array = arr$[i$2]) {
                    if (ot == null || ot.getPhysicalTile() == null || (t = ot.getPhysicalTile().type) != TileType.KILL && t != TileType.KILLBOTTOM && t != TileType.KILLBOTTOM_SLIPPERY && t != TileType.KILLLEFT && t != TileType.KILLLEFT_SLIPPERY && t != TileType.KILLRIGHT && t != TileType.KILLRIGHT_SLIPPERY && t != TileType.KILLTOP) continue;
                    meta.add(KILL_TILE);
                    break block6;
                }
            }
        }
        i$3 = this.tilesBackground.iterator();
        block9: while (i$3.hasNext()) {
            arr$ = array2D = (OrderedTile[][])i$3.next();
            len$ = arr$.length;
            for (i$2 = 0; i$2 < len$; ++i$2) {
                for (OrderedTile ot : array = arr$[i$2]) {
                    if (ot == null || ot.getPhysicalTile() == null || (t = ot.getPhysicalTile().type) != TileType.SLIPPERY && t != TileType.FALLTHROUGH_SLIPPERY) continue;
                    meta.add(SLIPPERY_TILE);
                    break block9;
                }
            }
        }
        Warp[][][] arr$2 = this.warps;
        int len$2 = arr$2.length;
        block12: for (i$ = 0; i$ < len$2; ++i$) {
            Warp[][] warp2D;
            Warp[][] arr$3 = warp2D = arr$2[i$];
            int len$3 = arr$3.length;
            for (int i$4 = 0; i$4 < len$3; ++i$4) {
                Warp[] warparray;
                for (Warp warp : warparray = arr$3[i$4]) {
                    if (warp == null) continue;
                    meta.add(WARP);
                    break block12;
                }
            }
        }
        arr$2 = this.iTiles;
        len$2 = arr$2.length;
        for (i$ = 0; i$ < len$2; ++i$) {
            Warp[][] t2;
            for (Warp[] it : t2 = arr$2[i$]) {
                if (it instanceof BrickBlock) {
                    meta.add(BRICKS);
                    continue;
                }
                if (it instanceof QuestionBlock || it instanceof ClearItemBlock) {
                    meta.add(ITEM);
                    continue;
                }
                if (it instanceof BlueThrowBlock || it instanceof RedThrowBlock || it instanceof GrayThrowBlock) {
                    meta.add(THROW);
                    continue;
                }
                if (!(it instanceof AbstractOnOffBlock)) continue;
                meta.add(ONOFF);
            }
        }
        if (this.platforms.size() > 0) {
            meta.add(PLATFORMS);
        }
        for (EditableEntity e : this.mapEntities) {
            if (!(e instanceof KuriboShoe || e instanceof Spring || e instanceof ThrowBox)) {
                meta.add(HAZARDS);
                continue;
            }
            meta.add(MAPITEMS);
        }
        if (LevelEditorScene.userTags != null) {
            for (String s : LevelEditorScene.userTags) {
                meta.add(s);
            }
        }
        return meta;
    }

    public void setEyeCandy(int readInt, int i) {
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        state.put("mapName", this.mapName);
        state.put("creatorName", this.creatorName);
        if (this.specificSong != null) {
            state.put("specificSong", this.specificSong);
        }
        state.put("musicCategory", this.musicCategory);
        state.put("background", this.background);
        state.put("backgroundName", this.backgroundName);
        state.put("bgColor", this.bgColor);
        for (int x = 0; x < this.REL_WIDTH; ++x) {
            for (int y = 0; y < this.REL_HEIGHT; ++y) {
                int layer;
                for (layer = 0; layer < this.tilesBackground.size(); ++layer) {
                    if (this.tilesBackground.get(layer)[x][y] == null) continue;
                    state.put("tbg " + layer + " " + x + " " + y, this.tilesBackground.get(layer)[x][y]);
                }
                for (layer = 0; layer < this.tilesForeground.size(); ++layer) {
                    if (this.tilesForeground.get(layer)[x][y] == null) continue;
                    state.put("tfg " + layer + " " + x + " " + y, this.tilesForeground.get(layer)[x][y]);
                }
                if (this.iTiles[x][y] != null) {
                    state.put("iTile " + x + " " + y, this.iTiles[x][y]);
                }
                state.put("spawnLoc " + x + " " + y, this.spawnLocs[x][y]);
                for (int id = 0; id < this.warps.length; ++id) {
                    if (this.warps[id][x][y] == null) continue;
                    state.put("warp " + id + " " + x + " " + y, this.warps[id][x][y]);
                }
            }
        }
        for (String s : this.eyeCandyValues.keySet()) {
            state.put("ecv " + s, this.eyeCandyValues.get(s));
        }
        for (int plat = 0; plat < this.platforms.size(); ++plat) {
            state.put("plat " + plat, this.platforms.get(plat));
        }
        for (int entity = 0; entity < this.mapEntities.size(); ++entity) {
            state.put("mapEnt " + entity, this.mapEntities.get(entity));
        }
        if (this.metadata != null) {
            state.put("metadata", this.metadata);
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        for (Object o : state.keySet()) {
            int y;
            int x;
            int y2;
            int x2;
            int layer;
            String[] items;
            String str = (String)o;
            if (o.equals("mapName")) {
                this.mapName = (String)state.get(o);
                continue;
            }
            if (o.equals("creatorName")) {
                this.creatorName = (String)state.get(o);
                continue;
            }
            if (o.equals("specificSong")) {
                this.specificSong = (String)state.get(o);
                continue;
            }
            if (o.equals("musicCategory")) {
                this.musicCategory = (String)state.get(o);
                continue;
            }
            if (o.equals("background")) {
                this.background = (BufferedImage)state.get(o);
                continue;
            }
            if (o.equals("backgroundName")) {
                this.backgroundName = (String)state.get(o);
                continue;
            }
            if (o.equals("bgColor")) {
                this.bgColor = (Color)state.get(o);
                continue;
            }
            if (str.contains("tbg")) {
                items = str.split(" ");
                layer = Integer.parseInt(items[1]);
                x2 = Integer.parseInt(items[2]);
                y2 = Integer.parseInt(items[3]);
                this.tilesBackground.get((int)layer)[x2][y2] = (OrderedTile)state.get(o);
                continue;
            }
            if (str.contains("tfg")) {
                items = str.split(" ");
                layer = Integer.parseInt(items[1]);
                x2 = Integer.parseInt(items[2]);
                y2 = Integer.parseInt(items[3]);
                this.tilesForeground.get((int)layer)[x2][y2] = (OrderedTile)state.get(o);
                continue;
            }
            if (str.contains("iTile")) {
                items = str.split(" ");
                x = Integer.parseInt(items[1]);
                y = Integer.parseInt(items[2]);
                this.iTiles[x][y] = (InteractiveTile)state.get(o);
                continue;
            }
            if (str.contains("spawnLoc")) {
                items = str.split(" ");
                x = Integer.parseInt(items[1]);
                y = Integer.parseInt(items[2]);
                this.spawnLocs[x][y] = (Boolean)state.get(o);
                continue;
            }
            if (str.contains(WARP)) {
                items = str.split(" ");
                int id = Integer.parseInt(items[1]);
                x2 = Integer.parseInt(items[2]);
                y2 = Integer.parseInt(items[3]);
                this.warps[id][x2][y2] = (Warp)state.get(o);
                continue;
            }
            if (str.contains("ecv")) {
                items = str.split(" ");
                this.eyeCandyValues.put(items[1], (Float)state.get(o));
                continue;
            }
            if (str.contains("plat")) {
                items = str.split(" ");
                this.platforms.set(Integer.parseInt(items[1]), (Platform)state.get(o));
                continue;
            }
            if (str.contains("mapEnt")) {
                items = str.split(" ");
                this.mapEntities.set(Integer.parseInt(items[1]), (EditableEntity)state.get(o));
                continue;
            }
            if (!o.equals("metadata")) continue;
            this.metadata = (HashSet)state.get(o);
        }
    }
}

