/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.Updatable;
import com.dmgame.map.AnimatedTile;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.PhysicalTile;
import java.io.Serializable;

public class OrderedTile
implements Cloneable,
Serializable,
Updatable {
    private static final long serialVersionUID = 2568267930787852178L;
    private GraphicTile gTile;
    private PhysicalTile pTile;

    public OrderedTile(GraphicTile gTile, PhysicalTile pTile) {
        this.gTile = gTile;
        this.pTile = pTile;
    }

    public OrderedTile() {
        this(null, null);
    }

    public GraphicTile getUnclonedGraphicTile() {
        return this.gTile;
    }

    public PhysicalTile getPhysicalTile() {
        return this.pTile;
    }

    public void setGraphicTile(GraphicTile gTile) {
        this.gTile = gTile;
    }

    public void setPhysicalTile(PhysicalTile pTile) {
        this.pTile = pTile;
    }

    public void nullify() {
        this.gTile = null;
        this.pTile = null;
    }

    @Override
    public void update(long timePassed) {
        if (this.gTile != null && this.gTile instanceof AnimatedTile) {
            ((AnimatedTile)this.gTile).update(timePassed);
        }
    }

    public Object clone() {
        OrderedTile clone = new OrderedTile();
        if (this.gTile != null) {
            clone.setGraphicTile((GraphicTile)this.gTile.clone());
        }
        if (this.pTile != null) {
            clone.setPhysicalTile((PhysicalTile)this.pTile.clone());
        }
        return clone;
    }

    public String toString() {
        return "[" + this.gTile.toString() + ", " + this.pTile.toString() + "]";
    }
}

