/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.map.TileType;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;

public class PhysicalTile
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5005670683757301118L;
    public static final Rectangle DEFAULT = new Rectangle(0, 0, 32, 32);
    public Shape mask;
    public TileType type;

    public PhysicalTile(TileType type, Shape mask) {
        this.type = type;
        if (mask instanceof Rectangle) {
            Rectangle r = (Rectangle)mask;
            this.mask = new Rectangle(r.x, r.y, r.width, r.height);
        } else if (mask instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)mask;
            this.mask = new Ellipse2D.Double(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        } else if (mask instanceof Polygon) {
            Polygon p = (Polygon)mask;
            this.mask = new Polygon(p.xpoints, p.ypoints, p.npoints);
        } else {
            this.mask = DEFAULT;
        }
    }

    public void translate(int x, int y) {
        if (this.mask instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)this.mask;
            r.setFrame(r.getX() + (double)x, r.getY() + (double)y, r.getWidth(), r.getHeight());
        } else if (this.mask instanceof Polygon) {
            Polygon p = (Polygon)this.mask;
            p.translate(x, y);
        }
    }

    void setLocation(int x, int y) {
        if (this.mask instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)this.mask;
            r.setFrame(x, y, r.getWidth(), r.getHeight());
        } else if (this.mask instanceof Polygon) {
            Polygon p = (Polygon)this.mask;
            p.translate(p.getBounds().x - x, p.getBounds().y - y);
        }
    }

    public void setPolygonMask(Polygon p) {
        this.mask = p;
    }

    public Object clone() {
        return new PhysicalTile(this.type, this.mask);
    }

    public String toString() {
        return "[" + this.type.toString() + ", " + this.mask.getClass().getName() + "]";
    }
}

