/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.PathFollower;
import com.dmgame.Updatable;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.TileType;
import com.dmgame.net.client.NetplayClient;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Platform
extends Rectangle
implements Serializable,
Updatable {
    private static final long serialVersionUID = -8267181750310301157L;
    protected Shape path;
    public double startTime;
    public PathFollower helper;
    public static final transient int LEFT = 0;
    public static final transient int RIGHT = 1;
    public static final transient int UP = 2;
    public static final transient int DOWN = 3;
    public PhysicalTile[][] pTiles;
    public GraphicTile[][] gTiles;
    public InteractiveTile[][] iTiles;
    private static final int DEFAULT_SIZE = 10;
    public double platformX;
    public double platformY;
    protected int x;
    protected int y;
    public double hspeed;
    public double vspeed;
    public double speed;
    private boolean reverse;

    public Platform() {
        this.pTiles = new PhysicalTile[10][10];
        this.gTiles = new GraphicTile[10][10];
        this.iTiles = new InteractiveTile[10][10];
        this.path = new RoundRectangle2D.Double(32.0, 32.0, 256.0, 128.0, 64.0, 64.0);
        this.x = 0;
        this.y = 0;
        this.height = this.width = 320;
        this.speed = 5.0;
        this.startTime = 0.0;
        this.setPathIterator();
        this.setLocation(this.helper.getCurrentPoint());
    }

    public Platform(int width, int height) {
        this.pTiles = new PhysicalTile[width][height];
        this.gTiles = new GraphicTile[width][height];
        this.iTiles = new InteractiveTile[width][height];
        this.path = new RoundRectangle2D.Double(32.0, 32.0, 256.0, 128.0, 64.0, 64.0);
        this.x = 0;
        this.y = 0;
        this.width = width * 32;
        this.height = height * 32;
        this.speed = 5.0;
        this.startTime = 0.0;
        this.setPathIterator();
        this.setLocation(this.helper.getCurrentPoint());
    }

    public void resetToZero() {
        this.setLocation(0, 0);
        this.x -= 32;
        this.y -= 32;
        this.width += 64;
        this.height += 64;
        for (int y = 0; y < this.pTiles[0].length; ++y) {
            for (int x = 0; x < this.pTiles.length; ++x) {
                if (this.pTiles[x][y] != null) {
                    this.pTiles[x][y].setLocation(x * 32, y * 32);
                }
                if (this.iTiles[x][y] == null) continue;
                this.iTiles[x][y].setMapRelCoords(x, y);
                this.iTiles[x][y].platOffsetX = 0.0f;
                this.iTiles[x][y].platOffsetY = 0.0f;
            }
        }
    }

    public void setPathIterator() {
        this.helper = new PathFollower(this.path, this.reverse, this.speed, this.startTime);
        this.setLocation(this.helper.getCurrentPoint());
    }

    @Override
    public void update(long timePassed) {
        if (NetplayClient.running) {
            return;
        }
        this.helper.update(timePassed);
        this.setLocation(this.helper.getCurrentPoint());
    }

    public void setPath(Shape path) {
        this.path = path;
        this.helper = new PathFollower(path, this.reverse, this.speed, this.startTime);
    }

    public Shape getPath() {
        return this.path;
    }

    public void refitPlatform() {
        int furthestTop = this.pTiles.length > this.pTiles[0].length ? this.pTiles.length : this.pTiles[0].length;
        int furthestLeft = furthestTop;
        int furthestBottom = -1;
        int furthestRight = -1;
        for (int y = 0; y < this.pTiles[0].length; ++y) {
            for (int x = 0; x < this.pTiles.length; ++x) {
                if (this.pTiles[x][y] == null && this.iTiles[x][y] == null) continue;
                if (x < furthestLeft) {
                    furthestLeft = x;
                }
                if (y < furthestTop) {
                    furthestTop = y;
                }
                if (x > furthestRight) {
                    furthestRight = x;
                }
                if (y <= furthestBottom) continue;
                furthestBottom = y;
            }
        }
        while (furthestLeft > 0) {
            this.shiftTiles(0);
            --furthestLeft;
            --furthestRight;
        }
        while (furthestTop > 0) {
            this.shiftTiles(2);
            --furthestTop;
            --furthestBottom;
        }
        this.setArraySize(furthestRight + 3, furthestBottom + 3);
        this.shiftTiles(1);
        this.shiftTiles(3);
        this.width = this.pTiles.length * 32;
        this.height = this.pTiles[0].length * 32;
    }

    private void setArraySize(int width, int height) {
        PhysicalTile[][] nextPTiles = new PhysicalTile[width][height];
        GraphicTile[][] nextGTiles = new GraphicTile[width][height];
        InteractiveTile[][] nextITiles = new InteractiveTile[width][height];
        int maxLength = this.pTiles[0].length < nextPTiles[0].length ? this.pTiles[0].length : nextPTiles[0].length;
        int maxLoop = this.pTiles.length < nextPTiles.length ? this.pTiles.length : nextPTiles.length;
        this.width = maxLoop * 32;
        this.height = maxLength * 32;
        for (int i = 0; i < maxLoop; ++i) {
            System.arraycopy(this.pTiles[i], 0, nextPTiles[i], 0, maxLength);
            System.arraycopy(this.gTiles[i], 0, nextGTiles[i], 0, maxLength);
            System.arraycopy(this.iTiles[i], 0, nextITiles[i], 0, maxLength);
        }
        this.pTiles = nextPTiles;
        this.gTiles = nextGTiles;
        this.iTiles = nextITiles;
    }

    public void setDirection(boolean direction) {
        this.reverse = direction;
    }

    public boolean getDirection() {
        return this.reverse;
    }

    public byte[] prepareNetworkUpdate(byte i) {
        byte[] updateData = new byte[18];
        updateData[0] = 50;
        updateData[1] = i;
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(this.x);
        System.arraycopy(buffer.array(), 0, updateData, 2, 4);
        buffer = ByteBuffer.allocate(4);
        buffer.putFloat(this.y);
        System.arraycopy(buffer.array(), 0, updateData, 6, 4);
        buffer = ByteBuffer.allocate(4);
        buffer.putFloat((float)this.hspeed);
        System.arraycopy(buffer.array(), 0, updateData, 10, 4);
        buffer = ByteBuffer.allocate(4);
        buffer.putFloat((float)this.vspeed);
        System.arraycopy(buffer.array(), 0, updateData, 14, 4);
        return updateData;
    }

    public void getNetworkUpdate(byte[] data) {
        this.x = Math.round(ByteBuffer.wrap(data, 2, 4).getFloat());
        this.y = Math.round(ByteBuffer.wrap(data, 6, 4).getFloat());
        this.hspeed = ByteBuffer.wrap(data, 10, 4).getFloat();
        this.vspeed = ByteBuffer.wrap(data, 14, 4).getFloat();
        this.setLocation(this.x, this.y);
    }

    public void alterSize(int width, int height) {
        int changeWidth = this.pTiles.length + width;
        int changeHeight = this.pTiles[0].length + height;
        if (changeWidth < 1) {
            changeWidth = 1;
        }
        if (changeHeight < 1) {
            changeHeight = 1;
        }
        PhysicalTile[][] nextPTiles = new PhysicalTile[changeWidth][changeHeight];
        GraphicTile[][] nextGTiles = new GraphicTile[changeWidth][changeHeight];
        InteractiveTile[][] nextITiles = new InteractiveTile[changeWidth][changeHeight];
        int maxLength = this.pTiles[0].length < nextPTiles[0].length ? this.pTiles[0].length : nextPTiles[0].length;
        int maxLoop = this.pTiles.length < nextPTiles.length ? this.pTiles.length : nextPTiles.length;
        this.width = maxLoop * 32;
        this.height = maxLength * 32;
        for (int i = 0; i < maxLoop; ++i) {
            System.arraycopy(this.pTiles[i], 0, nextPTiles[i], 0, maxLength);
            System.arraycopy(this.gTiles[i], 0, nextGTiles[i], 0, maxLength);
            System.arraycopy(this.iTiles[i], 0, nextITiles[i], 0, maxLength);
        }
        this.pTiles = nextPTiles;
        this.gTiles = nextGTiles;
        this.iTiles = nextITiles;
    }

    public void shiftTiles(int dir) {
        block15: {
            int x;
            block17: {
                block16: {
                    int y;
                    block14: {
                        if (dir != 0) break block14;
                        for (int y2 = 0; y2 < this.pTiles[0].length; ++y2) {
                            if (this.gTiles[0][y2] == null && this.iTiles[0][y2] == null && (this.pTiles[0][y2] == null || this.pTiles[0][y2].type == TileType.NONE)) continue;
                            return;
                        }
                        for (int x2 = 0; x2 < this.pTiles.length - 1; ++x2) {
                            System.arraycopy(this.pTiles[x2 + 1], 0, this.pTiles[x2], 0, this.pTiles[0].length);
                            for (PhysicalTile p : this.pTiles[x2]) {
                                if (p == null) continue;
                                p.translate(-32, 0);
                            }
                            System.arraycopy(this.gTiles[x2 + 1], 0, this.gTiles[x2], 0, this.gTiles[0].length);
                            System.arraycopy(this.iTiles[x2 + 1], 0, this.iTiles[x2], 0, this.iTiles[0].length);
                        }
                        int chk = this.gTiles.length - 1;
                        for (int y3 = 0; y3 < this.pTiles[0].length; ++y3) {
                            this.pTiles[chk][y3] = null;
                            this.gTiles[chk][y3] = null;
                            this.iTiles[chk][y3] = null;
                        }
                        break block15;
                    }
                    if (dir != 1) break block16;
                    int chk = this.gTiles.length - 1;
                    for (y = 0; y < this.pTiles[0].length; ++y) {
                        if (this.gTiles[chk][y] == null && this.iTiles[chk][y] == null && (this.pTiles[chk][y] == null || this.pTiles[chk][y].type == TileType.NONE)) continue;
                        return;
                    }
                    for (int x3 = this.pTiles.length - 1; x3 > 0; --x3) {
                        System.arraycopy(this.pTiles[x3 - 1], 0, this.pTiles[x3], 0, this.pTiles[0].length);
                        for (PhysicalTile p : this.pTiles[x3]) {
                            if (p == null) continue;
                            p.translate(32, 0);
                        }
                        System.arraycopy(this.gTiles[x3 - 1], 0, this.gTiles[x3], 0, this.gTiles[0].length);
                        System.arraycopy(this.iTiles[x3 - 1], 0, this.iTiles[x3], 0, this.iTiles[0].length);
                    }
                    for (y = 0; y < this.pTiles[0].length; ++y) {
                        this.pTiles[0][y] = null;
                        this.gTiles[0][y] = null;
                        this.iTiles[0][y] = null;
                    }
                    break block15;
                }
                if (dir != 2) break block17;
                for (int x4 = 0; x4 < this.pTiles.length; ++x4) {
                    if (this.gTiles[x4][0] == null && this.iTiles[x4][0] == null && (this.pTiles[x4][0] == null || this.pTiles[x4][0].type == TileType.NONE)) continue;
                    return;
                }
                int chk = this.pTiles[0].length - 1;
                for (int x5 = 0; x5 < this.pTiles.length; ++x5) {
                    System.arraycopy(this.pTiles[x5], 1, this.pTiles[x5], 0, this.pTiles[0].length - 1);
                    for (PhysicalTile p : this.pTiles[x5]) {
                        if (p == null) continue;
                        p.translate(0, -32);
                    }
                    System.arraycopy(this.gTiles[x5], 1, this.gTiles[x5], 0, this.gTiles[0].length - 1);
                    System.arraycopy(this.iTiles[x5], 1, this.iTiles[x5], 0, this.iTiles[0].length - 1);
                    this.pTiles[x5][chk] = null;
                    this.gTiles[x5][chk] = null;
                    this.iTiles[x5][chk] = null;
                }
                break block15;
            }
            if (dir != 3) break block15;
            int chk = this.pTiles[0].length - 1;
            for (x = 0; x < this.pTiles[0].length; ++x) {
                if (this.gTiles[x][chk] == null && this.iTiles[x][chk] == null && (this.pTiles[x][chk] == null || this.pTiles[x][chk].type == TileType.NONE)) continue;
                return;
            }
            for (x = 0; x < this.pTiles.length; ++x) {
                System.arraycopy(this.pTiles[x], 0, this.pTiles[x], 1, this.pTiles[0].length - 1);
                for (PhysicalTile p : this.pTiles[x]) {
                    if (p == null) continue;
                    p.translate(0, 32);
                }
                System.arraycopy(this.gTiles[x], 0, this.gTiles[x], 1, this.gTiles[0].length - 1);
                System.arraycopy(this.iTiles[x], 0, this.iTiles[x], 1, this.iTiles[0].length - 1);
                this.pTiles[x][0] = null;
                this.gTiles[x][0] = null;
                this.iTiles[x][0] = null;
            }
        }
    }

    public int getCurrentX() {
        return this.x;
    }

    public int getCurrentY() {
        return this.y;
    }

    @Override
    public void setLocation(int newX, int newY) {
        for (int y = 0; y < this.pTiles[0].length; ++y) {
            for (int x = 0; x < this.pTiles.length; ++x) {
                if (this.pTiles[x][y] != null) {
                    this.pTiles[x][y].translate(newX - this.x, newY - this.y);
                }
                if (this.iTiles[x][y] == null) continue;
                this.iTiles[x][y].setMapRelCoords(x, y);
                this.iTiles[x][y].platOffsetX = newX;
                this.iTiles[x][y].platOffsetY = newY;
            }
        }
        this.hspeed = newX - this.x;
        this.vspeed = newY - this.y;
        this.x = newX;
        this.y = newY;
        ((Rectangle)this).x = this.x;
        ((Rectangle)this).y = this.y;
    }

    public void setLocation(Point2D point) {
        this.setLocation((int)Math.round(point.getX() - (double)(this.width / 2)), (int)Math.round(point.getY() - (double)(this.height / 2)));
    }
}

