/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.Direction;
import java.io.Serializable;

public enum TileType implements Serializable
{
    SOLID,
    FALLTHROUGH,
    SLIPPERY,
    KILL,
    KILLTOP,
    KILLBOTTOM,
    KILLLEFT,
    KILLRIGHT,
    FALLTHROUGH_SLIPPERY,
    KILLBOTTOM_SLIPPERY,
    KILLLEFT_SLIPPERY,
    KILLRIGHT_SLIPPERY,
    NONE,
    INTERACTIVE,
    WARP;


    public static TileType getNext(TileType t) {
        switch (t) {
            case SOLID: {
                return FALLTHROUGH;
            }
            case FALLTHROUGH: {
                return SLIPPERY;
            }
            case SLIPPERY: {
                return KILL;
            }
            case KILL: {
                return KILLTOP;
            }
            case KILLTOP: {
                return KILLBOTTOM;
            }
            case KILLBOTTOM: {
                return KILLLEFT;
            }
            case KILLLEFT: {
                return KILLRIGHT;
            }
            case KILLRIGHT: {
                return FALLTHROUGH_SLIPPERY;
            }
            case FALLTHROUGH_SLIPPERY: {
                return KILLBOTTOM_SLIPPERY;
            }
            case KILLBOTTOM_SLIPPERY: {
                return KILLLEFT_SLIPPERY;
            }
            case KILLLEFT_SLIPPERY: {
                return KILLRIGHT_SLIPPERY;
            }
            case KILLRIGHT_SLIPPERY: {
                return NONE;
            }
            case NONE: {
                return SOLID;
            }
        }
        return NONE;
    }

    public static TileType getByInt(int readInt) {
        switch (readInt) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SOLID;
            }
            case 2: {
                return FALLTHROUGH;
            }
            case 3: {
                return SLIPPERY;
            }
            case 4: {
                return KILL;
            }
            case 5: {
                return KILLTOP;
            }
            case 6: {
                return KILLBOTTOM;
            }
            case 7: {
                return KILLLEFT;
            }
            case 8: {
                return KILLRIGHT;
            }
            case 9: {
                return FALLTHROUGH_SLIPPERY;
            }
            case 10: {
                return KILLBOTTOM_SLIPPERY;
            }
            case 11: {
                return KILLLEFT_SLIPPERY;
            }
            case 12: {
                return KILLRIGHT_SLIPPERY;
            }
        }
        return NONE;
    }

    public boolean isSolid(Direction dir) {
        if (this == SOLID || this == SLIPPERY || this == INTERACTIVE) {
            return true;
        }
        if (dir == Direction.UP) {
            switch (this) {
                case KILLTOP: 
                case KILLLEFT: 
                case KILLRIGHT: 
                case KILLLEFT_SLIPPERY: 
                case KILLRIGHT_SLIPPERY: {
                    return true;
                }
            }
            return false;
        }
        if (dir == Direction.DOWN) {
            switch (this) {
                case FALLTHROUGH: 
                case KILLBOTTOM: 
                case KILLLEFT: 
                case KILLRIGHT: 
                case FALLTHROUGH_SLIPPERY: 
                case KILLLEFT_SLIPPERY: 
                case KILLRIGHT_SLIPPERY: {
                    return true;
                }
            }
            return false;
        }
        if (dir == Direction.RIGHT) {
            switch (this) {
                case KILLTOP: 
                case KILLRIGHT: 
                case KILLRIGHT_SLIPPERY: {
                    return true;
                }
            }
            return false;
        }
        if (dir == Direction.LEFT) {
            switch (this) {
                case KILLTOP: 
                case KILLLEFT: 
                case KILLLEFT_SLIPPERY: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean willKill(Direction dir) {
        if (this == KILL) {
            return true;
        }
        if (dir == Direction.UP) {
            switch (this) {
                case KILLBOTTOM: {
                    return true;
                }
            }
            return false;
        }
        if (dir == Direction.LEFT) {
            switch (this) {
                case KILLRIGHT: 
                case KILLRIGHT_SLIPPERY: {
                    return true;
                }
            }
            return false;
        }
        if (dir == Direction.RIGHT) {
            switch (this) {
                case KILLLEFT: 
                case KILLLEFT_SLIPPERY: {
                    return true;
                }
            }
            return false;
        }
        return this == KILLTOP;
    }
}

