/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.Animation;
import com.dmgame.SMWException;
import com.dmgame.map.AnimatedTile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public final class Tilesets {
    public static ArrayList<AnimatedTile[][]> aTiles = new ArrayList();
    public static HashMap<String, BufferedImage> tilesets;

    public static BufferedImage get(String name) {
        if (tilesets == null) {
            tilesets = new HashMap();
        }
        if (tilesets.containsKey(name)) {
            return tilesets.get(name);
        }
        try {
            tilesets.put(name, ImageIO.read(new File("res/gfx/tilesets/" + name + "/tileset.png")));
            return tilesets.get(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean load(File loc) {
        if (tilesets.containsKey(loc.getName())) {
            return true;
        }
        try {
            File f = new File(loc.getAbsolutePath() + "/tileset.png");
            if (f.exists()) {
                tilesets.put(loc.getName(), ImageIO.read(f));
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean loadAnimated(File loc) {
        if (tilesets.containsKey(loc.getName())) {
            return true;
        }
        try {
            File f;
            int i = 0;
            while ((f = new File(loc.getAbsolutePath() + "/" + (i + 1) + ".png")).exists()) {
                tilesets.put(loc.getName(), ImageIO.read(f));
                ++i;
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static AnimatedTile[][] getAnimated(String name) {
        int i;
        ArrayList<BufferedImage> tilesheet = new ArrayList<BufferedImage>();
        int i2 = 0;
        while (true) {
            File f = new File("res/gfx/tilesets/" + name + "/" + (i2 + 1) + ".png");
            try {
                tilesheet.add(ImageIO.read(f));
            }
            catch (IOException ex) {
                break;
            }
            ++i2;
        }
        BufferedImage[] tilesheetArray = new BufferedImage[tilesheet.size()];
        for (i = 0; i < tilesheetArray.length; ++i) {
            tilesheetArray[i] = (BufferedImage)tilesheet.get(i);
        }
        try {
            aTiles.add(new AnimatedTile[tilesheetArray[0].getWidth() / 32][tilesheetArray[0].getHeight() / 32]);
            for (i = 0; i < aTiles.get(aTiles.size() - 1).length; ++i) {
                for (int j = 0; j < aTiles.get(aTiles.size() - 1)[0].length; ++j) {
                    BufferedImage[] subImg = new BufferedImage[tilesheetArray.length];
                    for (int k = 0; k < tilesheetArray.length; ++k) {
                        subImg[k] = tilesheetArray[k].getSubimage(i * 32, j * 32, 32, 32);
                    }
                    Tilesets.aTiles.get((int)(Tilesets.aTiles.size() - 1))[i][j] = new AnimatedTile(new Animation(190L, subImg), name, i, j);
                }
            }
        }
        catch (SMWException ex) {
            ex.printStackTrace();
            return null;
        }
        return aTiles.get(aTiles.size() - 1);
    }

    @Deprecated
    public static AnimatedTile[][] get(int num) {
        int i;
        if (aTiles.isEmpty()) {
            for (int i2 = 0; i2 <= 9; ++i2) {
                aTiles.add(null);
            }
        }
        if (aTiles.size() >= num && aTiles.get(num) != null) {
            return aTiles.get(num);
        }
        BufferedImage[] tilesheet = new BufferedImage[num];
        for (i = 0; i < num; ++i) {
            File f = new File("res/gfx/tilesets/anim/" + num + "/" + (i + 1) + ".png");
            try {
                tilesheet[i] = ImageIO.read(f);
                continue;
            }
            catch (IOException ex) {
                return null;
            }
        }
        try {
            aTiles.set(num, new AnimatedTile[tilesheet[0].getWidth()][tilesheet[0].getHeight()]);
            for (i = 0; i < aTiles.get(num).length / 32; ++i) {
                for (int j = 0; j < aTiles.get(num)[0].length / 32; ++j) {
                    BufferedImage[] subImg = new BufferedImage[tilesheet.length];
                    for (int k = 0; k < tilesheet.length; ++k) {
                        subImg[k] = tilesheet[k].getSubimage(i * 32, j * 32, 32, 32);
                    }
                    Tilesets.aTiles.get((int)num)[i][j] = new AnimatedTile(new Animation(1000L, subImg), "" + num, i, j);
                }
            }
        }
        catch (SMWException ex) {
            return null;
        }
        return aTiles.get(num);
    }
}

