/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Utility;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class Warp
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6699891531224160870L;
    public static final transient Color[] COLOR_IDS = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.CYAN, Color.PINK, Color.MAGENTA, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.WHITE};
    public static final transient byte RED = 0;
    public static final transient byte ORANGE = 1;
    public static final transient byte YELLOW = 2;
    public static final transient byte GREEN = 3;
    public static final transient byte BLUE = 4;
    public static final transient byte CYAN = 5;
    public static final transient byte PINK = 6;
    public static final transient byte MAGENTA = 7;
    public static final transient byte LIGHT_GRAY = 8;
    public static final transient byte GRAY = 9;
    public static final transient byte DARK_GRAY = 10;
    public static final transient byte WHITE = 11;
    public transient BufferedImage sprite;
    public Direction dir;
    public Color id;
    public byte colorID;
    public int mapRelX;
    public int mapRelY;
    public float useX;
    public float useY;
    private transient boolean locked;
    private transient Rectangle bbox;

    public Warp(Direction dir, Color id) {
        this.dir = dir;
        this.id = id;
        this.colorID = 0;
        while (!id.equals(COLOR_IDS[this.colorID])) {
            this.colorID = (byte)(this.colorID + 1);
        }
        this.changeColor(id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.colorID;
        result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.mapRelX;
        result = 31 * result + this.mapRelY;
        result = 31 * result + Float.floatToIntBits(this.useX);
        result = 31 * result + Float.floatToIntBits(this.useY);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warp)) {
            return false;
        }
        Warp other = (Warp)obj;
        if (this.colorID != other.colorID) {
            return false;
        }
        if (this.dir != other.dir) {
            return false;
        }
        if (this.mapRelX != other.mapRelX) {
            return false;
        }
        return this.mapRelY == other.mapRelY;
    }

    public void changeColor(Color id) {
        this.id = id;
        try {
            this.sprite = ImageIO.read(new File("res/gfx/leveleditor/warp.png"));
            switch (this.dir) {
                case NORTH: {
                    this.sprite = Utility.rotateImage90(this.sprite, (byte)0);
                    break;
                }
                case EAST: {
                    this.sprite = Utility.rotateImage90(this.sprite, (byte)1);
                    break;
                }
                case SOUTH: {
                    this.sprite = Utility.rotateImage90(this.sprite, (byte)2);
                    break;
                }
                case WEST: {
                    this.sprite = Utility.rotateImage90(this.sprite, (byte)3);
                    break;
                }
            }
            this.sprite = this.replaceColor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedImage replaceColor() {
        for (int i = 0; i < this.sprite.getWidth(); ++i) {
            for (int j = 0; j < this.sprite.getHeight(); ++j) {
                Color temp = new Color(this.sprite.getRGB(i, j), true);
                if (!temp.equals(Color.WHITE)) continue;
                this.sprite.setRGB(i, j, this.id.getRGB());
            }
        }
        return this.sprite;
    }

    public void setRelCoords(int mapRelX, int mapRelY) {
        this.mapRelX = mapRelX;
        this.mapRelY = mapRelY;
        this.useX = mapRelX * 32;
        this.useY = mapRelY * 32;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject((Object)this.dir);
        out.writeObject(this.id);
        out.writeByte(this.colorID);
        out.writeInt(this.mapRelX);
        out.writeInt(this.mapRelY);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.dir = (Direction)((Object)in.readObject());
        this.id = (Color)in.readObject();
        this.colorID = in.readByte();
        this.mapRelX = in.readInt();
        this.mapRelY = in.readInt();
        this.changeColor(this.id);
    }

    public String toString() {
        return (Object)((Object)this.dir) + "; " + this.colorID + "; " + "(" + this.useX + ", " + this.useY + ")";
    }

    public Object clone() {
        Warp w = new Warp(this.dir, this.id);
        w.setRelCoords(this.mapRelX, this.mapRelY);
        return w;
    }

    public static boolean canWarpsCombine(Warp w1, Warp w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        if (!w1.id.equals(w2.id)) {
            return false;
        }
        if (w1.dir == Direction.NORTH && w2.dir == Direction.NORTH || w1.dir == Direction.SOUTH && w2.dir == Direction.SOUTH) {
            return Math.abs(w1.mapRelX - w2.mapRelX) <= 1 && w1.mapRelY == w2.mapRelY;
        }
        if (w1.dir == Direction.EAST && w2.dir == Direction.EAST || w1.dir == Direction.WEST && w2.dir == Direction.WEST) {
            return Math.abs(w1.mapRelY - w2.mapRelY) <= 1 && w1.mapRelX == w2.mapRelX;
        }
        return false;
    }

    public static Warp getCombinedWarp(Warp w1, Warp w2) {
        if (!Warp.canWarpsCombine(w1, w2)) {
            return null;
        }
        if (w1.equals(w2)) {
            return w1;
        }
        Warp toReturn = new Warp(w1.dir, w1.id);
        if (w1.dir == Direction.NORTH && w2.dir == Direction.NORTH || w1.dir == Direction.SOUTH && w2.dir == Direction.SOUTH) {
            toReturn.mapRelY = w1.mapRelY;
            toReturn.mapRelX = (w1.mapRelX + w2.mapRelX) / 2;
            toReturn.useY = w1.useY;
            toReturn.useX = (w1.useX + w2.useX) / 2.0f;
            return toReturn;
        }
        if (w1.dir == Direction.EAST && w2.dir == Direction.EAST || w1.dir == Direction.WEST && w2.dir == Direction.WEST) {
            toReturn.mapRelX = w1.mapRelX;
            toReturn.mapRelY = (w1.mapRelY + w2.mapRelY) / 2;
            toReturn.useX = w1.useX;
            toReturn.useY = (w1.useY + w2.useY) / 2.0f;
            return toReturn;
        }
        return null;
    }

    public static void setLockedCombinedWarp(Warp combined, boolean locked) {
        GameLogic.currentMap.warps[combined.colorID][combined.mapRelX][combined.mapRelY].setLocked(locked);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        Warp w = GameLogic.currentMap.getCombiningWarp(this);
        if (w != null) {
            w.locked = locked;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Rectangle getBBox() {
        if (this.bbox == null) {
            this.bbox = new Rectangle((int)this.useX - 2, (int)this.useY - 2, 36, 36);
        }
        return this.bbox;
    }
}

