/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.SMWException;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.imageio.ImageIO;

public abstract class AbstractOnOffBlock
extends InteractiveTile {
    private static final long serialVersionUID = 2291784932704039103L;
    public boolean on;
    protected transient Animation onAnim;
    protected transient Animation offAnim;
    protected int onAnimX;
    protected int onAnimY;
    protected int offAnimX;
    protected int offAnimY;

    public AbstractOnOffBlock(Animation tile, int x, int y) {
        super(tile, x, y);
        this.on = y == 0;
        this.setOnOffAnim();
    }

    public void setOn(boolean on) {
        this.on = on;
        if (on) {
            GameLogic.usePTiles[this.mapRelX][this.mapRelY] = new PhysicalTile(TileType.INTERACTIVE, PhysicalTile.DEFAULT);
            GameLogic.usePTiles[this.mapRelX][this.mapRelY].translate(this.mapRelX * 32, this.mapRelY * 32);
        } else {
            GameLogic.usePTiles[this.mapRelX][this.mapRelY] = this.hiddenPTile;
        }
    }

    @Override
    public void react(Interactive i, Direction dir) {
    }

    @Override
    public void update(long timePassed) {
        this.tile = this.on ? this.onAnim : this.offAnim;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.mapRelX);
        out.writeInt(this.mapRelY);
        out.writeBoolean(this.on);
        out.writeInt(this.onAnimX);
        out.writeInt(this.onAnimY);
        out.writeInt(this.offAnimX);
        out.writeInt(this.offAnimY);
    }

    private void readObject(ObjectInputStream in) throws IOException, SMWException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.mapRelX = in.readInt();
        this.mapRelY = in.readInt();
        this.on = in.readBoolean();
        this.onAnimX = in.readInt();
        this.onAnimY = in.readInt();
        this.offAnimX = in.readInt();
        this.offAnimY = in.readInt();
        BufferedImage[] tileTilesets = new BufferedImage[4];
        BufferedImage[] onAnimTilesets = new BufferedImage[4];
        BufferedImage[] offAnimTilesets = new BufferedImage[4];
        for (int i = 0; i < 4; ++i) {
            tileTilesets[i] = ImageIO.read(new File("res/gfx/tilesets/interactive/" + (i + 1) + ".png")).getSubimage(this.x, this.y, 32, 32);
            onAnimTilesets[i] = ImageIO.read(new File("res/gfx/tilesets/interactive/" + (i + 1) + ".png")).getSubimage(this.onAnimX, this.onAnimY, 32, 32);
            offAnimTilesets[i] = ImageIO.read(new File("res/gfx/tilesets/interactive/" + (i + 1) + ".png")).getSubimage(this.offAnimX, this.offAnimY, 32, 32);
        }
        this.tile = new Animation(190L, tileTilesets);
        this.onAnim = new Animation(190L, onAnimTilesets);
        this.offAnim = new Animation(190L, offAnimTilesets);
    }

    protected abstract void setOnOffAnim();

    public abstract void setColorOnOff(Map var1);

    public abstract void setColorOnOff(Platform var1);
}

