/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Direction;
import com.dmgame.Interactive;
import com.dmgame.Utility;
import com.dmgame.entity.BlueThrowBlockEntity;
import com.dmgame.entity.Player;
import com.dmgame.map.InteractiveTile;
import com.dmgame.net.client.NetplayClient;

public class BlueThrowBlock
extends InteractiveTile {
    private static final long serialVersionUID = -5281036430336918746L;

    public BlueThrowBlock() {
        super(Utility.getSubanimation(InteractiveTile.tileset, 192, 0, 32, 32), 192, 0);
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Player && ((Player)i).canHoldItem()) {
            Player player = (Player)i;
            switch (direction) {
                case DOWN: {
                    if (!player.isControlDown()) break;
                    if (!NetplayClient.running) {
                        player.giveHoldItem(new BlueThrowBlockEntity(this.mapX, this.mapY, player));
                    }
                    this.removeSelfFromMap();
                    break;
                }
                case LEFT: {
                    if (player.isFacingRight() || !player.isControlDown()) break;
                    if (!NetplayClient.running) {
                        player.giveHoldItem(new BlueThrowBlockEntity(this.mapX, this.mapY, player));
                    }
                    this.removeSelfFromMap();
                    break;
                }
                case RIGHT: {
                    if (!player.isFacingRight() || !player.isControlDown()) break;
                    if (!NetplayClient.running) {
                        player.giveHoldItem(new BlueThrowBlockEntity(this.mapX, this.mapY, player));
                    }
                    this.removeSelfFromMap();
                    break;
                }
            }
        }
    }

    @Override
    public Object clone() {
        return new BlueThrowBlock();
    }
}

