/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.UnthreadedTimer;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.BobOmb;
import com.dmgame.entity.powerups.Bomb;
import com.dmgame.entity.powerups.Boomerang;
import com.dmgame.entity.powerups.BulletBill;
import com.dmgame.entity.powerups.Feather;
import com.dmgame.entity.powerups.FireFlower;
import com.dmgame.entity.powerups.FiveUp;
import com.dmgame.entity.powerups.Hammer;
import com.dmgame.entity.powerups.IceWand;
import com.dmgame.entity.powerups.Leaf;
import com.dmgame.entity.powerups.ModBlock;
import com.dmgame.entity.powerups.MysteryMushroom;
import com.dmgame.entity.powerups.OneUp;
import com.dmgame.entity.powerups.PWing;
import com.dmgame.entity.powerups.Podobo;
import com.dmgame.entity.powerups.PoisonMushroom;
import com.dmgame.entity.powerups.PowBlock;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.powerups.SlowdownClock;
import com.dmgame.entity.powerups.SpeedupClock;
import com.dmgame.entity.powerups.Starman;
import com.dmgame.entity.powerups.TanookiSuit;
import com.dmgame.entity.powerups.ThreeUp;
import com.dmgame.entity.powerups.TwoUp;
import com.dmgame.leveleditor.LevelEditorScene;
import com.dmgame.map.InteractiveTile;
import com.dmgame.net.client.NetplayClient;
import com.dmgame.net.server.NetplayServer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ClearItemBlock
extends InteractiveTile {
    private static final long serialVersionUID = 7559405879949232301L;
    public transient PowerUp itemInside;
    public transient BufferedImage itemInsideImage;
    public final transient long CHANGE_TIME = 300L;
    public transient boolean disabled = false;
    private final transient long MAX_DISABLE_TIME = 2000L;
    private transient UnthreadedTimer itemSetDelayTimer;
    private transient UnthreadedTimer disableTimer;
    private int serverPowerup;

    public ClearItemBlock() {
        super(Utility.getSubanimation(InteractiveTile.tileset, 0, 32, 32, 32), 0, 32);
        if (!LevelEditorScene.isRunning()) {
            this.cyclePowerups();
        }
    }

    @Override
    protected void setupTimers() {
        super.setupTimers();
        this.itemSetDelayTimer = new UnthreadedTimer(300L){

            @Override
            public void end() {
                ClearItemBlock.this.cyclePowerups();
                this.reset();
            }
        };
        this.disableTimer = new UnthreadedTimer(2000L){

            @Override
            public void end() {
                ClearItemBlock.this.disabled = false;
                this.reset();
            }
        };
    }

    public void generateNetPowerup(int powerUp, boolean spawn) {
        this.setItemInside(powerUp);
        if (spawn) {
            this.itemInside.spawn();
        }
    }

    private void setItemInside(int powerUp) {
        float mapPlaceX = (float)(this.mapRelX * 32) + this.platOffsetX;
        float mapPlaceY = (float)(this.mapRelY * 32) + this.platOffsetY;
        switch (powerUp) {
            case 0: {
                this.itemInside = new BobOmb(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 1: {
                this.itemInside = new Bomb(mapPlaceX, mapPlaceY);
                break;
            }
            case 2: {
                this.itemInside = new Boomerang(mapPlaceX, mapPlaceY);
                break;
            }
            case 3: {
                this.itemInside = new BulletBill(mapPlaceX, mapPlaceY, null);
                break;
            }
            case 4: {
                this.itemInside = new Feather(mapPlaceX, mapPlaceY);
                break;
            }
            case 5: {
                this.itemInside = new FireFlower(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 6: {
                this.itemInside = new Hammer(mapPlaceX, mapPlaceY);
                break;
            }
            case 7: {
                this.itemInside = new IceWand(mapPlaceX, mapPlaceY);
                break;
            }
            case 8: {
                this.itemInside = new Leaf(mapPlaceX, mapPlaceY);
                break;
            }
            case 9: {
                this.itemInside = new ModBlock(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 10: {
                this.itemInside = new MysteryMushroom(mapPlaceX, mapPlaceY);
                break;
            }
            case 11: {
                this.itemInside = new OneUp(mapPlaceX, mapPlaceY);
                break;
            }
            case 12: {
                this.itemInside = new Podobo(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 13: {
                this.itemInside = new PoisonMushroom(mapPlaceX, mapPlaceY);
                break;
            }
            case 14: {
                this.itemInside = new PowBlock(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 15: {
                this.itemInside = new PWing(mapPlaceX, mapPlaceY);
                break;
            }
            case 16: {
                this.itemInside = new SlowdownClock(mapPlaceX, mapPlaceY);
                break;
            }
            case 17: {
                this.itemInside = new SpeedupClock(mapPlaceX, mapPlaceY);
                break;
            }
            case 18: {
                this.itemInside = new Starman(mapPlaceX, mapPlaceY);
                break;
            }
            case 19: {
                this.itemInside = new TanookiSuit(mapPlaceX, mapPlaceY);
                break;
            }
            case 20: {
                this.itemInside = new ThreeUp(mapPlaceX, mapPlaceY);
                break;
            }
            case 21: {
                this.itemInside = new TwoUp(mapPlaceX, mapPlaceY);
                break;
            }
            case 22: {
                this.itemInside = new FiveUp(mapPlaceX, mapPlaceY);
            }
        }
    }

    public void cyclePowerups() {
        int powerUp = -1;
        if (LevelEditorScene.isRunning()) {
            return;
        }
        if (!NetplayClient.running) {
            powerUp = (int)(GameLogic.random.nextDouble() * 22.0);
            if (NetplayServer.running) {
                this.serverPowerup = powerUp;
            } else {
                this.setItemInside(powerUp);
                this.itemInsideImage = this.itemInside.currentImage;
            }
        }
        if (NetplayServer.running) {
            NetplayServer.sendItemUpdate(this, powerUp, false);
        }
    }

    public void generatePowerup() {
        if (NetplayClient.running) {
            return;
        }
        if (NetplayServer.running) {
            this.setItemInside(this.serverPowerup);
        }
        this.itemInside.spawn();
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity && direction == Direction.DOWN && this.bumpedUp) {
            ((Entity)i).iTileBumpTop();
        }
        if (!this.disabled && i instanceof Player && direction == Direction.UP) {
            this.reactBump(direction);
            this.generatePowerup();
            this.disabled = true;
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (this.disabled) {
            this.disableTimer.update(timePassed);
            return;
        }
        if (!LevelEditorScene.isRunning()) {
            if (this.itemInside != null) {
                this.itemInside.update(timePassed);
                this.itemInsideImage = this.itemInside.getImage();
            }
            this.itemSetDelayTimer.update(timePassed);
        }
    }

    @Override
    public Object clone() {
        ClearItemBlock c = new ClearItemBlock();
        return c;
    }

    @Override
    public BufferedImage getImage() {
        if (this.disabled) {
            return DISABLED_BLOCK;
        }
        BufferedImage image = new BufferedImage(32, 32, 2);
        Graphics2D g2D = image.createGraphics();
        g2D.drawImage((Image)this.itemInsideImage, 0, 0, null);
        g2D.drawImage((Image)super.getImage(), 0, 0, null);
        return image;
    }
}

