/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.Utility;
import com.dmgame.map.GraphicTile;
import com.dmgame.map.ImageTile;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.Platform;
import com.dmgame.map.TileType;
import java.awt.geom.Line2D;

public class DonutBlock
extends InteractiveTile {
    private static final long serialVersionUID = 4744670397939988368L;
    private int fallTime = 30;
    private boolean continueCountdown = false;
    private boolean falling = false;
    private static final int MAX_FALL_TIME = 30;
    public static final int RESPAWN_TIME = -640;
    public static final double FALL_SPEED = 0.005;
    private DonutPlatform fallingPlatform;
    private float origX;
    private float origY;

    public DonutBlock() {
        super(Utility.getSubanimation(InteractiveTile.tileset, 64, 0, 32, 32), 64, 0);
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (direction == Direction.DOWN) {
            this.continueCountdown = true;
            if (this.fallTime <= 0 && !this.falling) {
                this.fall();
            }
        }
    }

    @Override
    public void setMapRelCoords(int mapRelX, int mapRelY) {
        super.setMapRelCoords(mapRelX, mapRelY);
        this.origX = this.mapX;
        this.origY = this.mapY;
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (this.continueCountdown) {
            --this.fallTime;
            this.mapY += this.fallTime % 4 == 0 ? 3.0f : -1.0f;
        } else {
            this.fallTime = 30;
            this.mapX = this.origX;
            this.mapY = this.origY;
        }
        this.continueCountdown = false;
    }

    @Override
    public Object clone() {
        return new DonutBlock();
    }

    private void fall() {
        this.removeSelfFromMap();
        this.falling = true;
        this.fallingPlatform = new DonutPlatform();
        this.fallingPlatform.speed = 0.005;
        this.fallingPlatform.setPath(new Line2D.Double(this.mapX + 16.0f, this.mapY + 32.0f, this.mapX + 16.0f, (float)GameLogic.currentMap.MAP_HEIGHT + this.mapY + 32.0f));
        this.fallingPlatform.setLocation((int)this.mapX, (int)this.mapY);
        this.fallingPlatform.gTiles[0][0] = new ImageTile(this.getImage(), null, 0, 0);
        this.fallingPlatform.pTiles[0][0] = new PhysicalTile(TileType.SOLID, PhysicalTile.DEFAULT);
        this.fallingPlatform.setPathIterator();
        this.platOffsetX = this.mapX - 32.0f;
        this.platOffsetY = this.mapY - 32.0f;
        this.mapX = 0.0f;
        this.mapY = 0.0f;
        GameLogic.currentMap.platforms.add(this.fallingPlatform);
        GameLogic.updatables.add(this.fallingPlatform);
    }

    public static class DonutPlatform
    extends Platform {
        private static final long serialVersionUID = 3078817636949999032L;

        public DonutPlatform() {
            this.vspeed = 0.0;
            this.hspeed = 0.0;
            this.width = 32;
            this.height = 32;
            this.pTiles = new PhysicalTile[1][1];
            this.gTiles = new GraphicTile[1][1];
            this.iTiles = new InteractiveTile[1][1];
        }

        @Override
        public void update(long timePassed) {
            super.update(timePassed);
            if (this.helper.getSpeed() < 0.0175) {
                this.helper.setSpeed(this.helper.getSpeed() + 0.001);
            }
            if (this.y > GameLogic.currentMap.MAP_HEIGHT) {
                GameLogic.currentMap.platforms.remove(this);
                GameLogic.updatables.remove(this);
            }
        }
    }
}

