/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Animation;
import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.Utility;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.PhysicalTile;
import com.dmgame.map.TileType;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class FlipBlock
extends InteractiveTile {
    private static final long serialVersionUID = 6089722759924894278L;
    private transient boolean flipped = false;
    private transient Animation flippedAnim;
    private transient long timeSinceFlipped = 0L;
    private final transient long MAX_FLIP_TIME = 6000L;

    public FlipBlock() {
        super(Utility.getSubanimation(InteractiveTile.tileset, 96, 0, 32, 32), 96, 0);
    }

    private void createFlippedAnim() {
        try {
            BufferedImage flippedAnimSprites = ImageIO.read(new File("res/gfx/packs/Default/blocks/flipblock.png"));
            BufferedImage[] sprites = new BufferedImage[]{flippedAnimSprites.getSubimage(0, 0, 32, 32), flippedAnimSprites.getSubimage(32, 0, 32, 32), flippedAnimSprites.getSubimage(64, 0, 32, 32), flippedAnimSprites.getSubimage(96, 0, 32, 32)};
            this.flippedAnim = new Animation(250L, sprites);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (!this.flipped && direction == Direction.UP) {
            this.createFlippedAnim();
            this.flipped = true;
            GameLogic.usePTiles[this.mapRelX][this.mapRelY] = this.hiddenPTile;
            SoundPlayer.playSound(Sound.BUMP);
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (this.flipped) {
            this.flippedAnim.update(timePassed);
            this.timeSinceFlipped += timePassed;
            if (this.timeSinceFlipped > 6000L) {
                this.flipped = false;
                this.timeSinceFlipped = 0L;
                GameLogic.usePTiles[this.mapRelX][this.mapRelY] = new PhysicalTile(TileType.INTERACTIVE, PhysicalTile.DEFAULT);
                GameLogic.usePTiles[this.mapRelX][this.mapRelY].translate(this.mapRelX * 32, this.mapRelY * 32);
            }
        }
    }

    @Override
    public Object clone() {
        return new FlipBlock();
    }

    @Override
    public BufferedImage getImage() {
        return this.flipped ? this.flippedAnim.getImage() : super.getImage();
    }
}

