/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Direction;
import com.dmgame.Interactive;
import com.dmgame.Utility;
import com.dmgame.entity.GrayThrowBlockEntity;
import com.dmgame.entity.Player;
import com.dmgame.map.InteractiveTile;
import com.dmgame.net.client.NetplayClient;

public class GrayThrowBlock
extends InteractiveTile {
    private static final long serialVersionUID = 4926088157966114618L;

    public GrayThrowBlock() {
        super(Utility.getSubanimation(InteractiveTile.tileset, 128, 32, 32, 32), 128, 32);
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Player && ((Player)i).canHoldItem()) {
            Player player = (Player)i;
            switch (direction) {
                case DOWN: {
                    if (!player.isControlDown()) break;
                    if (!NetplayClient.running) {
                        player.giveHoldItem(new GrayThrowBlockEntity(this.mapX, this.mapY, player));
                    }
                    this.removeSelfFromMap();
                    break;
                }
                case LEFT: {
                    if (player.isFacingRight() || !player.isControlDown()) break;
                    if (!NetplayClient.running) {
                        player.giveHoldItem(new GrayThrowBlockEntity(this.mapX, this.mapY, player));
                    }
                    this.removeSelfFromMap();
                    break;
                }
                case RIGHT: {
                    if (!player.isFacingRight() || !player.isControlDown()) break;
                    if (!NetplayClient.running) {
                        player.giveHoldItem(new GrayThrowBlockEntity(this.mapX, this.mapY, player));
                    }
                    this.removeSelfFromMap();
                    break;
                }
            }
        }
    }

    @Override
    public Object clone() {
        GrayThrowBlock g = new GrayThrowBlock();
        return g;
    }
}

