/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Direction;
import com.dmgame.GameLogic;
import com.dmgame.Interactive;
import com.dmgame.UnthreadedTimer;
import com.dmgame.Utility;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.Shell;
import com.dmgame.entity.Team;
import com.dmgame.entity.powerups.BobOmb;
import com.dmgame.entity.powerups.Bomb;
import com.dmgame.entity.powerups.Boomerang;
import com.dmgame.entity.powerups.BulletBill;
import com.dmgame.entity.powerups.Feather;
import com.dmgame.entity.powerups.FireFlower;
import com.dmgame.entity.powerups.FiveUp;
import com.dmgame.entity.powerups.Hammer;
import com.dmgame.entity.powerups.IceWand;
import com.dmgame.entity.powerups.Leaf;
import com.dmgame.entity.powerups.ModBlock;
import com.dmgame.entity.powerups.MysteryMushroom;
import com.dmgame.entity.powerups.OneUp;
import com.dmgame.entity.powerups.PWing;
import com.dmgame.entity.powerups.Podobo;
import com.dmgame.entity.powerups.PoisonMushroom;
import com.dmgame.entity.powerups.PowBlock;
import com.dmgame.entity.powerups.PowerUp;
import com.dmgame.entity.powerups.SlowdownClock;
import com.dmgame.entity.powerups.SpeedupClock;
import com.dmgame.entity.powerups.Starman;
import com.dmgame.entity.powerups.TanookiSuit;
import com.dmgame.entity.powerups.ThreeUp;
import com.dmgame.entity.powerups.TwoUp;
import com.dmgame.map.InteractiveTile;
import com.dmgame.net.client.NetplayClient;
import com.dmgame.net.server.NetplayServer;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.awt.image.BufferedImage;

public class QuestionBlock
extends InteractiveTile {
    private static final long serialVersionUID = -7401924814577937264L;
    public transient PowerUp itemInside;
    public transient boolean disabled = false;
    private final transient long MAX_DISABLE_TIME = 2000L;
    private transient UnthreadedTimer disableTimer;

    public QuestionBlock() {
        super(Utility.getSubanimation(InteractiveTile.tileset, 32, 0, 32, 32), 32, 0);
    }

    @Override
    protected void setupTimers() {
        super.setupTimers();
        this.disableTimer = new UnthreadedTimer(2000L){

            @Override
            public void end() {
                QuestionBlock.this.disabled = false;
                this.reset();
            }
        };
    }

    public void generateNetPowerup(int powerUp) {
        this.setItemInside(powerUp);
        this.itemInside.spawn();
    }

    private void setItemInside(int powerUp) {
        float mapPlaceX = (float)(this.mapRelX * 32) + this.platOffsetX;
        float mapPlaceY = (float)(this.mapRelY * 32) + this.platOffsetY;
        switch (powerUp) {
            case 0: {
                this.itemInside = new BobOmb(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 1: {
                this.itemInside = new Bomb(mapPlaceX, mapPlaceY);
                break;
            }
            case 2: {
                this.itemInside = new Boomerang(mapPlaceX, mapPlaceY);
                break;
            }
            case 3: {
                this.itemInside = new BulletBill(mapPlaceX, mapPlaceY, null);
                break;
            }
            case 4: {
                this.itemInside = new Feather(mapPlaceX, mapPlaceY);
                break;
            }
            case 5: {
                this.itemInside = new FireFlower(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 6: {
                this.itemInside = new Hammer(mapPlaceX, mapPlaceY);
                break;
            }
            case 7: {
                this.itemInside = new IceWand(mapPlaceX, mapPlaceY);
                break;
            }
            case 8: {
                this.itemInside = new Leaf(mapPlaceX, mapPlaceY);
                break;
            }
            case 9: {
                this.itemInside = new ModBlock(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 10: {
                this.itemInside = new MysteryMushroom(mapPlaceX, mapPlaceY);
                break;
            }
            case 11: {
                this.itemInside = new OneUp(mapPlaceX, mapPlaceY);
                break;
            }
            case 12: {
                this.itemInside = new Podobo(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 13: {
                this.itemInside = new PoisonMushroom(mapPlaceX, mapPlaceY);
                break;
            }
            case 14: {
                this.itemInside = new PowBlock(mapPlaceX, mapPlaceY, Team.UNALLIED);
                break;
            }
            case 15: {
                this.itemInside = new PWing(mapPlaceX, mapPlaceY);
                break;
            }
            case 16: {
                this.itemInside = new SlowdownClock(mapPlaceX, mapPlaceY);
                break;
            }
            case 17: {
                this.itemInside = new SpeedupClock(mapPlaceX, mapPlaceY);
                break;
            }
            case 18: {
                this.itemInside = new Starman(mapPlaceX, mapPlaceY);
                break;
            }
            case 19: {
                this.itemInside = new TanookiSuit(mapPlaceX, mapPlaceY);
                break;
            }
            case 20: {
                this.itemInside = new ThreeUp(mapPlaceX, mapPlaceY);
                break;
            }
            case 21: {
                this.itemInside = new TwoUp(mapPlaceX, mapPlaceY);
                break;
            }
            case 22: {
                this.itemInside = new FiveUp(mapPlaceX, mapPlaceY);
            }
        }
        NetplayServer.sendItemUpdate(this, powerUp, true);
    }

    private void generatePowerup() {
        if (NetplayClient.running) {
            return;
        }
        this.setItemInside((int)(GameLogic.random.nextDouble() * 22.0));
        this.itemInside.spawn();
        SoundPlayer.playSound(Sound.SPROUT);
    }

    @Override
    public void react(Interactive i, Direction direction) {
        if (i instanceof Entity && direction == Direction.DOWN && this.bumpedUp) {
            ((Entity)i).iTileBumpTop();
        }
        if (!this.disabled) {
            if (direction == Direction.UP) {
                if (i instanceof Player) {
                    this.reactBump(direction);
                    this.generatePowerup();
                    this.disabled = true;
                }
            } else if ((direction == Direction.LEFT || direction == Direction.RIGHT) && i instanceof Shell) {
                this.reactBump(direction);
                this.generatePowerup();
                this.disabled = true;
            }
        }
    }

    @Override
    public void update(long timePassed) {
        super.update(timePassed);
        if (this.disabled) {
            this.disableTimer.update(timePassed);
        }
    }

    @Override
    public Object clone() {
        QuestionBlock q = new QuestionBlock();
        return q;
    }

    @Override
    public BufferedImage getImage() {
        return this.disabled ? DISABLED_BLOCK : super.getImage();
    }
}

