/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Animation;
import com.dmgame.Utility;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.Platform;
import com.dmgame.map.interactivetiles.AbstractOnOffSwitch;
import com.dmgame.map.interactivetiles.RedOnOffBlock;

public class RedOnOffSwitch
extends AbstractOnOffSwitch {
    private static final long serialVersionUID = -3460073115136535041L;

    public RedOnOffSwitch(Animation tile, int x, int y) {
        super(tile, x, y);
    }

    @Override
    protected void setOnOffAnim() {
        if (this.on) {
            this.onAnim = this.tile;
            this.onAnimX = this.x;
            this.onAnimY = this.y;
            this.offAnim = Utility.getSubanimation(InteractiveTile.tileset, 224, 32, 32, 32);
            this.offAnimX = 224;
            this.offAnimY = 32;
        } else {
            this.onAnim = Utility.getSubanimation(InteractiveTile.tileset, 224, 0, 32, 32);
            this.onAnimX = 224;
            this.onAnimY = 0;
            this.offAnim = this.tile;
            this.offAnimX = this.x;
            this.offAnimY = this.y;
        }
    }

    @Override
    public void setColorOnOff(Map map) {
        InteractiveTile[][] iTiles = map.iTiles;
        for (int x = 0; x < iTiles.length; ++x) {
            for (int y = 0; y < iTiles[x].length; ++y) {
                if (iTiles[x][y] == null) continue;
                if (iTiles[x][y] instanceof RedOnOffBlock) {
                    ((RedOnOffBlock)iTiles[x][y]).setOn(this.on);
                    continue;
                }
                if (!(iTiles[x][y] instanceof RedOnOffSwitch)) continue;
                ((RedOnOffSwitch)iTiles[x][y]).setOn(this.on);
            }
        }
    }

    @Override
    public void setColorOnOff(Platform platform) {
        InteractiveTile[][] iTiles = platform.iTiles;
        for (int x = 0; x < iTiles.length; ++x) {
            for (int y = 0; y < iTiles[x].length; ++y) {
                if (iTiles[x][y] == null) continue;
                if (iTiles[x][y] instanceof RedOnOffBlock) {
                    ((RedOnOffBlock)iTiles[x][y]).setOn(this.on);
                    continue;
                }
                if (!(iTiles[x][y] instanceof RedOnOffSwitch)) continue;
                ((RedOnOffSwitch)iTiles[x][y]).setOn(this.on);
            }
        }
    }

    @Override
    public Object clone() {
        RedOnOffSwitch toReturn = new RedOnOffSwitch((Animation)this.tile.clone(), this.x, this.y);
        toReturn.y = this.on ? 0 : 32;
        toReturn.setMapRelCoords(this.mapRelX, this.mapRelY);
        return toReturn;
    }
}

