/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.map.interactivetiles;

import com.dmgame.Animation;
import com.dmgame.Utility;
import com.dmgame.map.InteractiveTile;
import com.dmgame.map.Map;
import com.dmgame.map.Platform;
import com.dmgame.map.interactivetiles.AbstractOnOffBlock;
import com.dmgame.map.interactivetiles.YellowOnOffSwitch;

public class YellowOnOffBlock
extends AbstractOnOffBlock {
    private static final long serialVersionUID = -7848102579788208052L;

    public YellowOnOffBlock(Animation tile, int x, int y) {
        super(tile, x, y);
    }

    @Override
    protected void setOnOffAnim() {
        if (this.on) {
            this.onAnim = this.tile;
            this.onAnimX = this.x;
            this.onAnimY = this.y;
            this.offAnim = Utility.getSubanimation(InteractiveTile.tileset, 416, 32, 32, 32);
            this.offAnimX = 416;
            this.offAnimY = 32;
        } else {
            this.onAnim = Utility.getSubanimation(InteractiveTile.tileset, 416, 0, 32, 32);
            this.onAnimX = 416;
            this.onAnimX = 0;
            this.offAnim = this.tile;
            this.offAnimX = this.x;
            this.offAnimY = this.y;
        }
    }

    @Override
    public void setColorOnOff(Map map) {
        InteractiveTile[][] iTiles = map.iTiles;
        for (int x = 0; x < iTiles.length; ++x) {
            for (int y = 0; y < iTiles[x].length; ++y) {
                if (iTiles[x][y] == null) continue;
                if (iTiles[x][y] instanceof YellowOnOffBlock) {
                    ((YellowOnOffBlock)iTiles[x][y]).setOn(this.on);
                    continue;
                }
                if (!(iTiles[x][y] instanceof YellowOnOffSwitch)) continue;
                ((YellowOnOffSwitch)iTiles[x][y]).setOn(this.on);
            }
        }
    }

    @Override
    public void setColorOnOff(Platform platform) {
        InteractiveTile[][] iTiles = platform.iTiles;
        for (int x = 0; x < iTiles.length; ++x) {
            for (int y = 0; y < iTiles[x].length; ++y) {
                if (iTiles[x][y] == null) continue;
                if (iTiles[x][y] instanceof YellowOnOffBlock) {
                    ((YellowOnOffBlock)iTiles[x][y]).setOn(this.on);
                    continue;
                }
                if (!(iTiles[x][y] instanceof YellowOnOffSwitch)) continue;
                ((YellowOnOffSwitch)iTiles[x][y]).setOn(this.on);
            }
        }
    }

    @Override
    public Object clone() {
        YellowOnOffBlock toReturn = new YellowOnOffBlock((Animation)this.tile.clone(), this.x, this.y);
        toReturn.setMapRelCoords(this.mapRelX, this.mapRelY);
        return toReturn;
    }
}

