/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.menu;

import com.dmgame.Utility;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWLabel;
import com.dmgame.gui.SMWPanel;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.NewMenuPanel;
import com.dmgame.options.OptionsHandlerBean;
import com.dmgame.options.PlayerControlsBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import javax.swing.JPanel;

public class KeybindMenuPanel
extends SMWPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 4661695686115776323L;
    private MenuScene parentScene;
    private OptionsHandlerBean options;
    private String controlString;
    private SMWButton selectedButton;
    private boolean listen;

    public KeybindMenuPanel(MenuScene scene, TexturePaint bgPaint) {
        this.parentScene = scene;
        this.drawPaint = bgPaint;
        this.listen = false;
        try {
            this.options = Utility.loadConfig();
        }
        catch (FileNotFoundException ex) {
            this.options = Utility.getDefaultConfig();
        }
        this.setPreferredSize(new Dimension(1024, 768));
        this.init();
        this.parentScene.getScreenManager().windowFrame.addKeyListener(this);
        this.parentScene.getScreenManager().fullScreenFrame.addKeyListener(this);
    }

    private void init() {
        JPanel centerPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = -484509545556353527L;

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 5;
        SMWButton returnButton = new SMWButton(Utility.lang.getProperty("back"), 768, 32);
        returnButton.setActionCommand("back");
        returnButton.addActionListener(this);
        centerPanel.add((Component)returnButton, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 2;
        SMWButton saveButton = new SMWButton(Utility.lang.getProperty("save"));
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        centerPanel.add((Component)saveButton, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 2;
        c.gridwidth = 3;
        c.fill = 2;
        SMWButton defaultButton = new SMWButton(Utility.lang.getProperty("get default"));
        defaultButton.setActionCommand("defaults");
        defaultButton.addActionListener(this);
        centerPanel.add((Component)defaultButton, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        SMWLabel playerLabel = new SMWLabel("p1");
        centerPanel.add((Component)playerLabel, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 2;
        c.weightx = 1.0;
        playerLabel = new SMWLabel("p2");
        centerPanel.add((Component)playerLabel, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 3;
        c.weightx = 1.0;
        playerLabel = new SMWLabel("p3");
        centerPanel.add((Component)playerLabel, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 4;
        c.weightx = 1.0;
        playerLabel = new SMWLabel("p4");
        centerPanel.add((Component)playerLabel, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.gridx = 0;
        c.weightx = 1.0;
        SMWLabel controlLabel = new SMWLabel(Utility.lang.getProperty("up"));
        centerPanel.add((Component)controlLabel, c);
        c = new GridBagConstraints();
        c.gridy = 4;
        c.gridx = 0;
        c.weightx = 1.0;
        controlLabel = new SMWLabel(Utility.lang.getProperty("down"));
        centerPanel.add((Component)controlLabel, c);
        c = new GridBagConstraints();
        c.gridy = 5;
        c.gridx = 0;
        c.weightx = 1.0;
        controlLabel = new SMWLabel(Utility.lang.getProperty("left"));
        centerPanel.add((Component)controlLabel, c);
        c = new GridBagConstraints();
        c.gridy = 6;
        c.gridx = 0;
        c.weightx = 1.0;
        controlLabel = new SMWLabel(Utility.lang.getProperty("right"));
        centerPanel.add((Component)controlLabel, c);
        c = new GridBagConstraints();
        c.gridy = 7;
        c.gridx = 0;
        c.weightx = 1.0;
        controlLabel = new SMWLabel(Utility.lang.getProperty("turbo"));
        centerPanel.add((Component)controlLabel, c);
        c = new GridBagConstraints();
        c.gridy = 8;
        c.gridx = 0;
        c.weightx = 1.0;
        controlLabel = new SMWLabel(Utility.lang.getProperty("reserve"));
        centerPanel.add((Component)controlLabel, c);
        PlayerControlsBean[] controls = new PlayerControlsBean[]{this.options.getPlayerOneControls(), this.options.getPlayerTwoControls(), this.options.getPlayerThreeControls(), this.options.getPlayerFourControls()};
        for (int i = 1; i <= 4; ++i) {
            c = new GridBagConstraints();
            c.gridx = i;
            c.gridy = 3;
            c.fill = 2;
            c.weightx = 1.0;
            SMWButton controlButton = new SMWButton(KeyEvent.getKeyText(controls[i - 1].getUp()));
            controlButton.setActionCommand("player " + i + " up");
            controlButton.addActionListener(this);
            centerPanel.add((Component)controlButton, c);
            c = new GridBagConstraints();
            c.gridx = i;
            c.gridy = 4;
            c.fill = 2;
            c.weightx = 1.0;
            controlButton = new SMWButton(KeyEvent.getKeyText(controls[i - 1].getDown()));
            controlButton.setActionCommand("player " + i + " down");
            controlButton.addActionListener(this);
            centerPanel.add((Component)controlButton, c);
            c = new GridBagConstraints();
            c.gridx = i;
            c.gridy = 5;
            c.fill = 2;
            c.weightx = 1.0;
            controlButton = new SMWButton(KeyEvent.getKeyText(controls[i - 1].getLeft()));
            controlButton.setActionCommand("player " + i + " left");
            controlButton.addActionListener(this);
            centerPanel.add((Component)controlButton, c);
            c = new GridBagConstraints();
            c.gridx = i;
            c.gridy = 6;
            c.fill = 2;
            c.weightx = 1.0;
            controlButton = new SMWButton(KeyEvent.getKeyText(controls[i - 1].getRight()));
            controlButton.setActionCommand("player " + i + " right");
            controlButton.addActionListener(this);
            centerPanel.add((Component)controlButton, c);
            c = new GridBagConstraints();
            c.gridx = i;
            c.gridy = 7;
            c.fill = 2;
            c.weightx = 1.0;
            controlButton = new SMWButton(KeyEvent.getKeyText(controls[i - 1].getTurbo()));
            controlButton.setActionCommand("player " + i + " turbo");
            controlButton.addActionListener(this);
            centerPanel.add((Component)controlButton, c);
            c = new GridBagConstraints();
            c.gridx = i;
            c.gridy = 8;
            c.fill = 2;
            c.weightx = 1.0;
            controlButton = new SMWButton(KeyEvent.getKeyText(controls[i - 1].getReserve()));
            controlButton.setActionCommand("player " + i + " reserve");
            controlButton.addActionListener(this);
            centerPanel.add((Component)controlButton, c);
        }
        this.addComponentAndCenter(centerPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().contains("player")) {
            this.listen = true;
            if (this.selectedButton != null) {
                this.selectedButton.setSelected(false);
            }
            this.selectedButton = (SMWButton)e.getSource();
            this.selectedButton.setSelected(true);
            this.controlString = e.getActionCommand();
        } else if (e.getActionCommand().equals("back")) {
            NewMenuPanel panel = new NewMenuPanel(this.parentScene, this.drawPaint);
            this.parentScene.getScreenManager().windowFrame.removeKeyListener(this);
            this.parentScene.getScreenManager().fullScreenFrame.removeKeyListener(this);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        } else if (e.getActionCommand().equals("save")) {
            Utility.saveConfig(this.options);
        } else if (e.getActionCommand().equals("defaults")) {
            this.setDefaults();
        } else {
            System.err.println(e.getActionCommand() + " is not implemented yet.");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.listen) {
            PlayerControlsBean bean;
            this.listen = false;
            this.selectedButton.setSelected(false);
            this.selectedButton.setText(KeyEvent.getKeyText(e.getKeyCode()));
            String[] command = this.controlString.split(" ");
            int player = Integer.parseInt(command[1]);
            switch (player) {
                case 1: {
                    bean = this.options.getPlayerOneControls();
                    break;
                }
                case 2: {
                    bean = this.options.getPlayerTwoControls();
                    break;
                }
                case 3: {
                    bean = this.options.getPlayerThreeControls();
                    break;
                }
                case 4: {
                    bean = this.options.getPlayerFourControls();
                    break;
                }
                default: {
                    bean = this.options.getPlayerOneControls();
                }
            }
            if (command[2].equals("up")) {
                bean.setUp(e.getKeyCode());
            } else if (command[2].equals("down")) {
                bean.setDown(e.getKeyCode());
            } else if (command[2].equals("left")) {
                bean.setLeft(e.getKeyCode());
            } else if (command[2].equals("right")) {
                bean.setRight(e.getKeyCode());
            } else if (command[2].equals("turbo")) {
                bean.setTurbo(e.getKeyCode());
            } else {
                bean.setReserve(e.getKeyCode());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void setDefaults() {
        this.removeAll();
        this.options = Utility.getDefaultConfig();
        this.init();
        this.revalidate();
    }
}

