/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.menu;

import com.dmgame.MapScene;
import com.dmgame.Utility;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWLabel;
import com.dmgame.gui.SMWPanel;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.PlayerSelectPanel;
import com.dmgame.modes.ClassicMode;
import com.dmgame.modes.GameMode;
import com.dmgame.sound.SoundPlayer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class MapChooserPanel
extends SMWPanel
implements ActionListener {
    private static final long serialVersionUID = -3001170692089291400L;
    final int BUTTON_PADDING = 8;
    public static final int MAP_SCALE = 4;
    MenuScene parentScene;
    private SMWButton startGame;
    private SMWButton modeLeft;
    private SMWButton modeRight;
    private SMWButton mapLeft;
    private SMWButton mapRight;
    private SMWButton livesLeft;
    private SMWButton livesRight;
    private SMWButton back;
    private SMWLabel livesLabel;
    private SMWLabel modeLabel;
    private SMWLabel mapLabel;
    private SMWLabel mapDisplayLabel;
    File[] mapNames;
    int mapNum;
    int points;
    PlayerOptions[] options;

    public MapChooserPanel(MenuScene scene, TexturePaint bg, PlayerOptions[] options) {
        this.setPreferredSize(new Dimension(1024, 768));
        this.options = options;
        this.mapNames = new File("res/maps/").listFiles();
        this.mapNum = 0;
        this.points = 5;
        JPanel centerPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = -438463248969908738L;

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        this.parentScene = scene;
        this.drawPaint = bg;
        this.startGame = new SMWButton(Utility.lang.getProperty("start game"), 512, 32);
        this.startGame.setActionCommand("start");
        this.startGame.addActionListener(this);
        BufferedImage arrowLeft = null;
        BufferedImage arrowRight = null;
        BufferedImage labelBG = null;
        BufferedImage dialogBG = null;
        try {
            labelBG = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/pipe_button_9patch.png"));
            dialogBG = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/menu_dialog_9patch.png"));
            BufferedImage arrows = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/menu_arrows.png"));
            arrowLeft = arrows.getSubimage(0, 0, arrows.getWidth() / 4, arrows.getHeight() / 2);
            arrowRight = arrows.getSubimage(0, arrows.getHeight() / 2, arrows.getWidth() / 4, arrows.getHeight() / 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.modeLeft = new SMWButton(arrowLeft);
        this.modeLeft.setActionCommand("modeLeft");
        this.modeLeft.addActionListener(this);
        this.modeRight = new SMWButton(arrowRight);
        this.modeRight.setActionCommand("modeRight");
        this.modeRight.addActionListener(this);
        this.mapLeft = new SMWButton(arrowLeft);
        this.mapLeft.setActionCommand("mapLeft");
        this.mapLeft.addActionListener(this);
        this.mapRight = new SMWButton(arrowRight);
        this.mapRight.setActionCommand("mapRight");
        this.mapRight.addActionListener(this);
        this.modeLabel = new SMWLabel("Classic");
        this.modeLabel.setDynamicBackground(labelBG);
        this.mapLabel = new SMWLabel(this.mapNames[this.mapNum].getName().replace(".map", ""));
        this.mapLabel.setDynamicBackground(labelBG);
        this.mapDisplayLabel = new SMWLabel(272, 208);
        this.mapDisplayLabel.setDynamicBackground(dialogBG);
        try {
            String fileName = "res/maps/cache/" + this.mapNames[this.mapNum].getName().substring(0, this.mapNames[this.mapNum].getName().length() - 4) + ".png";
            this.mapDisplayLabel.setIcon(ImageIO.read(new File(fileName)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.back = new SMWButton(Utility.lang.getProperty("back"));
        this.back.setActionCommand("back");
        this.back.addActionListener(this);
        this.livesLeft = new SMWButton(arrowLeft);
        this.livesLeft.setActionCommand("livesLeft");
        this.livesLeft.addActionListener(this);
        this.livesRight = new SMWButton(arrowRight);
        this.livesRight.setActionCommand("livesRight");
        this.livesRight.addActionListener(this);
        this.livesLabel = new SMWLabel("Lives: " + this.points);
        this.livesLabel.setDynamicBackground(labelBG);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 3;
        centerPanel.add((Component)this.startGame, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 0;
        centerPanel.add((Component)this.modeLeft, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        centerPanel.add((Component)this.modeLabel, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridx = 2;
        centerPanel.add((Component)this.modeRight, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 0;
        centerPanel.add((Component)this.livesLeft, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 1;
        c.fill = 2;
        centerPanel.add((Component)this.livesLabel, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridx = 2;
        centerPanel.add((Component)this.livesRight, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.gridx = 0;
        centerPanel.add((Component)this.mapLeft, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        centerPanel.add((Component)this.mapLabel, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.gridx = 2;
        centerPanel.add((Component)this.mapRight, c);
        c = new GridBagConstraints();
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 2;
        c.anchor = 21;
        centerPanel.add((Component)this.mapDisplayLabel, c);
        c = new GridBagConstraints();
        c.gridy = 10;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 2;
        centerPanel.add((Component)this.back, c);
        this.addComponentAndCenter(centerPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        boolean mapChanged = false;
        if (s.contains("start")) {
            SoundPlayer.stopMusic();
            this.parentScene.getScreenManager().switchScene(new MapScene(this.mapNames[this.mapNum].getName().replace(".map", ""), false, false, "Default", (GameMode)new ClassicMode(this.points), this.options, this.drawPaint));
        } else if (s.equals("livesLeft")) {
            if (this.points != 0) {
                --this.points;
            }
            this.livesLabel.setText("Lives: " + this.points);
        } else if (s.equals("livesRight")) {
            if (this.points != 99) {
                ++this.points;
            }
            this.livesLabel.setText("Lives: " + this.points);
        } else if (s.equals("mapLeft")) {
            --this.mapNum;
            if (this.mapNum < 0) {
                this.mapNum = this.mapNames.length - 1;
            }
            if (this.mapNames[this.mapNum].getName().equals("cache")) {
                --this.mapNum;
            }
            if (this.mapNum < 0) {
                this.mapNum = this.mapNames.length - 1;
            }
            mapChanged = true;
        } else if (s.equals("mapRight")) {
            ++this.mapNum;
            if (this.mapNum == this.mapNames.length) {
                this.mapNum = 0;
            }
            if (this.mapNames[this.mapNum].getName().equals("cache")) {
                ++this.mapNum;
            }
            if (this.mapNum == this.mapNames.length) {
                this.mapNum = 0;
            }
            mapChanged = true;
        } else if (s.equals("back")) {
            PlayerSelectPanel panel = new PlayerSelectPanel(this.parentScene, this.drawPaint, this.options);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        } else {
            System.err.println(s + " needs to be implemented!!!");
        }
        if (mapChanged) {
            this.mapLabel.setText(this.mapNames[this.mapNum].getName().replace(".map", ""));
            try {
                String fileName = "res/maps/cache/" + this.mapNames[this.mapNum].getName().substring(0, this.mapNames[this.mapNum].getName().length() - 4) + ".png";
                this.mapDisplayLabel.setIcon(ImageIO.read(new File(fileName)));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

