/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.menu;

import com.dmgame.Utility;
import com.dmgame.entity.Team;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWInternalFrame;
import com.dmgame.gui.SMWLabel;
import com.dmgame.gui.SMWPanel;
import com.dmgame.gui.SMWPlayerSelector;
import com.dmgame.gui.SMWTextField;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.NetplayGamePanel;
import com.dmgame.menu.NewMenuPanel;
import com.dmgame.net.client.MainClientHandler;
import com.dmgame.net.client.NetworkClientMenuHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.swing.JPanel;

public class NetplayConnectionPanel
extends SMWPanel
implements ActionListener {
    private static final long serialVersionUID = 7234323710887871477L;
    public static NetplayConnectionPanel self;
    private MenuScene parentScene;
    private static boolean started;
    SMWButton connectButton;
    SMWButton returnButton;
    SMWTextField addressField;
    SMWTextField portField;
    SMWPlayerSelector selector;
    final int BUTTON_PADDING = 8;

    public NetplayConnectionPanel(MenuScene scene, TexturePaint bg) {
        self = this;
        this.setPreferredSize(new Dimension(1024, 768));
        JPanel centerPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 3997242658440188101L;

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        this.parentScene = scene;
        this.drawPaint = bg;
        SMWLabel addressLabel = new SMWLabel(Utility.lang.getProperty("ip"));
        this.addressField = new SMWTextField("localhost", 200, addressLabel.getHeight());
        SMWLabel portLabel = new SMWLabel(Utility.lang.getProperty("port"));
        this.portField = new SMWTextField("10000", 200, addressLabel.getHeight());
        this.connectButton = new SMWButton(Utility.lang.getProperty("connect"));
        this.connectButton.setActionCommand("connect");
        this.connectButton.addActionListener(this);
        this.connectButton.redetermineSize(512, 32);
        this.returnButton = new SMWButton(Utility.lang.getProperty("back"));
        this.returnButton.setActionCommand("return");
        this.returnButton.addActionListener(this);
        this.returnButton.redetermineSize(512, 32);
        this.selector = new SMWPlayerSelector();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.ipady = 8;
        centerPanel.add((Component)addressLabel, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 1;
        c.ipady = 8;
        centerPanel.add((Component)this.addressField, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 2;
        c.ipady = 8;
        centerPanel.add((Component)portLabel, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 3;
        c.ipady = 8;
        centerPanel.add((Component)this.portField, c);
        c = new GridBagConstraints();
        c.gridwidth = 4;
        c.gridy = 1;
        c.ipady = 8;
        centerPanel.add((Component)this.connectButton, c);
        c = new GridBagConstraints();
        c.gridwidth = 4;
        c.gridy = 2;
        c.ipady = 8;
        centerPanel.add((Component)this.selector, c);
        c = new GridBagConstraints();
        c.gridwidth = 4;
        c.gridy = 3;
        c.ipady = 8;
        centerPanel.add((Component)this.returnButton, c);
        this.addComponentAndCenter(centerPanel);
        this.addressField.requestFocusInWindow();
    }

    @Override
    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setPaint(this.drawPaint);
        ((Graphics2D)g).fillRect(0, 0, 1024, 768);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("connect")) {
            int gotConnection;
            String host = this.addressField.getText();
            String port = this.portField.getText();
            int portNum = -1;
            try {
                portNum = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                SMWInternalFrame.showErrorDialog(this, "The port must be an integer between 1 and 65535.", 640, 480);
                return;
            }
            if (portNum < 1 || portNum > 65535) {
                SMWInternalFrame.showErrorDialog(this, "Valid port numbers are 1 through 65535.", 640, 480);
                return;
            }
            PlayerOptions[] options = this.selector.getSettings();
            ArrayList<String> skins = new ArrayList<String>();
            ArrayList<Team> teams = new ArrayList<Team>();
            for (PlayerOptions o : options) {
                if (!o.TYPE.equalsIgnoreCase("human")) continue;
                skins.add(o.SKIN);
                teams.add(o.TEAM);
            }
            InetSocketAddress address = new InetSocketAddress(host, portNum);
            try {
                gotConnection = NetworkClientMenuHandler.getConnection(this, skins.size(), skins.toArray(new String[1]), teams.toArray(new Team[1]), address);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                gotConnection = -1;
            }
            if (gotConnection == -1) {
                SMWInternalFrame.showErrorDialog(this, "Could not connect to host: " + host + " on port " + port, 640, 480);
            } else if (gotConnection == -2) {
                SMWInternalFrame.showErrorDialog(this, "Server is full", 640, 480);
            } else if (gotConnection == -3) {
                SMWInternalFrame.showErrorDialog(this, "This version of the game is incompatible with the server", 640, 480);
            } else if (gotConnection == 0) {
                this.confirmConnect();
            } else {
                final SMWInternalFrame frame = new SMWInternalFrame(this, 640, 480);
                frame.setLayout(null);
                SMWLabel label = new SMWLabel("There is currently a game being played. Please wait or cancel");
                int width = label.getPreferredSize().width;
                int height = label.getPreferredSize().height;
                label.setBounds(frame.getWidth() / 2 - width / 2, 16, width, height);
                frame.add(label);
                SMWButton acceptButton = new SMWButton("cancel");
                acceptButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        NetworkClientMenuHandler.cancelWait = true;
                        frame.close();
                    }
                });
                width = acceptButton.getPreferredSize().width;
                height = acceptButton.getPreferredSize().height;
                acceptButton.setBounds(frame.getWidth() / 2 - width / 2, (int)((double)frame.getHeight() * 0.75), width * 2, height);
                frame.add(acceptButton);
                frame.validate();
            }
        } else if (s.equals("return")) {
            NewMenuPanel panel = new NewMenuPanel(this.parentScene, this.drawPaint);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        }
    }

    public void confirmConnect() {
        NetplayGamePanel panel = MainClientHandler.mode.getPanel(this.parentScene, this.drawPaint);
        this.parentScene.remove(this);
        this.parentScene.add(panel);
        this.parentScene.validate();
    }

    void handleFocus() {
        this.addressField.requestFocusInWindow();
    }

    static {
        started = false;
    }
}

