/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.menu;

import com.dmgame.Scene;
import com.dmgame.Utility;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWPanel;
import com.dmgame.menu.KeybindMenuPanel;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.NetplayConnectionPanel;
import com.dmgame.menu.PlayerSelectPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class NewMenuPanel
extends SMWPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    MenuScene parentScene;
    SMWButton startButton;
    SMWButton networkButton;
    SMWButton optionsButton;
    SMWButton exitButton;
    final int BUTTON_PADDING = 8;

    public NewMenuPanel(MenuScene scene) {
        this.init(scene);
        this.loadbg();
    }

    public NewMenuPanel(MenuScene scene, TexturePaint bg) {
        this.init(scene);
        this.drawPaint = bg;
    }

    private void init(MenuScene scene) {
        this.setPreferredSize(new Dimension(1024, 768));
        JPanel centerPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 2100132219934364320L;

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        this.parentScene = scene;
        this.startButton = new SMWButton(Utility.lang.getProperty("start game"));
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.startButton.redetermineSize(512, 32);
        this.networkButton = new SMWButton(Utility.lang.getProperty("network"));
        this.networkButton.setActionCommand("network");
        this.networkButton.addActionListener(this);
        this.networkButton.redetermineSize(512, 32);
        this.optionsButton = new SMWButton(Utility.lang.getProperty("options"));
        this.optionsButton.setActionCommand("options");
        this.optionsButton.addActionListener(this);
        this.optionsButton.redetermineSize(512, 32);
        this.exitButton = new SMWButton(Utility.lang.getProperty("quit"));
        this.exitButton.setActionCommand("exit");
        this.exitButton.addActionListener(this);
        this.exitButton.redetermineSize(512, 32);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.ipady = 8;
        centerPanel.add((Component)this.startButton, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.ipady = 8;
        centerPanel.add((Component)this.networkButton, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.ipady = 8;
        centerPanel.add((Component)this.optionsButton, c);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.ipady = 8;
        centerPanel.add((Component)this.exitButton, c);
        this.addComponentAndCenter(centerPanel);
        try {
            this.setHeaderImage(ImageIO.read(new File("res/gfx/packs/" + Scene.texturePackName + "/menu/Logo.png")));
        }
        catch (IOException ex) {
            Logger.getLogger(NewMenuPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadbg() {
        try {
            BufferedImage im = ImageIO.read(new File("res/gfx/packs/Default/eyecandy/menubg.png"));
            this.drawPaint = new TexturePaint(im, new Rectangle(0, 0, im.getWidth(), im.getHeight()));
        }
        catch (IOException ex) {
            Logger.getLogger(NewMenuPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("start")) {
            PlayerSelectPanel panel = new PlayerSelectPanel(this.parentScene, this.drawPaint);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        } else if (s.equals("network")) {
            NetplayConnectionPanel panel = new NetplayConnectionPanel(this.parentScene, this.drawPaint);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
            panel.handleFocus();
        } else if (s.equals("options")) {
            KeybindMenuPanel panel = new KeybindMenuPanel(this.parentScene, this.drawPaint);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        } else if (s.equals("exit")) {
            this.parentScene.stop();
        } else {
            System.err.println(s + " needs to be implemented!!!");
        }
    }
}

