/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.menu;

import com.dmgame.Utility;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWInternalFrame;
import com.dmgame.gui.SMWPanel;
import com.dmgame.gui.SMWPlayerSelector;
import com.dmgame.menu.MapChooserPanel;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.NewMenuPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class PlayerSelectPanel
extends SMWPanel
implements ActionListener {
    private static final long serialVersionUID = 1559418508616227453L;
    MenuScene parentScene;
    SMWButton continueButton;
    SMWButton returnButton;
    SMWPlayerSelector selector;
    final int BUTTON_PADDING = 8;

    public PlayerSelectPanel(MenuScene scene, TexturePaint bg) {
        this(scene, bg, null);
    }

    PlayerSelectPanel(MenuScene scene, TexturePaint bg, PlayerOptions[] options) {
        this.setPreferredSize(new Dimension(1024, 768));
        JPanel centerPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 7885597924035470764L;

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        this.parentScene = scene;
        this.drawPaint = bg;
        this.continueButton = new SMWButton(Utility.lang.getProperty("ready"));
        this.continueButton.setActionCommand("continue");
        this.continueButton.addActionListener(this);
        this.continueButton.redetermineSize(512, 32);
        this.returnButton = new SMWButton(Utility.lang.getProperty("back"));
        this.returnButton.setActionCommand("return");
        this.returnButton.addActionListener(this);
        this.returnButton.redetermineSize(512, 32);
        this.selector = new SMWPlayerSelector(options);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.ipady = 8;
        centerPanel.add((Component)this.continueButton, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.ipady = 8;
        centerPanel.add((Component)this.selector, c);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.ipady = 8;
        centerPanel.add((Component)this.returnButton, c);
        this.addComponentAndCenter(centerPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("continue")) {
            PlayerOptions[] op = this.selector.getSettings();
            int playerCount = 0;
            for (int i = 0; i < op.length; ++i) {
                if (op[i].TYPE.equals("None")) continue;
                ++playerCount;
            }
            if (playerCount == 0) {
                SMWInternalFrame.showErrorDialog(this, "You must choose at least one player.", 640, 480);
                return;
            }
            for (PlayerOptions option : op) {
                --option.PLAYER_NUMBER;
            }
            MapChooserPanel panel = new MapChooserPanel(this.parentScene, this.drawPaint, op);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        } else if (s.equals("return")) {
            NewMenuPanel panel = new NewMenuPanel(this.parentScene, this.drawPaint);
            this.parentScene.remove(this);
            this.parentScene.add(panel);
            this.parentScene.validate();
        }
    }
}

