/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.modes;

import com.dmgame.GameLogic;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Holdable;
import com.dmgame.entity.Player;
import com.dmgame.modes.GameMode;

public class ClassicMode
extends GameMode {
    private static final long serialVersionUID = 1752252732323287220L;
    private int startScore;
    private int players;
    private int playerCount;

    public ClassicMode(int lives) {
        this.startScore = lives;
    }

    @Override
    public void numberOfPlayers(int i) {
        this.playerCount = this.players = i;
    }

    @Override
    public void reportKill(Entity killer, Entity killed) {
        if (killed instanceof Player) {
            Player p = (Player)killed;
            if (p.getScore() <= 1) {
                --this.playerCount;
            }
            p.changeScore(-1);
            if (this.playerCount == 1) {
                GameLogic.reportVictory();
            }
        }
    }

    @Override
    public void reportHolding(Entity holder, Holdable thing) {
    }

    @Override
    public void reportGoalCollision(Player player, Entity goal) {
    }

    @Override
    public int getStartScore() {
        return this.startScore;
    }

    @Override
    public void setStartScore(int score) {
        this.startScore = score;
    }

    public String toString() {
        return "Classic mode - lives: " + this.startScore;
    }

    @Override
    public void reset() {
        this.playerCount = this.players;
    }
}

