/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.client;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ClientUtility {
    private static String[] skins;
    public static volatile boolean savingSkin;

    static void sendSkin(String name, ObjectOutputStream out) throws IOException {
        MemoryCacheImageOutputStream iout = new MemoryCacheImageOutputStream(out);
        BufferedImage im = ImageIO.read(new File("res/gfx/skins/" + name + ".png"));
        System.out.println(im);
        ImageIO.write((RenderedImage)im, "png", iout);
    }

    static boolean hasSkin(String name) {
        if (skins == null) {
            File[] f = new File("res/gfx/skins/").listFiles();
            skins = new String[f.length];
            for (int i = 0; i < f.length; ++i) {
                ClientUtility.skins[i] = f[i].getName().replace(".png", "");
            }
            Arrays.sort(skins);
        }
        return Arrays.binarySearch(skins, name) >= 0;
    }

    static void getSkin(ObjectInputStream in, String name) {
        savingSkin = true;
        try {
            ImageIO.write((RenderedImage)ImageIO.read(new MemoryCacheImageInputStream(in)), "png", new File("res/gfx/skins/" + name + ".png"));
            while (in.available() > 0) {
                in.skip(in.available());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientUtility.class.getName()).log(Level.SEVERE, null, ex);
        }
        savingSkin = false;
    }
}

