/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.client;

import com.dmgame.entity.Team;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.menu.NetplayGamePanel;
import com.dmgame.net.client.ClientUtility;
import com.dmgame.net.communication.CommunicationMode;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MainClientHandler
implements Runnable {
    public static ArrayList<PlayerOptions> playerOptions;
    private static PlayerOptions[] originalOptions;
    public static CommunicationMode mode;
    public static volatile boolean running;
    public static int serverPort;
    ObjectInputStream in;
    ObjectOutputStream out;
    Socket s;

    static void returnFromGame(Socket server) throws IOException {
        running = true;
        NetplayGamePanel.started = false;
        mode.reprepClient();
        new Thread((Runnable)new MainClientHandler(server), "Client TCP thread").start();
    }

    static void accepted(Socket s, PlayerOptions[] clientOptions) throws IOException {
        originalOptions = clientOptions;
        serverPort = s.getPort();
        ObjectInputStream in = new ObjectInputStream(s.getInputStream());
        playerOptions = new ArrayList();
        playerOptions.addAll(Arrays.asList(clientOptions));
        try {
            mode = (CommunicationMode)in.readObject();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainClientHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        running = true;
        new Thread((Runnable)new MainClientHandler(s), "Client TCP thread").start();
    }

    private MainClientHandler(Socket s) throws IOException {
        this.out = new ObjectOutputStream(s.getOutputStream());
        this.in = new ObjectInputStream(s.getInputStream());
        this.s = s;
    }

    @Override
    public void run() {
        while (running) {
            try {
                int code = this.in.readInt();
                if (code == 10) {
                    running = mode.getUpdateFromServer(this.s, this.in, this.out);
                    continue;
                }
                if (code == 20) {
                    int playerID = this.in.readInt();
                    String name = (String)this.in.readObject();
                    if (!ClientUtility.hasSkin(name)) {
                        this.out.writeBoolean(false);
                        this.out.flush();
                        ClientUtility.getSkin(this.in, name);
                        this.out.writeBoolean(true);
                        this.out.flush();
                    } else {
                        this.out.writeBoolean(true);
                        this.out.flush();
                    }
                    Team team = (Team)((Object)this.in.readObject());
                    playerOptions.add(playerID, new PlayerOptions(0, "NET", name, team, -1));
                    if (mode == null) continue;
                    mode.refresh();
                    continue;
                }
                if (code == 0) {
                    InetSocketAddress addr = new InetSocketAddress(this.s.getInetAddress(), serverPort);
                    NetplayGamePanel.startGame(mode.getMap(), mode.getMode(), playerOptions.toArray(new PlayerOptions[4]), addr, mode.getPlayerNum());
                    running = false;
                    continue;
                }
                if (code == -20) {
                    mode.reprepClient();
                    MainClientHandler.mode.playerNum = this.in.readInt();
                    playerOptions.clear();
                    playerOptions.addAll(Arrays.asList(originalOptions));
                    ArrayList skins = (ArrayList)this.in.readObject();
                    ArrayList teams = (ArrayList)this.in.readObject();
                    block7: for (int i = 0; i < skins.size(); ++i) {
                        PlayerOptions other = new PlayerOptions(0, "NET", (String)skins.get(i), (Team)((Object)teams.get(i)), -1);
                        for (int j = 0; j < originalOptions.length; ++j) {
                            PlayerOptions mine = originalOptions[j];
                            if (mine.SKIN.equals(other.SKIN) && mine.TEAM.equals((Object)other.TEAM)) continue block7;
                        }
                        playerOptions.add(i, other);
                    }
                    continue;
                }
                if (code != -10) continue;
                running = false;
            }
            catch (EOFException e) {
            }
            catch (IOException ex) {
                Logger.getLogger(MainClientHandler.class.getName()).log(Level.SEVERE, null, ex);
                break;
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(MainClientHandler.class.getName()).log(Level.SEVERE, null, ex);
                break;
            }
        }
        try {
            this.in.close();
            this.out.close();
            this.s.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MainClientHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

