/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.client;

import com.dmgame.GameLogic;
import com.dmgame.MapScene;
import com.dmgame.Updatable;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.map.interactivetiles.ClearItemBlock;
import com.dmgame.map.interactivetiles.QuestionBlock;
import com.dmgame.net.SMWNetworkError;
import com.dmgame.net.client.MainClientHandler;
import com.dmgame.sound.Sound;
import com.dmgame.sound.SoundPlayer;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class NetplayClient {
    public static final int BASE_PORT = 10000;
    private static InetSocketAddress sendAddr;
    private static DatagramSocket socket;
    public static boolean connected;
    public static boolean host;
    private static Thread receiverThread;
    public static boolean running;
    private static ScriptEngine se;
    private static volatile long packetCounter;

    public static void start(InetSocketAddress addr, int playerNum) throws SocketException {
        se = new ScriptEngineManager().getEngineByExtension("groovy");
        System.out.println(addr);
        running = true;
        connected = true;
        socket = new DatagramSocket(10000 + playerNum + 1);
        socket.setSendBufferSize(64);
        socket.setReceiveBufferSize(64);
        System.out.println("Bound to: " + socket.getLocalSocketAddress());
        sendAddr = addr;
        receiverThread = new Thread((Runnable)new NetworkReceiver(), "Client netplay listener");
        receiverThread.start();
    }

    private static void receiveEntityUpdate(byte[] data) {
        Entity e;
        ByteBuffer temp = ByteBuffer.wrap(data, 1, 4);
        int entityNum = temp.getInt();
        if (GameLogic.running && (e = GameLogic.entities.get(entityNum)) != null) {
            e.getNetworkUpdate(ByteBuffer.wrap(data, 5, 4).getFloat(), ByteBuffer.wrap(data, 9, 4).getFloat(), ByteBuffer.wrap(data, 13, 4).getFloat(), ByteBuffer.wrap(data, 17, 4).getFloat(), data);
        }
    }

    private static void receivePlatformUpdate(byte[] data) {
        if (GameLogic.currentMap != null) {
            GameLogic.currentMap.platforms.get(data[1]).getNetworkUpdate(data);
        }
    }

    public static void sendKeyUpdate(Player pSource, int key, boolean pressed) {
        if (connected) {
            byte source = NetplayClient.getPlayerNumber(pSource);
            byte[] data = new byte[]{40, source, (byte)key, (byte)(pressed ? 0 : 255)};
            try {
                DatagramPacket out = new DatagramPacket(data, 0, 4, sendAddr);
                assert (out.getLength() == 4);
                socket.send(out);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void sendGameComplete() {
        if (connected) {
            try {
                DatagramPacket out = new DatagramPacket(new byte[]{100}, 0, 1, sendAddr);
                socket.send(out);
            }
            catch (SocketException ex) {
                Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void endGame() throws IOException {
        if (MapScene.currentInstance != null) {
            MapScene.currentInstance.cleanup();
        }
        GameLogic.cleanup();
        running = false;
        connected = false;
        int port = socket.getLocalPort();
        socket.close();
        ServerSocket serverSocket = new ServerSocket(port);
        Socket s = serverSocket.accept();
        serverSocket.close();
        MainClientHandler.returnFromGame(s);
        NetplayClient.cleanup();
    }

    public static byte getPlayerNumber(Player pSource) {
        if (pSource == GameLogic.playerOne) {
            return 0;
        }
        if (pSource == GameLogic.playerTwo) {
            return 1;
        }
        if (pSource == GameLogic.playerThree) {
            return 2;
        }
        if (pSource == GameLogic.playerFour) {
            return 3;
        }
        return -1;
    }

    public static void receiveItemUpdate(int block, int powerUp, boolean spawn) {
        Updatable u = GameLogic.updatables.toArray(new Updatable[GameLogic.updatables.size()])[block];
        if (u instanceof ClearItemBlock) {
            ((ClearItemBlock)u).generateNetPowerup(powerUp, spawn);
        } else if (u instanceof QuestionBlock) {
            ((QuestionBlock)u).generateNetPowerup(powerUp);
        } else {
            throw new SMWNetworkError("Update mismatch.");
        }
    }

    public static void receiveCreateUpdate(byte[] createData) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(createData, 5, createData.length - 5);
        System.out.println(createData.length);
        try {
            Entity created;
            ObjectInputStream in = new ObjectInputStream(byteStream);
            Object o = in.readObject();
            try {
                if (o.equals("null")) {
                    return;
                }
                String s = ((String)o).replace("entities.get(-1)", "null");
                created = (Entity)se.eval("import com.dmgame.entity.*;import com.dmgame.entity.powerups.*;import com.dmgame.entity.projectiles.*;import static com.dmgame.GameLogic.*;import static com.dmgame.entity.Team.*;return new " + o);
            }
            catch (ScriptException ex) {
                Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            created.entityID = ByteBuffer.wrap(createData, 1, 4).getInt();
            GameLogic.addEntity(created);
        }
        catch (EOFException ex) {
            Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("Error: number of bytes received: " + createData.length);
        }
        catch (IOException ex) {
            Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void cleanup() {
        sendAddr = null;
        socket = null;
        connected = false;
        host = false;
        receiverThread = null;
        running = false;
        se = null;
        packetCounter = 0L;
    }

    static {
        connected = false;
        host = false;
        running = false;
        packetCounter = 0L;
    }

    private static class NetworkReceiver
    implements Runnable {
        private NetworkReceiver() {
        }

        @Override
        public void run() {
            try {
                socket.setSoTimeout(6000);
            }
            catch (SocketException ex) {
                Logger.getLogger(NetplayClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            while (running) {
                try {
                    DatagramPacket in = new DatagramPacket(new byte[64], 64);
                    socket.receive(in);
                    byte[] data = in.getData();
                    switch (data[0]) {
                        case 50: {
                            NetplayClient.receivePlatformUpdate(data);
                            break;
                        }
                        case 60: {
                            NetplayClient.receiveEntityUpdate(data);
                            break;
                        }
                        case 70: {
                            short block = ByteBuffer.wrap(data, 1, 2).getShort();
                            NetplayClient.receiveItemUpdate(block, data[3], data[4] == 0);
                            break;
                        }
                        case 30: {
                            NetplayClient.receiveCreateUpdate(data);
                            break;
                        }
                        case 80: {
                            GameLogic.removeEntity(GameLogic.entities.get(ByteBuffer.wrap(data, 1, 4).getInt()));
                            break;
                        }
                        case 90: {
                            SoundPlayer.playTimeWarning();
                            break;
                        }
                        case 101: {
                            NetplayClient.endGame();
                        }
                    }
                }
                catch (SocketTimeoutException ex) {
                    if (!running) {
                        return;
                    }
                    running = false;
                    connected = false;
                    SoundPlayer.playSound(Sound.BREAK);
                    System.err.println("Server error!");
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

