/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.client;

import com.dmgame.entity.Team;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.menu.NetplayConnectionPanel;
import com.dmgame.net.client.ClientUtility;
import com.dmgame.net.client.MainClientHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkClientMenuHandler {
    public static final int CONNECTED = 0;
    public static final int CONNECT_FAIL = -1;
    public static final int FAIL_TOO_MANY = -2;
    public static final int FAIL_OLD_VERSION = -3;
    public static final int CONNECT_WAIT = 1;
    public static volatile boolean cancelWait = false;

    public static int getConnection(NetplayConnectionPanel panel, int players, String[] skins, Team[] colors, SocketAddress address) throws IOException {
        PlayerOptions[] options = new PlayerOptions[players];
        for (int i = 0; i < players; ++i) {
            options[i] = new PlayerOptions(i, "HUMAN", skins[i], colors[i], -1);
        }
        Socket s = new Socket();
        s.setSoTimeout(3000);
        s.connect(address);
        s.setSoTimeout(0);
        ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
        ObjectInputStream in = new ObjectInputStream(s.getInputStream());
        out.writeByte(0);
        out.writeByte(4);
        out.writeChar(68);
        out.flush();
        if (!in.readBoolean()) {
            in.close();
            out.close();
            s.close();
            return -3;
        }
        out.writeInt(players);
        out.flush();
        if (!in.readBoolean()) {
            System.out.println("closing: too many players");
            in.close();
            out.close();
            s.close();
            return -2;
        }
        for (int i = 0; i < players; ++i) {
            out.writeObject(skins[i]);
            out.flush();
            if (!in.readBoolean()) {
                ClientUtility.sendSkin(skins[i], out);
                out.reset();
                in.readBoolean();
            }
            out.writeObject((Object)colors[i]);
            out.flush();
        }
        if (in.readBoolean()) {
            cancelWait = false;
            new Thread(new Waiter(panel, in, s, options)).start();
            return 1;
        }
        MainClientHandler.accepted(s, options);
        return 0;
    }

    private static class Waiter
    implements Runnable {
        NetplayConnectionPanel panel;
        ObjectInputStream in;
        Socket s;
        PlayerOptions[] options;

        Waiter(NetplayConnectionPanel panel, ObjectInputStream in, Socket s, PlayerOptions[] options) {
            this.panel = panel;
            this.in = in;
            this.s = s;
            this.options = options;
        }

        @Override
        public void run() {
            try {
                while (this.in.readBoolean()) {
                    if (!cancelWait) continue;
                    return;
                }
                if (!cancelWait) {
                    MainClientHandler.accepted(this.s, this.options);
                    this.panel.confirmConnect();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(NetworkClientMenuHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

