/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.communication;

import com.dmgame.MapScene;
import com.dmgame.SMWException;
import com.dmgame.Utility;
import com.dmgame.entity.BulletBillEntity;
import com.dmgame.entity.Entity;
import com.dmgame.entity.FireballBar;
import com.dmgame.entity.Rotodisc;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.gui.SMWButton;
import com.dmgame.gui.SMWLabel;
import com.dmgame.io.MapIO;
import com.dmgame.map.Map;
import com.dmgame.map.Platform;
import com.dmgame.map.Warp;
import com.dmgame.menu.MenuScene;
import com.dmgame.menu.NetplayGamePanel;
import com.dmgame.modes.GameMode;
import com.dmgame.net.client.ClientUtility;
import com.dmgame.net.client.MainClientHandler;
import com.dmgame.net.communication.CommunicationMode;
import com.dmgame.net.server.MainServerHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SimpleCommunicationMode
extends CommunicationMode {
    private static final long serialVersionUID = 1L;
    private static final int NO_UPDATE_YET = 20;
    private static final int PREP_GAME = 30;
    private static final int START_GAME = 40;
    private static SimpleNetplayGamePanel PANEL;
    private static HashMap<String, BufferedImage> skins;
    private static boolean ready;
    private static boolean gotMapFromServer;
    private static volatile boolean[] playerCheck;
    private static volatile boolean[] playerReady;
    private static File mapFile;
    int timer = -1;
    int playerTimer = -1;

    public SimpleCommunicationMode(int maxPlayers) {
        this.maxPlayers = maxPlayers;
        playerCheck = new boolean[maxPlayers];
        playerReady = new boolean[maxPlayers];
        if (mapFile == null) {
            File[] mapFiles = new File("res/maps").listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getAbsolutePath().contains(".map");
                }
            });
            Random chooser = new Random();
            mapFile = mapFiles[chooser.nextInt(mapFiles.length)];
        }
    }

    @Override
    public boolean getUpdateFromServer(Socket socket, ObjectInputStream in, ObjectOutputStream out) throws IOException {
        int code = in.readInt();
        if (code < 20) {
            SimpleCommunicationMode.PANEL.readyButton.setText(Utility.lang.getProperty("start countdown") + " " + code + "...");
            code = in.readInt();
        }
        if (code == 30) {
            try {
                String s = (String)in.readObject();
                if (!new File(s).exists()) {
                    out.writeBoolean(false);
                    out.flush();
                    map = (Map)in.readObject();
                } else {
                    try {
                        map = MapIO.loadMap(new File(s), false);
                        out.writeBoolean(true);
                        out.flush();
                    }
                    catch (FileNotFoundException ex) {
                        out.writeBoolean(false);
                        out.flush();
                        map = (Map)in.readObject();
                    }
                    catch (SMWException ex) {
                        out.writeBoolean(false);
                        out.flush();
                        map = (Map)in.readObject();
                    }
                }
                mode = (GameMode)in.readObject();
                this.playerNum = in.readInt();
                SimpleCommunicationMode.PANEL.mapLabel.setText("Map: " + SimpleCommunicationMode.map.mapName);
                SimpleCommunicationMode.PANEL.modeLabel.setText("Mode: " + mode.toString());
                PANEL.setMap(map);
                gotMapFromServer = true;
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            if (code == 40) {
                InetSocketAddress addr = new InetSocketAddress(socket.getInetAddress(), MainClientHandler.serverPort);
                NetplayGamePanel.startGame(map, mode, MainClientHandler.playerOptions.toArray(new PlayerOptions[4]), addr, this.playerNum);
                return false;
            }
            if (code == 20) {
                out.writeBoolean(ready);
                out.flush();
                this.updateSkins();
            }
        }
        return true;
    }

    @Override
    public NetplayGamePanel getPanel(MenuScene parentScene, TexturePaint bg) {
        if (PANEL == null) {
            PANEL = new SimpleNetplayGamePanel(parentScene, bg);
        }
        return PANEL;
    }

    @Override
    public void reprepClient() {
        SimpleCommunicationMode.PANEL.readyButton.setText("Ready!");
        ready = false;
        gotMapFromServer = false;
        this.refresh();
    }

    private void updateSkins() {
        if (skins == null) {
            skins = new HashMap();
        }
        for (PlayerOptions o : MainClientHandler.playerOptions) {
            if (skins.containsKey(o.SKIN)) continue;
            try {
                if (ClientUtility.savingSkin) {
                    return;
                }
                BufferedImage im = ImageIO.read(new File("res/gfx/skins/" + o.SKIN + ".png"));
                if (im == null) continue;
                skins.put(o.SKIN, im.getSubimage(0, 0, 32, 32));
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (int i = 0; i < MainClientHandler.playerOptions.size() && i < SimpleCommunicationMode.PANEL.skinLabels.length; ++i) {
            SimpleCommunicationMode.PANEL.skinLabels[i].setIcon(skins.get(MainClientHandler.playerOptions.get((int)i).SKIN));
        }
    }

    @Override
    public void refresh() {
        skins = new HashMap();
        if (PANEL != null && SimpleCommunicationMode.PANEL.skinLabels != null) {
            for (SMWLabel l : SimpleCommunicationMode.PANEL.skinLabels) {
                l.setIcon(null);
            }
        }
    }

    @Override
    public void reprepServer() {
        this.timer = -1;
        this.playerTimer = -1;
        playerCheck = new boolean[this.maxPlayers];
        playerReady = new boolean[this.maxPlayers];
        ready = false;
        File[] mapFiles = new File("res/maps").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getAbsolutePath().contains(".map");
            }
        });
        Random chooser = new Random();
        mapFile = mapFiles[chooser.nextInt(mapFiles.length)];
        map = null;
        mode.reset();
    }

    @Override
    public boolean sendServerUpdate(ObjectInputStream in, ObjectOutputStream out, int firstPlayer, int numPlayers) throws IOException {
        int i;
        if (map == null) {
            this.loadMap();
        }
        int numConnected = 0;
        boolean allReady = true;
        for (i = 0; i < playerReady.length; ++i) {
            boolean bl = allReady = allReady && playerReady[i];
            if (!playerReady[i]) continue;
            ++numConnected;
        }
        if (this.timer != -1) {
            out.writeInt(this.timer);
            out.flush();
        }
        if (allReady) {
            out.writeInt(40);
            out.flush();
            MainServerHandler.setupForGame(map, mode);
            return false;
        }
        if (!playerCheck[firstPlayer]) {
            out.writeInt(30);
            out.writeObject(mapFile.getPath().trim());
            if (!in.readBoolean()) {
                out.writeObject(map);
            }
            out.writeObject(mode);
            for (i = firstPlayer; i < firstPlayer + numPlayers; ++i) {
                SimpleCommunicationMode.playerCheck[i] = true;
            }
            out.writeInt(firstPlayer);
            out.flush();
        } else {
            out.writeInt(20);
            out.flush();
            if (in.readBoolean()) {
                for (i = firstPlayer; i < firstPlayer + numPlayers; ++i) {
                    SimpleCommunicationMode.playerReady[i] = true;
                }
                if (this.playerTimer == -1 && numConnected > numPlayers) {
                    this.playerTimer = firstPlayer;
                    this.timer = 11;
                }
            }
        }
        if (this.playerTimer == firstPlayer) {
            --this.timer;
            if (this.timer == 0) {
                for (i = 0; i < playerReady.length; ++i) {
                    SimpleCommunicationMode.playerReady[i] = true;
                }
            }
        }
        return true;
    }

    private void loadMap() {
        try {
            map = MapIO.loadMap(mapFile, false);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SMWException ex) {
            Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static BufferedImage getMapPreview(Map map, double scale) {
        BufferedImage im = new BufferedImage((int)((double)map.MAP_WIDTH * scale), (int)((double)map.MAP_HEIGHT * scale), 2);
        Graphics2D g2D = im.createGraphics();
        g2D.scale(scale, scale);
        SimpleCommunicationMode.drawMapPreview(g2D, map);
        g2D.dispose();
        return im;
    }

    /*
     * WARNING - void declaration
     */
    private static void drawMapPreview(Graphics2D g2D, Map map) {
        void var4_14;
        int l;
        g2D.setColor(map.bgColor);
        g2D.fillRect(0, 0, map.MAP_WIDTH, map.MAP_HEIGHT);
        if (map.background != null) {
            Rectangle r = new Rectangle(0, 0, map.background.getWidth(), map.background.getHeight());
            Paint paint = g2D.getPaint();
            g2D.setPaint(new TexturePaint(map.background, r));
            g2D.fill(new Rectangle(0, 0, map.MAP_WIDTH, map.MAP_HEIGHT));
            g2D.setPaint(paint);
        }
        for (l = 0; l < map.tilesBackground.size(); ++l) {
            for (int x = 0; x < map.tilesBackground.get(l).length; ++x) {
                for (int i = 0; i < map.tilesBackground.get(l)[x].length; ++i) {
                    if (map.tilesBackground.get(l)[x][i] == null || map.tilesBackground.get(l)[x][i].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)map.tilesBackground.get(l)[x][i].getUnclonedGraphicTile().getImage(), x * 32, i * 32, null);
                }
            }
        }
        for (l = 0; l < map.tilesForeground.size(); ++l) {
            for (int x = 0; x < map.tilesForeground.get(l).length; ++x) {
                for (int i = 0; i < map.tilesForeground.get(l)[x].length; ++i) {
                    if (map.tilesForeground.get(l)[x][i] == null || map.tilesForeground.get(l)[x][i].getUnclonedGraphicTile() == null) continue;
                    g2D.drawImage((Image)map.tilesForeground.get(l)[x][i].getUnclonedGraphicTile().getImage(), x * 32, i * 32, null);
                }
            }
        }
        for (int x = 0; x < map.iTiles.length; ++x) {
            for (int y2 = 0; y2 < map.iTiles[x].length; ++y2) {
                if (map.iTiles[x][y2] == null) continue;
                g2D.drawImage((Image)map.iTiles[x][y2].tile.getImageAt(0), x * 32, y2 * 32, null);
            }
        }
        Warp[][][] arr$ = map.warps;
        int len$ = arr$.length;
        boolean bl = false;
        while (var4_14 < len$) {
            Warp[][] array;
            Warp[][] arr$2 = array = arr$[var4_14];
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Warp[] arrayTwo;
                for (Warp w : arrayTwo = arr$2[i$2]) {
                    if (w == null) continue;
                    g2D.drawImage((Image)w.sprite, w.mapRelX * 32, w.mapRelY * 32, null);
                }
            }
            ++var4_14;
        }
        for (Platform platform : map.platforms) {
            int x;
            Point2D.Float startPoint = platform.helper.getStartPoint();
            for (x = 0; x < platform.gTiles.length; ++x) {
                for (int y3 = 0; y3 < platform.gTiles[x].length; ++y3) {
                    if (platform.gTiles[x][y3] == null) continue;
                    g2D.drawImage((Image)platform.gTiles[x][y3].getImage(), (int)((double)startPoint.x - platform.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - platform.getWidth() / 2.0) + y3 * 32, null);
                }
            }
            for (x = 0; x < platform.iTiles.length; ++x) {
                for (int y4 = 0; y4 < platform.iTiles[x].length; ++y4) {
                    if (platform.iTiles[x][y4] == null) continue;
                    g2D.drawImage((Image)platform.iTiles[x][y4].tile.getImage(), (int)((double)startPoint.x - platform.getWidth() / 2.0) + x * 32, (int)((double)startPoint.y - platform.getWidth() / 2.0) + y4 * 32, null);
                }
            }
            Shape s = platform.getPath();
            if (s instanceof Line2D) {
                g2D.setColor(Color.RED);
            } else if (s instanceof Ellipse2D) {
                g2D.setColor(Color.GREEN);
            } else if (s instanceof Rectangle) {
                g2D.setColor(Color.BLUE);
            } else if (s instanceof RoundRectangle2D) {
                g2D.setColor(Color.MAGENTA);
            } else if (s instanceof Polygon) {
                g2D.setColor(Color.GRAY);
            }
            g2D.draw(platform.getPath());
        }
        for (Entity entity : map.mapEntities) {
            g2D.drawImage((Image)entity.getImage(), Math.round(entity.entityX), Math.round(entity.entityY), null);
            if (entity instanceof BulletBillEntity) {
                ((BulletBillEntity)entity).drawPath(g2D, map);
            }
            if (entity instanceof Rotodisc) {
                for (Rotodisc.Disc d : ((Rotodisc)entity).discs) {
                    d.drawToScreen(g2D, d.entityX, d.entityY);
                }
            }
            if (!(entity instanceof FireballBar)) continue;
            for (FireballBar.BarFireball b : ((FireballBar)entity).fireballs) {
                b.drawToScreen(g2D, b.entityX, b.entityY);
            }
        }
    }

    static {
        ready = false;
        gotMapFromServer = false;
    }

    static class SimpleNetplayGamePanel
    extends NetplayGamePanel {
        private static final long serialVersionUID = 8131629202003725415L;
        SMWLabel mapLabel;
        SMWLabel modeLabel;
        SMWLabel mapDisplayLabel;
        SMWButton readyButton;
        SMWLabel[] skinLabels;
        final int BUTTON_PADDING = 8;
        final int MAP_SCALE = 2;

        private SimpleNetplayGamePanel(MenuScene parentScene, TexturePaint bg) {
            super(parentScene, bg);
            this.setLayout(new GridBagLayout());
            JPanel centeringPanel = new JPanel(new GridBagLayout()){
                private static final long serialVersionUID = -7330824009705123302L;

                @Override
                public void paintComponent(Graphics g) {
                }
            };
            this.mapLabel = new SMWLabel(Utility.lang.getProperty("server wait"), 640, -1);
            this.modeLabel = new SMWLabel(Utility.lang.getProperty("server wait"), 640, -1);
            this.mapDisplayLabel = new SMWLabel(528, 400);
            BufferedImage bgImage = null;
            try {
                bgImage = ImageIO.read(new File("res/gfx/packs/" + MapScene.texturePackName + "/menu/menu_dialog_9patch.png"));
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleCommunicationMode.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mapDisplayLabel.setDynamicBackground(bgImage);
            this.readyButton = new SMWButton(Utility.lang.getProperty("ready"), this.mapDisplayLabel.getWidth(), -1);
            this.readyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (gotMapFromServer) {
                        ready = true;
                        SimpleNetplayGamePanel.this.readyButton.setText("waiting for other players...");
                    }
                }
            });
            this.skinLabels = new SMWLabel[4];
            for (int i = 0; i < this.skinLabels.length; ++i) {
                this.skinLabels[i] = new SMWLabel("", 48, 48);
                this.skinLabels[i].setDynamicBackground(bgImage);
            }
            int gridy = 0;
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = gridy++;
            c.gridwidth = this.skinLabels.length;
            centeringPanel.add((Component)this.mapLabel, c);
            c = new GridBagConstraints();
            c.gridy = gridy++;
            c.gridwidth = this.skinLabels.length;
            centeringPanel.add((Component)this.modeLabel, c);
            c = new GridBagConstraints();
            c.gridy = gridy++;
            c.gridwidth = this.skinLabels.length;
            centeringPanel.add((Component)this.readyButton, c);
            c = new GridBagConstraints();
            c.gridy = gridy++;
            c.gridwidth = this.skinLabels.length;
            centeringPanel.add((Component)this.mapDisplayLabel, c);
            ++gridy;
            for (int i = 0; i < this.skinLabels.length; ++i) {
                c = new GridBagConstraints();
                c.gridy = gridy;
                c.weightx = 1.0;
                c.gridx = i;
                centeringPanel.add((Component)this.skinLabels[i], c);
            }
            c = new GridBagConstraints();
            c.anchor = 10;
            this.add((Component)centeringPanel, c);
        }

        void setMap(Map map) {
            this.mapDisplayLabel.setIcon(SimpleCommunicationMode.getMapPreview(map, 0.5));
        }
    }
}

