/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.server;

import com.dmgame.Utility;
import com.dmgame.net.script.ServerCommand;
import com.dmgame.net.server.ServerUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class CommandInterpreter
implements Runnable {
    private HashMap<String, ServerCommand> commands;
    private TreeSet<String> commandSet;
    private ScriptEngineManager m;
    private File scriptDir;
    private final String GROOVY_SCRIPT_PREFIX = "import com.dmgame.*;import com.dmgame.entity.*;import com.dmgame.entity.powerups.*;import com.dmgame.entity.projectiles.*;import com.dmgame.GameLogic;import com.dmgame.map.*; ";

    public CommandInterpreter() {
        this("res/scripts/server/");
    }

    public CommandInterpreter(String dir) {
        this.scriptDir = new File(dir);
        if (!this.scriptDir.isDirectory()) {
            throw new IllegalArgumentException("dir must be a directory");
        }
        this.reloadScripts();
    }

    @Override
    public void run() {
        try (Scanner input = new Scanner(System.in);){
            while (ServerUtility.running) {
                this.doCommand(input.nextLine());
            }
        }
    }

    public boolean doCommand(String command) {
        Scanner splitter = new Scanner(command);
        if (!splitter.hasNext()) {
            splitter.close();
            return false;
        }
        String s = splitter.next();
        if (s.contains("/")) {
            s = s.substring(1);
        }
        if ("reload".contains(s)) {
            this.reloadScripts();
        }
        if ("execute".contains(s)) {
            this.executeScript(command, splitter);
        }
        boolean sucess = false;
        try {
            for (String commandName : this.commandSet) {
                if (!commandName.startsWith(s) || !(sucess = this.commands.get(commandName).perform(splitter))) continue;
                this.commands.get(commandName).setLatestCommand(command);
            }
        }
        catch (RuntimeException ex) {
            System.err.println(Utility.lang.getProperty("command exception"));
            if (ServerUtility.verbose) {
                ex.printStackTrace();
            }
            System.err.println(ex.getMessage());
        }
        return sucess;
    }

    private void reloadScripts() {
        HashMap<String, ServerCommand> oldCommands = this.commands;
        this.commands = new HashMap();
        this.m = new ScriptEngineManager();
        File[] scriptFiles = this.scriptDir.listFiles();
        for (int i = 0; i < scriptFiles.length; ++i) {
            if (scriptFiles[i].isDirectory()) continue;
            try {
                String name = scriptFiles[i].getPath();
                ScriptEngine e = this.m.getEngineByExtension(name.substring(name.indexOf(".") + 1));
                ServerUtility.output("loading script: " + name);
                ServerCommand c = (ServerCommand)e.eval(new FileReader(scriptFiles[i]));
                this.commands.put(c.getName(), c);
                continue;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(CommandInterpreter.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (ScriptException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (ClassCastException ex) {
                Logger.getLogger(CommandInterpreter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.commandSet = new TreeSet();
        this.commandSet.addAll(this.commands.keySet());
        if (oldCommands != null) {
            for (String commandName : this.commandSet) {
                this.commands.get(commandName).setLatestCommand(oldCommands.get(commandName).getLatestCommand());
            }
        }
        System.out.println(Utility.lang.getProperty("scripts reloaded"));
    }

    public void writeConfig(Writer out) throws IOException {
        for (String commandName : this.commandSet) {
            String command = this.commands.get(commandName).getLatestCommand();
            if (!command.equals("")) {
                out.write(command + "\r\n");
            }
            out.flush();
        }
    }

    public void printConfig() {
        for (String commandName : this.commandSet) {
            String command = this.commands.get(commandName).getLatestCommand();
            if (command.equals("")) continue;
            System.out.println(command);
        }
    }

    private void executeScript(String line, Scanner splitter) {
        if (!splitter.hasNext()) {
            return;
        }
        String type = splitter.next();
        if (type.equalsIgnoreCase("local") || type.equalsIgnoreCase("native") || type.equalsIgnoreCase("console") || type.equalsIgnoreCase("command")) {
            int loc = line.indexOf(type);
            line = line.substring(loc + type.length() + 1);
            try {
                Runtime.getRuntime().exec(line);
            }
            catch (IOException ex) {
                System.err.println(Utility.lang.getProperty("console command error"));
                System.err.println(ex.getMessage());
            }
            catch (RuntimeException ex) {
                System.err.println(Utility.lang.getProperty("command exception"));
                if (ServerUtility.verbose) {
                    ex.printStackTrace();
                }
                System.err.println(ex.getLocalizedMessage());
            }
            return;
        }
        ScriptEngine e = this.m.getEngineByExtension(type);
        if (e == null && (e = this.m.getEngineByName(type)) == null) {
            System.out.println(Utility.lang.getProperty("unkown script") + " " + type);
            return;
        }
        int loc = line.indexOf(type);
        line = line.substring(loc + type.length() + 1);
        try {
            Object o = e.eval("import com.dmgame.*;import com.dmgame.entity.*;import com.dmgame.entity.powerups.*;import com.dmgame.entity.projectiles.*;import com.dmgame.GameLogic;import com.dmgame.map.*; " + line);
            if (o != null) {
                System.out.println(o);
            }
        }
        catch (ScriptException ex) {
            System.err.println(Utility.lang.getProperty("script error"));
            System.err.println(ex.getMessage());
        }
        catch (RuntimeException ex) {
            System.err.println(Utility.lang.getProperty("command exception"));
            if (ServerUtility.verbose) {
                ex.printStackTrace();
            }
            System.err.println(ex.getMessage());
        }
    }
}

