/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.server;

import com.dmgame.Utility;
import com.dmgame.entity.Team;
import com.dmgame.map.Map;
import com.dmgame.modes.GameMode;
import com.dmgame.net.IOAction;
import com.dmgame.net.communication.CommunicationMode;
import com.dmgame.net.communication.SimpleCommunicationMode;
import com.dmgame.net.server.ClientInfo;
import com.dmgame.net.server.NetplayServer;
import com.dmgame.net.server.ServerConnectionHandler;
import com.dmgame.net.server.ServerUtility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MainServerHandler {
    private static ArrayList<ServerIOHandler> IOhandlers;
    private static ArrayList<ClientInfo> clientInfo;
    static ArrayList<Team> teams;
    private static volatile int readyForGameNum;
    private static volatile int numPlayers;
    private static boolean hasStarted;
    public static CommunicationMode mode;
    private static boolean running;
    public static volatile boolean inGame;

    public static void returnFromGame(List<ClientInfo> clientInfo) throws IOException {
        running = true;
        readyForGameNum = 0;
        mode.reprepServer();
        IOhandlers = new ArrayList();
        for (ClientInfo ci : clientInfo) {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(ci.ip, ServerConnectionHandler.port + ci.firstPlayer + 1));
            if (s.isConnected()) {
                ServerIOHandler newHandler = new ServerIOHandler(s, ci.firstPlayer, ci.skinNames, ci.teams, ci).start();
                IOhandlers.add(newHandler);
                ++readyForGameNum;
                continue;
            }
            ServerUtility.output(Utility.lang.getProperty("reconnect fail") + " " + ci.firstPlayer, true);
        }
        inGame = false;
    }

    public static void accept(String[] names, Team[] teams, Socket s) throws IOException {
        if (IOhandlers == null) {
            MainServerHandler.init();
        }
        running = true;
        MainServerHandler.teams.addAll(Arrays.asList(teams));
        ClientInfo info = new ClientInfo();
        info.ip = s.getInetAddress();
        info.port = s.getPort();
        info.firstPlayer = numPlayers;
        info.numPlayers = names.length;
        info.skinNames = names;
        info.teams = teams;
        clientInfo.add(info);
        ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
        out.writeObject(mode);
        out.flush();
        ArrayList<String> otherSkins = new ArrayList<String>();
        ArrayList<Team> otherTeams = new ArrayList<Team>();
        for (int i = 0; i < IOhandlers.size(); ++i) {
            ServerIOHandler handler = IOhandlers.get(i);
            handler.doSkinUpdate(names, teams, numPlayers);
            otherSkins.addAll(Arrays.asList(handler.getSkins()));
            otherTeams.addAll(Arrays.asList(handler.getTeams()));
        }
        ServerIOHandler newHandler = new ServerIOHandler(s, numPlayers, names, teams, info).start();
        numPlayers += names.length;
        if (otherSkins.size() > 0) {
            newHandler.doSkinUpdate(otherSkins.toArray(new String[1]), otherTeams.toArray(new Team[1]), 0);
        }
        IOhandlers.add(newHandler);
        ++readyForGameNum;
        mode.setNumPlayers(numPlayers);
        ServerUtility.output(Utility.lang.getProperty("connected client"));
    }

    private static void init() {
        hasStarted = true;
        IOhandlers = new ArrayList();
        clientInfo = new ArrayList();
        teams = new ArrayList();
        if (mode == null) {
            mode = new SimpleCommunicationMode(4);
        }
        new Thread(new Runnable(){

            @Override
            public synchronized void run() {
                while (ServerUtility.running) {
                    for (ServerIOHandler h : IOhandlers) {
                        h.queueMainUpdate();
                    }
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "Main Update queue thread").start();
    }

    public static void setupForGame(Map map, GameMode mode) throws SocketException {
        inGame = true;
        if (--readyForGameNum <= 0) {
            running = false;
            ServerUtility.output(Utility.lang.getProperty("starting game"));
            NetplayServer.start(clientInfo, map, mode);
        }
    }

    static boolean setMode(CommunicationMode newMode) {
        if (!hasStarted) {
            mode = newMode;
        }
        return hasStarted;
    }

    private static void handleDisconnect(ClientInfo info) {
        int id = clientInfo.indexOf(info);
        int numDisconnected = info.numPlayers;
        numPlayers -= numDisconnected;
        readyForGameNum -= numDisconnected;
        for (int x = id; x < clientInfo.size(); ++x) {
            MainServerHandler.clientInfo.get((int)x).firstPlayer -= numDisconnected;
            MainServerHandler.IOhandlers.get((int)x).id -= numDisconnected;
        }
        clientInfo.remove(info);
        ArrayList<String> skins = new ArrayList<String>();
        ArrayList<Team> teams = new ArrayList<Team>();
        for (ServerIOHandler iohandler : IOhandlers) {
            if (iohandler.closing) continue;
            skins.addAll(Arrays.asList(iohandler.names));
            teams.addAll(Arrays.asList(iohandler.teams));
        }
        for (ServerIOHandler iohandler : IOhandlers) {
            try {
                iohandler.forceUpdate(skins, teams);
            }
            catch (IOException ex) {
                Logger.getLogger(MainServerHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        MainServerHandler.teams = teams;
        mode.reprepServer();
    }

    static boolean notEnoughSpace(int players) {
        return players + numPlayers > MainServerHandler.mode.maxPlayers;
    }

    static {
        readyForGameNum = 0;
        numPlayers = 0;
        hasStarted = false;
        inGame = false;
    }

    private static class ServerIOHandler
    implements Runnable {
        boolean startGame = false;
        boolean closing = false;
        String[] names;
        Team[] teams;
        volatile int id;
        private Queue<IOAction> actionQueue;
        private Socket s;
        private ObjectInputStream in;
        private ObjectOutputStream out;
        private ClientInfo info;

        ServerIOHandler(Socket s, int id, String[] names, Team[] teams, ClientInfo info) throws IOException {
            this.info = info;
            this.names = names;
            this.teams = teams;
            this.actionQueue = new LinkedList<IOAction>();
            this.names = names;
            this.id = id;
            this.s = s;
            this.in = new ObjectInputStream(s.getInputStream());
            this.out = new ObjectOutputStream(s.getOutputStream());
        }

        void doSkinUpdate(String[] names, Team[] teams, int playerID) {
            for (int i = 0; i < names.length; ++i) {
                this.queueSkinUpdate(names[i], teams[i], playerID + i);
            }
        }

        ServerIOHandler start() {
            new Thread((Runnable)this, "IO thread #" + this.id).start();
            return this;
        }

        String[] getSkins() {
            return this.names;
        }

        Team[] getTeams() {
            return this.teams;
        }

        void queueSkinUpdate(final String name, final Team team, final int playerID) {
            this.actionQueue.add(new IOAction(){

                @Override
                public boolean performAction(ObjectInputStream in, ObjectOutputStream out) throws IOException {
                    out.writeInt(20);
                    out.writeInt(playerID);
                    out.writeObject(name);
                    out.flush();
                    if (!in.readBoolean()) {
                        ServerUtility.sendSkin(out, name);
                        in.readBoolean();
                    }
                    out.writeObject((Object)team);
                    out.flush();
                    return true;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (running && ServerUtility.running) {
                while (!this.actionQueue.isEmpty()) {
                    try {
                        boolean continuework = this.actionQueue.poll().performAction(this.in, this.out);
                        if (continuework) continue;
                        break block12;
                    }
                    catch (IOException ex) {
                        try {
                            this.out.writeInt(-30);
                            this.out.flush();
                        }
                        catch (IOException ex1) {
                            ServerUtility.output(Utility.lang.getProperty("disconnect"), true);
                            if (ServerUtility.verbose) {
                                ex.printStackTrace();
                            }
                            this.closing = true;
                            MainServerHandler.handleDisconnect(this.info);
                            break block12;
                        }
                    }
                    catch (NoSuchElementException ex) {
                    }
                }
            }
            if (this.startGame) {
                try {
                    this.out.writeInt(0);
                    this.out.flush();
                }
                catch (IOException ex) {
                    Logger.getLogger(MainServerHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                this.out.writeInt(-10);
                this.out.flush();
                this.out.close();
                this.in.close();
                this.s.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (IOhandlers.contains(this)) {
                    IOhandlers.remove(this);
                }
            }
        }

        private void queueMainUpdate() {
            this.actionQueue.add(new IOAction(){

                @Override
                public boolean performAction(ObjectInputStream in, ObjectOutputStream out) throws IOException {
                    out.writeInt(10);
                    out.flush();
                    return mode.sendServerUpdate(in, out, ServerIOHandler.this.id, ServerIOHandler.this.names.length);
                }
            });
        }

        private void forceUpdate(final ArrayList<String> skins, final ArrayList<Team> teams) throws IOException {
            if (this.closing) {
                return;
            }
            this.actionQueue.add(new IOAction(){

                @Override
                public boolean performAction(ObjectInputStream in, ObjectOutputStream out) throws IOException {
                    out.writeInt(-20);
                    out.writeInt(ServerIOHandler.this.id);
                    out.writeObject(skins);
                    out.writeObject(teams);
                    out.flush();
                    return true;
                }
            });
        }
    }
}

