/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.server;

import com.dmgame.GameLogic;
import com.dmgame.Updatable;
import com.dmgame.entity.Entity;
import com.dmgame.entity.Player;
import com.dmgame.entity.Team;
import com.dmgame.gui.PlayerOptions;
import com.dmgame.map.Map;
import com.dmgame.modes.GameMode;
import com.dmgame.net.server.ClientInfo;
import com.dmgame.net.server.MainServerHandler;
import com.dmgame.net.server.ServerConnectionHandler;
import com.dmgame.net.server.ServerUtility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;

public strictfp class NetplayServer {
    private static InetSocketAddress[] sendAddr;
    private static List<ClientInfo> clInfo;
    private static Player[] players;
    private static DatagramSocket socket;
    private static Thread receiverThread;
    public static boolean running;
    protected static ScheduledThreadPoolExecutor createTimer;
    private static long packetCount;
    public static double gameTime;
    private static Timer countdown;
    private static Timer timeWarning;

    static void start(List<ClientInfo> clientInfo, Map map, GameMode mode) throws SocketException {
        int i;
        int time = (int)(gameTime * 60.0 * 1000.0);
        countdown = new Timer(time, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayServer.endGame();
            }
        });
        timeWarning = new Timer(time - time / 10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetplayServer.sendTimeWarning();
            }
        });
        countdown.start();
        timeWarning.start();
        clInfo = clientInfo;
        running = true;
        players = new Player[4];
        ServerUtility.output("opening connection");
        NetplayServer.setPlayerArray();
        socket = new DatagramSocket(ServerConnectionHandler.port);
        socket.setSendBufferSize(64);
        socket.setReceiveBufferSize(64);
        sendAddr = new InetSocketAddress[clientInfo.size()];
        int prevPlayer = 0;
        PlayerOptions[] po = new PlayerOptions[4];
        for (i = 0; i < clientInfo.size(); ++i) {
            NetplayServer.sendAddr[i] = new InetSocketAddress(clientInfo.get((int)i).ip, 10001 + clientInfo.get((int)i).firstPlayer);
            for (int j = 0; j < clientInfo.get((int)i).numPlayers; ++j) {
                po[j + prevPlayer] = new PlayerOptions(j + prevPlayer, "Human", "0smw", MainServerHandler.teams.get(j + prevPlayer), -1);
            }
            prevPlayer += clientInfo.get((int)i).numPlayers;
        }
        for (i = 0; i < po.length; ++i) {
            if (po[i] != null) continue;
            po[i] = new PlayerOptions(-1, "none", "0smw", Team.RED, -1);
        }
        receiverThread = new Thread((Runnable)new NetworkReceiver(), "Netplay Server Receiver Thread");
        receiverThread.start();
        ServerUtility.output("starting game logic");
        GameLogic.start(map, true, "default", mode, po);
        ServerUtility.output("Game started");
    }

    public static void update() {
        int j;
        DatagramPacket packet;
        byte[] updateData;
        ++packetCount;
        if (!GameLogic.running) {
            return;
        }
        for (Entity e : GameLogic.entities.values()) {
            updateData = e.prepareNetworkUpdate();
            packet = null;
            for (j = 0; j < sendAddr.length; ++j) {
                try {
                    if (sendAddr[j] == null) continue;
                    packet = new DatagramPacket(updateData, 0, updateData.length, sendAddr[j]);
                    socket.send(packet);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        for (Entity e : GameLogic.mapEntities) {
            updateData = e.prepareNetworkUpdate();
            packet = null;
            for (j = 0; j < sendAddr.length; ++j) {
                try {
                    if (sendAddr[j] == null) continue;
                    packet = new DatagramPacket(updateData, 0, updateData.length, sendAddr[j]);
                    socket.send(packet);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        for (int i = 0; i < GameLogic.currentMap.platforms.size(); ++i) {
            byte[] updateData2 = GameLogic.currentMap.platforms.get(i).prepareNetworkUpdate((byte)i);
            for (int j2 = 0; j2 < sendAddr.length; ++j2) {
                try {
                    if (sendAddr[j2] == null) continue;
                    DatagramPacket packet2 = new DatagramPacket(updateData2, 0, updateData2.length, sendAddr[j2]);
                    socket.send(packet2);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static void receiveKeyUpdate(int playerNum, int key, boolean pressed) {
        NetplayServer.getPlayer(playerNum).updateKey(key, pressed);
    }

    private static void endGame() {
        running = false;
        GameLogic.cleanup();
        for (int j = 0; j < sendAddr.length; ++j) {
            try {
                if (sendAddr[j] == null) continue;
                DatagramPacket packet = new DatagramPacket(new byte[]{101}, 0, 1, sendAddr[j]);
                socket.send(packet);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        socket.close();
        try {
            MainServerHandler.returnFromGame(clInfo);
        }
        catch (IOException ex) {
            Logger.getLogger(NetplayServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        NetplayServer.cleanup();
    }

    private static void sendTimeWarning() {
        for (int j = 0; j < sendAddr.length; ++j) {
            try {
                if (sendAddr[j] == null) continue;
                DatagramPacket packet = new DatagramPacket(new byte[]{90}, 0, 1, sendAddr[j]);
                socket.send(packet);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void handleEndGameRequest() {
        if (GameLogic.gameWon) {
            NetplayServer.endGame();
        }
    }

    private static void setPlayerArray() {
        NetplayServer.players[0] = GameLogic.playerOne;
        NetplayServer.players[1] = GameLogic.playerTwo;
        NetplayServer.players[2] = GameLogic.playerThree;
        NetplayServer.players[3] = GameLogic.playerFour;
    }

    public static Player getPlayer(int pSource) {
        switch (pSource) {
            case 0: {
                return GameLogic.playerOne;
            }
            case 1: {
                return GameLogic.playerTwo;
            }
            case 2: {
                return GameLogic.playerThree;
            }
            case 3: {
                return GameLogic.playerFour;
            }
        }
        return null;
    }

    public static void sendItemUpdate(Updatable block, int powerUp, boolean spawn) {
        if (!running) {
            return;
        }
        ArrayList<Updatable> updates = new ArrayList<Updatable>(GameLogic.updatables);
        int target = updates.indexOf(block);
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort((short)target);
        byte[] data = new byte[5];
        byte[] temp = buffer.array();
        data[0] = 70;
        data[1] = temp[0];
        data[2] = temp[1];
        data[3] = (byte)powerUp;
        data[4] = (byte)(spawn ? 0 : 255);
        for (int i = 1; i < sendAddr.length; ++i) {
            if (sendAddr[i] == null) continue;
            try {
                DatagramPacket packet = new DatagramPacket(data, 0, 5, sendAddr[i]);
                socket.send(packet);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void sendCreateUpdate(Entity created) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteStream);
            String object = created.getScriptCreateStatement();
            if (object.equals("null")) {
                return;
            }
            out.writeObject(object);
            byte[] objectData = byteStream.toByteArray();
            byte[] sendData = new byte[objectData.length + 5];
            sendData[0] = 30;
            System.arraycopy(ByteBuffer.allocate(4).putInt(created.entityID).array(), 0, sendData, 1, 4);
            System.arraycopy(objectData, 0, sendData, 5, objectData.length);
            for (int j = 0; j < sendAddr.length; ++j) {
                try {
                    if (sendAddr[j] == null) continue;
                    DatagramPacket packet = new DatagramPacket(sendData, 0, sendData.length, sendAddr[j]);
                    socket.send(packet);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NetplayServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void reportDeath(Entity destroyed) {
        byte[] sendData = new byte[5];
        sendData[0] = 80;
        System.arraycopy(ByteBuffer.allocate(4).putInt(destroyed.entityID).array(), 0, sendData, 1, 4);
        for (int j = 0; j < sendAddr.length; ++j) {
            try {
                if (sendAddr[j] == null) continue;
                DatagramPacket packet = new DatagramPacket(sendData, 0, sendData.length, sendAddr[j]);
                socket.send(packet);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void queueCreateUpdate(final Entity entity) {
        createTimer.schedule(new Runnable(){

            @Override
            public void run() {
                NetplayServer.sendCreateUpdate(entity);
            }
        }, 4L, TimeUnit.MILLISECONDS);
    }

    private static void cleanup() {
        GameLogic.cleanup();
        sendAddr = null;
        clInfo = null;
        players = null;
        socket = null;
        receiverThread = null;
        running = false;
        packetCount = 0L;
    }

    static {
        createTimer = new ScheduledThreadPoolExecutor(32);
        packetCount = 0L;
    }

    private strictfp static class NetworkReceiver
    implements Runnable {
        private NetworkReceiver() {
        }

        @Override
        public void run() {
            while (running && ServerUtility.running) {
                try {
                    DatagramPacket in = new DatagramPacket(new byte[32], 32);
                    socket.receive(in);
                    byte[] data = in.getData();
                    switch (data[0]) {
                        case 40: {
                            System.out.println("update from player# " + data[1]);
                            NetplayServer.receiveKeyUpdate(data[1], data[2], data[3] == 0);
                            break;
                        }
                        case 100: {
                            NetplayServer.handleEndGameRequest();
                        }
                    }
                }
                catch (IOException e) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }
}

