/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.server;

import com.dmgame.Version;
import com.dmgame.entity.Team;
import com.dmgame.net.server.CommandInterpreter;
import com.dmgame.net.server.MainServerHandler;
import com.dmgame.net.server.ServerUtility;
import com.dmgame.net.server.SwingConsole;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ServerConnectionHandler {
    private static boolean DEBUG;
    public static int port;
    static volatile boolean listening;
    public static CommandInterpreter ci;

    public static void main(String[] args) {
        DEBUG = args.length > 0 ? args[0].equalsIgnoreCase("ide") : false;
        listening = true;
        ServerUtility.running = true;
        ServerConnectionHandler.startCommandListener();
        try {
            ServerConnectionHandler.loadOldConfig();
        }
        catch (IOException ex) {
            Logger.getLogger(ServerConnectionHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        ServerSocket listenerSocket = null;
        try {
            listenerSocket = new ServerSocket(port);
            listenerSocket.setReuseAddress(true);
            listenerSocket.setSoTimeout(6000);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        while (listening && ServerUtility.running) {
            try {
                Socket s = listenerSocket.accept();
                ObjectInputStream in = new ObjectInputStream(s.getInputStream());
                ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
                byte major = in.readByte();
                byte minor = in.readByte();
                char build = in.readChar();
                if (!Version.checkCompatibleBuild(major, minor, build)) {
                    out.writeBoolean(false);
                    out.flush();
                    out.close();
                    in.close();
                    s.close();
                    continue;
                }
                out.writeBoolean(true);
                out.flush();
                int players = in.readInt();
                if (MainServerHandler.notEnoughSpace(players)) {
                    System.out.println("not enough space");
                    out.writeBoolean(false);
                    out.flush();
                    out.close();
                    in.close();
                    s.close();
                    continue;
                }
                out.writeBoolean(true);
                out.flush();
                String[] playerSkins = new String[players];
                Team[] playerTeams = new Team[players];
                for (int i = 0; i < players; ++i) {
                    try {
                        playerSkins[i] = (String)in.readObject();
                        boolean hasSkin = ServerConnectionHandler.checkForSkin(playerSkins[i]);
                        out.writeBoolean(hasSkin);
                        out.flush();
                        if (!hasSkin) {
                            MemoryCacheImageInputStream iin = new MemoryCacheImageInputStream(in);
                            BufferedImage im = ImageIO.read(iin);
                            ServerUtility.saveSkin(playerSkins[i], im);
                            while (in.available() > 0) {
                            }
                            out.writeBoolean(true);
                            out.flush();
                        }
                        playerTeams[i] = (Team)((Object)in.readObject());
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        if (ServerUtility.verbose) {
                            ex.printStackTrace();
                        }
                        out.writeInt(-1);
                        out.flush();
                        out.close();
                        in.close();
                        s.close();
                    }
                }
                out.writeBoolean(MainServerHandler.inGame);
                out.flush();
                if (MainServerHandler.inGame) {
                    new Thread((Runnable)new WaitingRoomHandler(out, playerSkins, playerTeams, s), "waiting room").start();
                    continue;
                }
                MainServerHandler.accept(playerSkins, playerTeams, s);
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ex) {
                if (!ServerUtility.verbose) continue;
                ex.printStackTrace();
            }
        }
        try {
            listenerSocket.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ServerConnectionHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static boolean checkForSkin(String name) {
        return new File("res/gfx/skins/" + name + ".png").exists();
    }

    private static void loadOldConfig() throws IOException {
        File f = new File("server_config.txt");
        if (!f.exists()) {
            f.createNewFile();
        }
        Scanner in = new Scanner(new FileReader(f));
        while (in.hasNext()) {
            ci.doCommand(in.nextLine());
        }
        in.close();
    }

    private static void startCommandListener() {
        ci = new CommandInterpreter();
        if (System.console() == null && !DEBUG) {
            new SwingConsole(ci).setVisible(true);
        } else {
            new Thread((Runnable)ci, "Command Interpreter Thread").start();
        }
    }

    static {
        port = 10000;
    }

    private static class WaitingRoomHandler
    implements Runnable {
        ObjectOutputStream out;
        String[] names;
        Team[] teams;
        Socket s;

        WaitingRoomHandler(ObjectOutputStream out, String[] names, Team[] teams, Socket s) {
            this.out = out;
            this.names = names;
            this.teams = teams;
            this.s = s;
        }

        @Override
        public synchronized void run() {
            while (MainServerHandler.inGame) {
                try {
                    this.out.writeBoolean(true);
                    this.out.flush();
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ServerConnectionHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                catch (IOException ex) {
                    return;
                }
            }
            try {
                this.out.writeBoolean(false);
                this.out.flush();
                MainServerHandler.accept(this.names, this.teams, this.s);
            }
            catch (IOException ex) {
                Logger.getLogger(ServerConnectionHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

