/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.server;

import com.dmgame.net.server.ServerConnectionHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ServerUtility {
    public static boolean verbose;
    public static boolean keepSkins;
    public static volatile boolean running;

    public static void output(String s, boolean err) {
        if (verbose) {
            if (!err) {
                System.out.println(s);
            } else {
                System.err.println(s);
            }
        }
    }

    public static void output(String s) {
        ServerUtility.output(s, false);
    }

    static void saveSkin(String string, BufferedImage image) {
        File skinFile = new File("res/gfx/skins/" + string + ".png");
        try {
            ImageIO.write((RenderedImage)image, "png", skinFile);
        }
        catch (IOException ex) {
            Logger.getLogger(ServerUtility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static BufferedImage getSkinImage(String name) {
        try {
            return ImageIO.read(new File("res/gfx/skins/" + name + ".png"));
        }
        catch (IOException ex) {
            Logger.getLogger(ServerUtility.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static void sendSkin(ObjectOutputStream out, String name) throws IOException {
        MemoryCacheImageOutputStream iout = new MemoryCacheImageOutputStream(out);
        ImageIO.write((RenderedImage)ServerUtility.getSkinImage(name), "png", iout);
        out.flush();
    }

    public static void saveConfig() throws IOException {
        FileWriter out = new FileWriter(new File("server_config.txt"));
        ServerConnectionHandler.ci.writeConfig(out);
    }

    static {
        keepSkins = true;
        running = true;
    }
}

