/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.net.server;

import com.dmgame.Scene;
import com.dmgame.net.server.CommandInterpreter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

public class SwingConsole
extends JFrame {
    private static final long serialVersionUID = 6500063038270009015L;
    CommandInterpreter interpreter;
    BufferedImage windowIcon;
    private JTextField commandField;
    private JMenuItem exitMenuItem;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JMenuItem loadConfigMenuItem;
    private JTextArea outputField;
    private JMenuItem saveConfigMenuItem;
    private JMenuItem showConfigMenuItem;

    public SwingConsole(CommandInterpreter interpreter) {
        try {
            this.windowIcon = ImageIO.read(new File("lib/res/smw.png"));
        }
        catch (IOException ex) {
            Logger.getLogger(Scene.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.initComponents();
        this.setIconImage(this.windowIcon);
        this.interpreter = interpreter;
        System.setOut(new RedirectStream(System.out));
        System.setErr(new RedirectStream(System.err));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.outputField = new JTextArea();
        this.commandField = new JTextField();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.loadConfigMenuItem = new JMenuItem();
        this.saveConfigMenuItem = new JMenuItem();
        this.showConfigMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Netplay Server");
        this.outputField.setEditable(false);
        this.outputField.setColumns(20);
        this.outputField.setRows(5);
        this.jScrollPane1.setViewportView(this.outputField);
        this.commandField.setToolTipText("enter command");
        this.commandField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingConsole.this.commandFieldActionPerformed(evt);
            }
        });
        this.jMenu1.setText("File");
        this.loadConfigMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.loadConfigMenuItem.setText("load configuration...");
        this.loadConfigMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingConsole.this.loadConfigMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.loadConfigMenuItem);
        this.saveConfigMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveConfigMenuItem.setText("save configuration");
        this.saveConfigMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingConsole.this.saveConfigMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveConfigMenuItem);
        this.showConfigMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.showConfigMenuItem.setText("show configuration");
        this.showConfigMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingConsole.this.showConfigMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.showConfigMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.exitMenuItem.setText("exit server");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingConsole.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 466, Short.MAX_VALUE).addComponent(this.commandField));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 253, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void commandFieldActionPerformed(ActionEvent evt) {
        this.interpreter.doCommand(this.commandField.getText());
        this.commandField.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(new File(""));
        if (chooser.showOpenDialog(this.jMenu1) == 0) {
            try (Scanner in = null;){
                FileReader reader = new FileReader(chooser.getSelectedFile());
                in = new Scanner(reader);
                while (in.hasNext()) {
                    this.interpreter.doCommand(in.nextLine());
                }
            }
        }
    }

    private void saveConfigMenuItemActionPerformed(ActionEvent evt) {
        this.interpreter.doCommand("/saveconfig");
    }

    private void showConfigMenuItemActionPerformed(ActionEvent evt) {
        this.interpreter.doCommand("/showconfig");
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.interpreter.doCommand("/stop");
    }

    class RedirectStream
    extends PrintStream {
        public RedirectStream(PrintStream toWrap) {
            super(toWrap, true);
        }

        @Override
        public void print(Object o) {
            SwingConsole.this.outputField.setText(SwingConsole.this.outputField.getText() + String.valueOf(o));
        }

        @Override
        public void print(String s) {
            if (s == null) {
                s = "null";
            }
            SwingConsole.this.outputField.setText(SwingConsole.this.outputField.getText() + s);
        }

        @Override
        public void println() {
            SwingConsole.this.outputField.setText(SwingConsole.this.outputField.getText() + "\r\n");
        }

        @Override
        public void println(Object o) {
            SwingConsole.this.outputField.setText(SwingConsole.this.outputField.getText() + String.valueOf(o) + "\r\n");
        }

        @Override
        public void println(String s) {
            if (s == null) {
                s = "null";
            }
            SwingConsole.this.outputField.setText(SwingConsole.this.outputField.getText() + s + "\r\n");
        }
    }
}

