/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.particle;

import com.dmgame.Animation;
import com.dmgame.particle.Particle;
import com.dmgame.particle.ParticleLogic;
import java.awt.image.BufferedImage;

public class AnimatedParticle
extends Particle {
    private Animation animation;
    private final int MAX_NUM_CYCLES;
    private int currentCycle;

    public AnimatedParticle(Animation ani, ParticleLogic par, float xLoc, float yLoc) {
        this(ani, par, xLoc, yLoc, -1);
    }

    public AnimatedParticle(Animation ani, ParticleLogic par, float xLoc, float yLoc, int numCycles) {
        super(par, xLoc, yLoc);
        this.animation = ani;
        this.MAX_NUM_CYCLES = numCycles;
        this.currentCycle = 0;
    }

    @Override
    public BufferedImage getImage() {
        return this.animation.getImage();
    }

    @Override
    public void update(long timePassed) {
        this.animation.update(timePassed);
        if (this.animation.firstCycleCompleted() && this.MAX_NUM_CYCLES > 0) {
            if (this.animation.firstCycleCompleted()) {
                ++this.currentCycle;
                this.animation.reset();
            }
            if (this.currentCycle > this.MAX_NUM_CYCLES) {
                this.removeFromMap();
                return;
            }
        }
        super.update(timePassed);
    }
}

