/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.particle;

import com.dmgame.GameLogic;
import com.dmgame.Updatable;
import com.dmgame.particle.ParticleLogic;
import java.awt.image.BufferedImage;

public class Particle
implements Updatable {
    public float x;
    public float y;
    protected ParticleLogic logic;
    private BufferedImage image;

    public Particle(BufferedImage im, ParticleLogic part, float xLoc, float yLoc) {
        this(part, xLoc, yLoc);
        this.image = im;
    }

    public void addToMap() {
        GameLogic.particles.add(this);
        GameLogic.updatables.add(this);
    }

    public void removeFromMap() {
        GameLogic.particles.remove(this);
        GameLogic.updatables.remove(this);
    }

    public Particle(ParticleLogic part, float xLoc, float yLoc) {
        this.logic = part;
        this.x = xLoc;
        this.y = yLoc;
    }

    public BufferedImage getImage() {
        return this.image != null ? this.image : null;
    }

    @Override
    public void update(long timePassed) {
        int width = this.getImage().getWidth();
        int height = this.getImage().getHeight();
        if (GameLogic.currentMap != null && (this.x < (float)(0 - width) || this.y < (float)(0 - height) || this.x > (float)(GameLogic.currentMap.MAP_WIDTH + width) || this.y > (float)(GameLogic.currentMap.MAP_HEIGHT + height))) {
            this.removeFromMap();
        }
        this.logic.update(timePassed);
        this.x += this.logic.getHSpeed();
        this.y += this.logic.getVSpeed();
    }
}

