/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.sound;

import com.dmgame.net.server.NetplayServer;
import com.dmgame.sound.Sound;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.codecs.CodecJOgg;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public class SoundPlayer {
    private static volatile boolean initialized = false;
    private static SoundSystem player;
    private static String victoryMusic;

    public static synchronized void init() {
        try {
            if (NetplayServer.running) {
                return;
            }
            if (initialized) {
                return;
            }
            SoundSystemConfig.setSoundFilesPackage((String)new File("res/sfx/packs/Classic").toURI().toURL().toString());
            SoundSystemConfig.setCodec((String)"ogg", CodecJOgg.class);
            SoundSystemConfig.setCodec((String)"wav", CodecWav.class);
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            if (player != null) {
                player.cleanup();
            }
            player = new SoundSystem();
            SoundPlayer.loadSounds();
            initialized = true;
        }
        catch (SoundSystemException ex) {
            Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void playSound(Sound sound) {
        if (NetplayServer.running) {
            return;
        }
        if (!initialized) {
            SoundPlayer.init();
        }
        if (player.playing(sound.getName())) {
            try {
                player.quickPlay(false, new File("res/sfx/packs/Classic/" + sound.getName() + ".wav").toURI().toURL(), sound.getName() + ".wav", false, 0.0f, 0.0f, 0.0f, 0, SoundSystemConfig.getDefaultRolloff());
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            player.play(sound.getName());
        }
    }

    public static void stopSound(Sound sound) {
        if (NetplayServer.running) {
            return;
        }
        if (!initialized) {
            SoundPlayer.init();
        }
        player.stop(sound.getName());
    }

    public static void playMusic(File musicFile, boolean loop) {
        if (NetplayServer.running) {
            return;
        }
        if (!initialized) {
            SoundPlayer.init();
        }
        try {
            player.backgroundMusic("bgm", musicFile.toURI().toURL(), "ogg", loop);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void playMusic(File startFile, final File loopFile) {
        if (NetplayServer.running) {
            return;
        }
        if (!initialized) {
            SoundPlayer.init();
        }
        try {
            player.backgroundMusic("start", startFile.toURI().toURL(), "ogg", false);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
        }
        Thread loopStarter = new Thread(new Runnable(){

            @Override
            public void run() {
                while (player.playing("start")) {
                }
                try {
                    player.backgroundMusic("bgm", loopFile.toURI().toURL(), "ogg", true);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }, "loop starter");
        loopStarter.start();
    }

    public static void stopMusic() {
        if (NetplayServer.running) {
            return;
        }
        if (!initialized) {
            SoundPlayer.init();
        }
        if (player.playing("bgm")) {
            player.stop("bgm");
        }
    }

    public static void playTimeWarning() {
        SoundPlayer.stopMusic();
        SoundPlayer.playSound(Sound.TIMELOW);
        new MusicWaiter(Sound.TIMELOW.value).start();
    }

    public static void restartMusic() {
        if (NetplayServer.running) {
            return;
        }
        player.play("bgm");
    }

    public static void close() {
        if (player != null) {
            player.cleanup();
        }
    }

    private static void loadSounds() {
        if (NetplayServer.running) {
            return;
        }
        for (Sound s : Sound.values()) {
            try {
                player.newSource(true, s.getName(), new File("res/sfx/packs/Classic/" + s.getName() + ".wav").toURI().toURL(), s.getName() + ".wav", s.repeat, 0.0f, 0.0f, 0.0f, 0, SoundSystemConfig.getDefaultRolloff());
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void playVictoryMusic(File musicFile) {
        if (NetplayServer.running) {
            return;
        }
        try {
            SoundPlayer.stopMusic();
            victoryMusic = player.quickPlay(true, musicFile.toURI().toURL(), "victory.wav", false, 0.0f, 0.0f, 0.0f, 0, SoundSystemConfig.getDefaultRolloff());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void stopVictoryMusic() {
        player.stop(victoryMusic);
    }

    static class MusicWaiter
    implements Runnable {
        String sourceName;

        public MusicWaiter(String source) {
            this.sourceName = source;
        }

        void start() {
            new Thread(this).start();
        }

        @Override
        public synchronized void run() {
            while (player.playing(this.sourceName)) {
                try {
                    this.wait(16L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            SoundPlayer.restartMusic();
        }
    }
}

