/*
 * Decompiled with CFR 0.152.
 */
package com.dmgame.sql;

import com.dmgame.SMWException;
import com.dmgame.io.MapIO;
import com.dmgame.map.Map;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalDBHandler {
    private Connection dbConnection;

    public LocalDBHandler() {
        try {
            boolean createDB = !new File("SMWSADB").isDirectory();
            this.dbConnection = DriverManager.getConnection("jdbc:derby:SMWSADB;create=true", "root", "");
            if (createDB) {
                this.createTables();
            }
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
            Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("create Database failed");
        }
    }

    private void restartDatabase() throws SQLException {
        Statement s = this.dbConnection.createStatement();
        s.addBatch("DROP TABLE MAP_TAGS;");
        s.addBatch("DROP TABLE MAP_AUTHORS;");
        s.addBatch("DROP TABLE MAPS;");
        s.addBatch("DROP TABLE TAGS;");
        s.addBatch("DROP TABLE AUTHOR;");
        s.executeBatch();
        s.close();
        this.createTables();
    }

    private void createTables() throws SQLException {
        Statement s = this.dbConnection.createStatement();
        s.execute("CREATE TABLE MAPS(\n\tMapID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n\tMapName CHAR(64) NOT NULL UNIQUE,\n\tMapBGCategory CHAR(32),\n\tCONSTRAINT Map_PK PRIMARY KEY(MapID))");
        s.execute("CREATE TABLE TAGS(\n\tTagID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n\tTagText CHAR(32) NOT NULL UNIQUE,\n\tCONSTRAINT Tag_PK PRIMARY KEY(TagID))");
        s.execute("CREATE TABLE AUTHOR(\n\tAuthorID INT NOT NULL GENERATED ALWAYS AS IDENTITY,\n\tAuthorName CHAR(40) NOT NULL UNIQUE,\n\tCONSTRAINT Author_PK PRIMARY KEY(AuthorID))");
        s.execute("CREATE TABLE MAP_TAGS(\n\tTagID INT NOT NULL,\n\tMapID INT NOT NULL,\n\tCONSTRAINT Map_Tag_PK PRIMARY KEY(TagID,MapID),\n\tFOREIGN KEY(MapID) REFERENCES MAPS(MapID),\n\tFOREIGN KEY(TagID) REFERENCES TAGS(TagID))");
        s.execute("CREATE TABLE MAP_AUTHORS(\n\tAuthorID INT NOT NULL,\n\tMapID INT NOT NULL,\n\tCONSTRAINT Map_Author_PK PRIMARY KEY(AuthorID,MapID),\n\tFOREIGN KEY(MapID) REFERENCES MAPS(MapID),\n\tFOREIGN KEY(AuthorID) REFERENCES AUTHOR(AuthorID))");
        s.close();
    }

    public void populateTables() {
        File mapDir = new File("res/maps/");
        for (File mapFile : mapDir.listFiles()) {
            if (mapFile.isDirectory()) continue;
            try {
                HashSet<String> tags;
                Map map = MapIO.loadMap(mapFile, false);
                Statement statement = this.dbConnection.createStatement();
                ResultSet rs = statement.executeQuery("SELECT MapName FROM MAPS WHERE MapName='" + this.getSQLString(map.mapName) + "'");
                if (rs.next()) continue;
                System.out.println("adding " + map.mapName + " to database...");
                statement.execute("INSERT INTO MAPS (MapName) VALUES ('" + this.getSQLString(map.mapName) + "')");
                rs = statement.executeQuery("SELECT AuthorName FROM AUTHOR WHERE AuthorName='" + this.getSQLString(map.creatorName) + "'");
                if (!rs.next()) {
                    statement.execute("INSERT INTO AUTHOR(AuthorName) VALUES ('" + this.getSQLString(map.creatorName) + "')");
                }
                if ((tags = map.metadata) == null) {
                    tags = map.createMetadata();
                }
                for (String tag : tags) {
                    try {
                        rs = statement.executeQuery("SELECT * FROM TAGS WHERE TagText='" + this.getSQLString(tag) + "'");
                        if (rs.next()) continue;
                        statement.execute("INSERT INTO TAGS(TagText) VALUES ('" + this.getSQLString(tag) + "')");
                    }
                    catch (SQLException e) {
                        System.err.println(e.getMessage());
                        e.printStackTrace();
                    }
                }
                rs = statement.executeQuery("SELECT MapID FROM MAPS WHERE MapName='" + this.getSQLString(map.mapName) + "'");
                rs.next();
                int mapID = rs.getInt("MapID");
                rs = statement.executeQuery("SELECT AuthorID FROM AUTHOR WHERE AuthorName='" + this.getSQLString(map.creatorName) + "'");
                rs.next();
                int authorID = rs.getInt("AuthorID");
                statement.execute("INSERT INTO MAP_AUTHORS VALUES(" + authorID + "," + mapID + ")");
                for (String tag : tags) {
                    rs = statement.executeQuery("SELECT TagID FROM TAGS WHERE TagText='" + this.getSQLString(tag) + "'");
                    rs.next();
                    int tagID = rs.getInt("TagID");
                    statement.execute("INSERT INTO MAP_TAGS VALUES(" + tagID + "," + mapID + ")");
                }
                statement.close();
            }
            catch (IOException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (SQLException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            catch (SMWException e) {
                // empty catch block
            }
        }
    }

    private String getSQLString(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(str.charAt(i));
            if (str.charAt(i) != '\'') continue;
            sb.append('\'');
        }
        return sb.toString();
    }

    public String[] getMapsFromTags(String[] tags) {
        HashSet<String> maps = new HashSet<String>();
        for (String s : tags) {
            s = this.getSQLString(s);
            try {
                Statement statement = this.dbConnection.createStatement();
                ResultSet rs = statement.executeQuery("SELECT MAPS.MapName\nFROM TAGS,MAPS,MAP_TAGS\nWHERE TAGS.TagID = MAP_TAGS.TagID AND MAPS.MapID = MAP_TAGS.MapID AND TAGS.TagText='" + s + "'");
                while (rs.next()) {
                    maps.add(rs.getString("MapName").trim());
                    System.out.println(rs.getString("MapName"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return maps.toArray(tags);
    }

    public String[] getMapsFromAuthors(String[] authors) {
        HashSet<String> maps = new HashSet<String>();
        for (String s : authors) {
            s = this.getSQLString(s);
            try {
                Statement statement = this.dbConnection.createStatement();
                ResultSet rs = statement.executeQuery("SELECT MAPS.MapName\nFROM AUTHOR,MAPS,MAP_AUTHORS\nWHERE AUTHOR.AuthorID = MAP_AUTHORS.AuthorID AND MAPS.MapID = MAP_AUTHORS.MapID AND AUTHOR.AuthorName='" + s + "'");
                while (rs.next()) {
                    maps.add(rs.getString("MapName").trim());
                    System.out.println(rs.getString("MapName"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return maps.toArray(authors);
    }

    public void showTagToMapAssociations() {
        try {
            Statement statement = this.dbConnection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT TAGS.TagText,MAPS.MapName\nFROM TAGS,MAPS,MAP_TAGS\nWHERE TAGS.TagID = MAP_TAGS.TagID AND MAPS.MapID = MAP_TAGS.MapID\nORDER BY TAGS.TagText");
            while (rs.next()) {
                System.out.println("Tag: " + rs.getString("TagText") + " Map: " + rs.getString("MapName"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showAllMaps() {
        try {
            Statement statement = this.dbConnection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT * FROM MAPS");
            while (rs.next()) {
                System.out.println("MapID: " + rs.getString("MapID") + " MapName: " + rs.getString("MapName"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showAllTags() {
        try {
            Statement statement = this.dbConnection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT * FROM TAGS");
            while (rs.next()) {
                System.out.println("TagID: " + rs.getString("TagID") + " TagText: " + rs.getString("TagText"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showAllAuthors() {
        try {
            Statement statement = this.dbConnection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT * FROM AUTHOR");
            while (rs.next()) {
                System.out.println("AuthorID: " + rs.getString("AuthorID") + " AuthorName: " + rs.getString("AuthorName"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(LocalDBHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

