--This will be what the statements in LocalDBHandler will use to create the tables.

--clear old data

DROP TABLE MAP_TAGS;
DROP TABLE MAP_AUTHORS;
DROP TABLE MAPS;
DROP TABLE TAGS;
DROP TABLE AUTHOR;

--create Main Tables

CREATE TABLE MAPS(
	MapID INT NOT NULL GENERATED ALWAYS AS IDENTITY,
	MapName CHAR(64) NOT NULL UNIQUE,
	CONSTRAINT Map_PK PRIMARY KEY(MapID));

CREATE TABLE TAGS(
	TagID INT NOT NULL GENERATED ALWAYS AS IDENTITY,
	TagText CHAR(32) NOT NULL UNIQUE,
	CONSTRAINT Tag_PK PRIMARY KEY(TagID));

CREATE TABLE AUTHOR(
	AuthorID INT NOT NULL GENERATED ALWAYS AS IDENTITY,
	AuthorName CHAR(40) NOT NULL UNIQUE,
	CONSTRAINT Author_PK PRIMARY KEY(AuthorID));

--create Linking Tables

CREATE TABLE MAP_TAGS(
	TagID INT NOT NULL,
	MapID INT NOT NULL,
	CONSTRAINT Map_Tag_PK PRIMARY KEY(TagID,MapID),
	FOREIGN KEY(MapID) REFERENCES MAPS(MapID),
	FOREIGN KEY(TagID) REFERENCES TAGS(TagID));

CREATE TABLE MAP_AUTHORS(
	AuthorID INT NOT NULL,
	MapID INT NOT NULL,
	CONSTRAINT Map_Author_PK PRIMARY KEY(AuthorID,MapID),
	FOREIGN KEY(MapID) REFERENCES MAPS(MapID),
	FOREIGN KEY(AuthorID) REFERENCES AUTHOR(AuthorID));