package com.dmgame.net.script;

import com.dmgame.net.communication.*;
import com.dmgame.net.server.*;
import com.dmgame.net.script.*;
import com.dmgame.modes.*;

return new GameMode();

class GameMode extends ServerCommand{

	String getName(){return "gamemode"}

	public boolean perform(Scanner splitter){
		if(!splitter.hasNext()){
			println(" - additional arguments required\r\n"
			+ "type \"/gamemode help\" for more details")
			return false
		}
		String firstFlag = splitter.next().toLowerCase();
		int points = 10 //universal default
		if("classic".contains(firstFlag)){
			if(splitter.hasNext())
				try{
					points = Integer.parseInt(splitter.next())
				}
				catch(NumberFormatException e){
					println("The amount of points must be an integer above 0")
					return false
				}
			CommunicationMode.mode = new ClassicMode(points)
			System.out.println("Game mode set to classic - points: "+points)
			return true
		}
		else if("help".contains(firstFlag)){
			System.out.println("- Sets the gamemode. Usage:\r\n"
			+ "- /gamemode <type> <initial/required points> [additional flags...]\r\n"
			+ "-\r\n"
			+ "- Available gamemodes:\r\n"
			+ "- Classic: Last alive wins. [no additional flags]")
			return false
		}
	}
}