package com.dmgame.net.script;

import com.dmgame.net.server.*;
import com.dmgame.net.script.*;
import com.dmgame.net.communication.*;

return new Simple();

class Simple extends ServerCommand{

	String getName(){return "simple"};

	public boolean perform(Scanner splitter){
		int players = 4
		if(splitter.hasNext()){
			String modifier = splitter.next()
			try{
				players = Integer.parseInt(modifier)
			}
			catch(NumberFormatException ex){
				System.out.println("- simple modifier must be an integer")
				return false
			}
		}
		CommunicationMode newMode = new SimpleCommunicationMode(players)
		if(MainServerHandler.setMode(newMode)){
			println("Cannot change mode. Communication with clients has started.")
			return false
		}
		else{
			println("Set mode to: simple")
			println("number of players: "+players)
			return true
		}
	}
}
