/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGObject;
import jgame.JGPoint;

public class StdDungeonMonster
extends JGObject {
    public String gfx_prefix = null;
    public boolean continuous_anim = true;
    public int block_mask = 0;
    public int occupy_mask;
    public JGObject home_in = null;
    public boolean avoid = false;
    public double random_proportion;
    JGPoint occupied = null;

    public StdDungeonMonster(String string, boolean bl, double d, double d2, int n, String string2, boolean bl2, boolean bl3, int n2, int n3, double d3, JGObject jGObject, boolean bl4, double d4) {
        super(string, bl, d, d2, n, string2);
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        this.setDirSpeed(0, 0, d3);
        if (bl2) {
            this.gfx_prefix = string2;
        }
        this.continuous_anim = bl3;
        this.block_mask = n2;
        this.occupy_mask = n3;
        this.home_in = jGObject;
        this.avoid = bl4;
        this.random_proportion = d4;
    }

    public StdDungeonMonster(String string, boolean bl, double d, double d2, int n, String string2, int n2) {
        super(string, bl, d, d2, n, string2);
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        this.setDirSpeed(0, 0, 0.0);
        this.occupy_mask = n2;
    }

    public void move() {
        if (this.occupied == null || this.xspeed == 0.0 && this.yspeed == 0.0 || this.xdir == 0 && this.ydir == 0 && (!this.isXAligned() || !this.isYAligned())) {
            if (this.occupied != null) {
                this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
            }
            this.snapToGrid(this.eng.tileWidth(), this.eng.tileHeight());
            this.occupied = this.getCenterTile();
            this.eng.orTileCid(this.occupied.x, this.occupied.y, this.occupy_mask);
        } else if (!this.isXAligned() || !this.isYAligned()) {
            if (!this.continuous_anim) {
                this.startAnim();
            }
        } else {
            int n = this.xdir;
            int n2 = this.ydir;
            this.snapToGrid();
            JGPoint jGPoint = this.getCenterTile();
            this.setDir(0, 0);
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = false;
            if (this.home_in != null && this.eng.random(1.0E-4, 0.9999) > this.random_proportion) {
                int n5;
                int n6 = n5 = this.avoid ? -1 : 1;
                if (this.home_in.x < this.x) {
                    n3 = -n5;
                }
                if (this.home_in.x > this.x) {
                    n3 = n5;
                }
                if (this.home_in.y < this.y) {
                    n4 = -n5;
                }
                if (this.home_in.y > this.y) {
                    n4 = n5;
                }
                if (Math.abs(this.home_in.x - this.x) > Math.abs(this.home_in.y - this.y)) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            } else {
                n3 = this.eng.random(-1, 1, 1);
                n4 = this.eng.random(-1, 1, 1);
                bl = true;
                bl2 = true;
            }
            this.xdir = n3;
            this.ydir = n4;
            StdDungeonMonster.checkIfBlocked(this, this.block_mask, n, n2);
            if (this.xdir == 0 && this.ydir == 0) {
                if (bl) {
                    this.xdir = n3 != 0 ? -n3 : this.eng.random(-1, 1, 2);
                    this.ydir = n4;
                    StdDungeonMonster.checkIfBlocked(this, this.block_mask, n, n2);
                } else if (bl2) {
                    this.xdir = n3;
                    this.ydir = n4 != 0 ? -n4 : this.eng.random(-1, 1, 2);
                    StdDungeonMonster.checkIfBlocked(this, this.block_mask, n, n2);
                }
            }
            if (this.occupied != null) {
                this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
            }
            this.occupied = new JGPoint(jGPoint.x + this.xdir, jGPoint.y + this.ydir);
            this.eng.orTileCid(this.occupied.x, this.occupied.y, this.occupy_mask);
            if (!this.continuous_anim) {
                if (this.xdir != 0 || this.ydir != 0) {
                    this.startAnim();
                } else {
                    this.stopAnim();
                }
            }
            if (this.gfx_prefix != null) {
                if (this.ydir < 0 && this.xdir < 0) {
                    this.setGraphic(this.gfx_prefix + "ul");
                }
                if (this.ydir < 0 && this.xdir == 0) {
                    this.setGraphic(this.gfx_prefix + "u");
                }
                if (this.ydir < 0 && this.xdir > 0) {
                    this.setGraphic(this.gfx_prefix + "ur");
                }
                if (this.ydir == 0 && this.xdir < 0) {
                    this.setGraphic(this.gfx_prefix + "l");
                }
                if (this.ydir == 0 && this.xdir > 0) {
                    this.setGraphic(this.gfx_prefix + "r");
                }
                if (this.ydir > 0 && this.xdir < 0) {
                    this.setGraphic(this.gfx_prefix + "dl");
                }
                if (this.ydir > 0 && this.xdir == 0) {
                    this.setGraphic(this.gfx_prefix + "d");
                }
                if (this.ydir > 0 && this.xdir > 0) {
                    this.setGraphic(this.gfx_prefix + "dr");
                }
            }
        }
    }

    public void destroy() {
        if (this.occupied != null) {
            this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
        }
    }

    public static void checkIfBlocked(JGObject jGObject, int n, int n2, int n3) {
        boolean bl;
        JGPoint jGPoint = jGObject.getCenterTile();
        boolean bl2 = !StdDungeonMonster.and(jGObject.eng.getTileCid(jGPoint, jGObject.xdir, 0), n);
        boolean bl3 = bl = !StdDungeonMonster.and(jGObject.eng.getTileCid(jGPoint, 0, jGObject.ydir), n);
        if (jGObject.xdir != 0 && jGObject.ydir != 0 && StdDungeonMonster.and(jGObject.eng.getTileCid(jGPoint, jGObject.xdir, jGObject.ydir), n)) {
            if (bl2 && bl) {
                if (n2 != 0) {
                    jGObject.xdir = 0;
                } else if (n3 != 0) {
                    jGObject.ydir = 0;
                } else {
                    jGObject.xdir = 0;
                }
            } else if (bl2) {
                jGObject.ydir = 0;
            } else if (bl) {
                jGObject.xdir = 0;
            } else {
                jGObject.xdir = 0;
                jGObject.ydir = 0;
            }
        }
        if (jGObject.xdir != 0 && !bl2) {
            jGObject.xdir = 0;
        }
        if (jGObject.ydir != 0 && !bl) {
            jGObject.ydir = 0;
        }
    }
}

