/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGObject;
import jgame.JGPoint;

public class StdMazeMonster
extends JGObject {
    public String gfx_prefix = null;
    public int block_mask;
    public double speed;
    public JGObject home_in;
    public boolean avoid;
    public double random_proportion;
    int newxdir;
    int newydir;
    JGPoint cen;

    public StdMazeMonster(String string, boolean bl, double d, double d2, int n, String string2, boolean bl2, int n2, int n3, int n4, double d3, JGObject jGObject, boolean bl3, double d4) {
        super(string, bl, d, d2, n, null);
        this.setDirSpeed(n3, n4, d3);
        this.snapToGrid(this.eng.tileWidth(), this.eng.tileHeight());
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        if (bl2) {
            this.gfx_prefix = string2;
        }
        this.block_mask = n2;
        this.speed = d3;
        this.home_in = jGObject;
        this.avoid = bl3;
        this.random_proportion = d4;
    }

    public void move() {
        this.cen = this.getCenterTile();
        double d = this.eng.getGameSpeed();
        if (this.isXAligned(this.xspeed * d / 1.1) && this.isYAligned(this.yspeed * d / 1.1)) {
            this.snapToGrid(this.xspeed * d / 1.1, this.yspeed * d / 1.1);
            if (this.home_in == null || this.eng.random(0.0, 0.9999) < this.random_proportion) {
                this.chooseRandomDir();
            } else {
                int n;
                int n2 = n = this.avoid ? -1 : 1;
                if (!this.avoid) {
                    if (Math.abs(this.x - this.home_in.x) > Math.abs(this.y - this.home_in.y)) {
                        this.newxdir = this.x > this.home_in.x ? -n : n;
                        this.newydir = 0;
                    } else {
                        this.newxdir = 0;
                        this.newydir = this.y > this.home_in.y ? -n : n;
                    }
                } else if (Math.abs(this.x - this.home_in.x) < Math.abs(this.y - this.home_in.y)) {
                    this.newxdir = this.x > this.home_in.x ? -n : n;
                    this.newydir = 0;
                } else {
                    this.newxdir = 0;
                    if (Math.abs(this.y - this.home_in.y) < 1.0) {
                        this.newydir = this.eng.random(-1, 1, 2);
                    } else {
                        int n3 = this.newydir = this.y > this.home_in.y ? -n : n;
                    }
                }
                if (StdMazeMonster.and(this.eng.getTileCid(this.cen, this.newxdir, this.newydir), this.block_mask) || this.newxdir == -this.xdir && this.newydir == -this.ydir) {
                    if (this.newxdir != 0) {
                        this.newxdir = 0;
                        this.newydir = this.y > this.home_in.y ? -n : n;
                    } else {
                        this.newxdir = this.x > this.home_in.x ? -n : n;
                        this.newydir = 0;
                    }
                }
            }
            if (this.newxdir == -this.xdir && this.newydir == -this.ydir) {
                this.newxdir = this.xdir;
                this.newydir = this.ydir;
            }
            if (StdMazeMonster.and(this.eng.getTileCid(this.cen, this.newxdir, this.newydir), this.block_mask)) {
                this.chooseRandomDir();
            }
            this.setDir(this.newxdir, this.newydir);
        }
        if (this.gfx_prefix != null) {
            if (this.xdir == 1) {
                this.setGraphic(this.gfx_prefix + "r");
            } else if (this.xdir == -1) {
                this.setGraphic(this.gfx_prefix + "l");
            } else if (this.ydir == 1) {
                this.setGraphic(this.gfx_prefix + "d");
            } else if (this.ydir == -1) {
                this.setGraphic(this.gfx_prefix + "u");
            }
        }
    }

    private void chooseRandomDir() {
        this.newxdir = -this.xdir;
        this.newydir = -this.ydir;
        int n = this.eng.random(-1, 1, 2);
        for (int i = 0; i < 4; ++i) {
            int n2 = n * this.newydir;
            this.newydir = -n * this.newxdir;
            this.newxdir = n2;
            if (StdMazeMonster.and(this.eng.getTileCid(this.cen, this.newxdir, this.newydir), this.block_mask)) continue;
            return;
        }
        this.newxdir = 0;
        this.newydir = 0;
    }
}

