/*
 * Decompiled with CFR 0.152.
 */
package gamegen;

import examples.StdScoring;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.platform.AppConfig;
import jgame.platform.StdGame;

public class SimpleGeneratedGame
extends StdGame {
    static final int PLAYERTYPE = 32;
    static final int BULLETTYPE = 16;
    AppConfig gamecfg;
    JGFont scoring_font = new JGFont("Arial", 0, 16.0);
    public String gp_gamename = "MyGame";
    Player player = null;
    public String gp_basebg = "empty";
    public double gp_basebgmazeysize = 1.0;
    public double gp_basebgmazexsize = 5.0;
    public int gp_basebgtype = 0;
    public String gp_basebgtile = "w";
    public String gp_basebgfill = "k";
    public boolean gp_randombg1 = false;
    public double gp_randombg1density = 0.0;
    public int gp_randombg1type = 0;
    public String gp_randombg1tile = "w";
    public boolean gp_randombg2 = false;
    public double gp_randombg2density = 0.0;
    public int gp_randombg2type = 0;
    public String gp_randombg2tile = "w";
    public boolean gp_randombg3 = false;
    public double gp_randombg3density = 0.0;
    public int gp_randombg3type = 0;
    public String gp_randombg3tile = "w";
    public String gp_playersprite = "white16";
    public double gp_playerx = 312.0;
    public double gp_playery = 232.0;
    public String gp_playerxmove = "linear";
    public double gp_playerxspeed = 8.0;
    public double gp_playerxaccel = 1.0;
    public String gp_playerymove = "linear";
    public double gp_playeryspeed = 8.0;
    public double gp_playeryaccel = 1.0;
    public int gp_playerbumpbgtype = 0;
    public int gp_playerdiebgtype = 0;
    public int gp_playerdieobjtype = 0;
    public int gp_playergetobjtype = 0;
    public double gp_playergetscore = 10.0;
    public String gp_playershoot = "off";
    public String gp_playershootdir = "left";
    public String gp_playershootaxis = "horizontal";
    public double gp_playerbulletspeed = 10.0;
    public double gp_playermaxbullets = 1.0;
    public int gp_playerbulletdiebgtype = 0;
    public boolean gp_endleveltimeout = false;
    public double gp_endleveltimeoutlen = 50.0;
    public boolean gp_endlevelobjcount = false;
    public int gp_endlevelobjtype = 0;
    public double gp_endlevelscore = 100.0;
    AgentMotion[] xmots = new AgentMotion[5];
    AgentMotion[] ymots = new AgentMotion[5];
    public boolean gp_agent1 = false;
    public int gp_agent1type = 0;
    public String gp_agent1sprite = "white16";
    public String gp_agent1createloc = "random";
    public double gp_agent1createinit = 1.0;
    public double gp_agent1createinterval = 0.0;
    public double gp_agent1createbegin = 0.0;
    public double gp_agent1createend = 999999.0;
    public double gp_agent1xspeed = 5.0;
    public String gp_agent1movexinit = "center";
    public boolean gp_agent1movexrandom = false;
    public double gp_agent1movexrandomchg = 1.0;
    public boolean gp_agent1movextoplayer = false;
    public double gp_agent1movextoplayermin = 0.0;
    public double gp_agent1movextoplayermax = 200.0;
    public boolean gp_agent1movexfrplayer = false;
    public double gp_agent1movexfrplayermin = 0.0;
    public double gp_agent1movexfrplayermax = 200.0;
    public double gp_agent1yspeed = 5.0;
    public String gp_agent1moveyinit = "center";
    public boolean gp_agent1moveyrandom = false;
    public double gp_agent1moveyrandomchg = 1.0;
    public boolean gp_agent1moveytoplayer = false;
    public double gp_agent1moveytoplayermin = 0.0;
    public double gp_agent1moveytoplayermax = 200.0;
    public boolean gp_agent1moveyfrplayer = false;
    public double gp_agent1moveyfrplayermin = 0.0;
    public double gp_agent1moveyfrplayermax = 200.0;
    public boolean gp_agent1shoot = false;
    public double gp_agent1shootfreq = 5.0;
    public String gp_agent1shootdir = "player";
    public double gp_agent1shootspeed = 10.0;
    public int gp_agent1bullettype = 0;
    public String gp_agent1bouncesides = "none";
    public int gp_agent1dieobjtype = 0;
    public int gp_agent1blockbgtype = 0;
    public int gp_agent1diebgtype = 0;
    public String gp_agent1dieaction = "not";
    public double gp_agent1diescore = 5.0;
    public boolean gp_agent2 = false;
    public int gp_agent2type = 0;
    public String gp_agent2sprite = "white16";
    public String gp_agent2createloc = "random";
    public double gp_agent2createinit = 1.0;
    public double gp_agent2createinterval = 0.0;
    public double gp_agent2createbegin = 0.0;
    public double gp_agent2createend = 999999.0;
    public double gp_agent2xspeed = 5.0;
    public String gp_agent2movexinit = "center";
    public boolean gp_agent2movexrandom = false;
    public double gp_agent2movexrandomchg = 1.0;
    public boolean gp_agent2movextoplayer = false;
    public double gp_agent2movextoplayermin = 0.0;
    public double gp_agent2movextoplayermax = 200.0;
    public boolean gp_agent2movexfrplayer = false;
    public double gp_agent2movexfrplayermin = 0.0;
    public double gp_agent2movexfrplayermax = 200.0;
    public double gp_agent2yspeed = 5.0;
    public String gp_agent2moveyinit = "center";
    public boolean gp_agent2moveyrandom = false;
    public double gp_agent2moveyrandomchg = 1.0;
    public boolean gp_agent2moveytoplayer = false;
    public double gp_agent2moveytoplayermin = 0.0;
    public double gp_agent2moveytoplayermax = 200.0;
    public boolean gp_agent2moveyfrplayer = false;
    public double gp_agent2moveyfrplayermin = 0.0;
    public double gp_agent2moveyfrplayermax = 200.0;
    public boolean gp_agent2shoot = false;
    public double gp_agent2shootfreq = 5.0;
    public String gp_agent2shootdir = "player";
    public double gp_agent2shootspeed = 10.0;
    public int gp_agent2bullettype = 0;
    public String gp_agent2bouncesides = "none";
    public int gp_agent2dieobjtype = 0;
    public int gp_agent2blockbgtype = 0;
    public int gp_agent2diebgtype = 0;
    public String gp_agent2dieaction = "not";
    public double gp_agent2diescore = 5.0;
    public boolean gp_agent3 = false;
    public int gp_agent3type = 0;
    public String gp_agent3sprite = "white16";
    public String gp_agent3createloc = "random";
    public double gp_agent3createinit = 1.0;
    public double gp_agent3createinterval = 0.0;
    public double gp_agent3createbegin = 0.0;
    public double gp_agent3createend = 999999.0;
    public double gp_agent3xspeed = 5.0;
    public String gp_agent3movexinit = "center";
    public boolean gp_agent3movexrandom = false;
    public double gp_agent3movexrandomchg = 1.0;
    public boolean gp_agent3movextoplayer = false;
    public double gp_agent3movextoplayermin = 0.0;
    public double gp_agent3movextoplayermax = 200.0;
    public boolean gp_agent3movexfrplayer = false;
    public double gp_agent3movexfrplayermin = 0.0;
    public double gp_agent3movexfrplayermax = 200.0;
    public double gp_agent3yspeed = 5.0;
    public String gp_agent3moveyinit = "center";
    public boolean gp_agent3moveyrandom = false;
    public double gp_agent3moveyrandomchg = 1.0;
    public boolean gp_agent3moveytoplayer = false;
    public double gp_agent3moveytoplayermin = 0.0;
    public double gp_agent3moveytoplayermax = 200.0;
    public boolean gp_agent3moveyfrplayer = false;
    public double gp_agent3moveyfrplayermin = 0.0;
    public double gp_agent3moveyfrplayermax = 200.0;
    public boolean gp_agent3shoot = false;
    public double gp_agent3shootfreq = 5.0;
    public String gp_agent3shootdir = "player";
    public double gp_agent3shootspeed = 10.0;
    public int gp_agent3bullettype = 0;
    public String gp_agent3bouncesides = "none";
    public int gp_agent3dieobjtype = 0;
    public int gp_agent3blockbgtype = 1;
    public int gp_agent3diebgtype = 1;
    public String gp_agent3dieaction = "not";
    public double gp_agent3diescore = 5.0;
    public boolean gp_agent4 = false;
    public int gp_agent4type = 0;
    public String gp_agent4sprite = "white16";
    public String gp_agent4createloc = "random";
    public double gp_agent4createinit = 1.0;
    public double gp_agent4createinterval = 0.0;
    public double gp_agent4createbegin = 0.0;
    public double gp_agent4createend = 999999.0;
    public double gp_agent4xspeed = 5.0;
    public String gp_agent4movexinit = "center";
    public boolean gp_agent4movexrandom = false;
    public double gp_agent4movexrandomchg = 1.0;
    public boolean gp_agent4movextoplayer = false;
    public double gp_agent4movextoplayermin = 0.0;
    public double gp_agent4movextoplayermax = 200.0;
    public boolean gp_agent4movexfrplayer = false;
    public double gp_agent4movexfrplayermin = 0.0;
    public double gp_agent4movexfrplayermax = 200.0;
    public double gp_agent4yspeed = 5.0;
    public String gp_agent4moveyinit = "center";
    public boolean gp_agent4moveyrandom = false;
    public double gp_agent4moveyrandomchg = 1.0;
    public boolean gp_agent4moveytoplayer = false;
    public double gp_agent4moveytoplayermin = 0.0;
    public double gp_agent4moveytoplayermax = 200.0;
    public boolean gp_agent4moveyfrplayer = false;
    public double gp_agent4moveyfrplayermin = 0.0;
    public double gp_agent4moveyfrplayermax = 200.0;
    public boolean gp_agent4shoot = false;
    public double gp_agent4shootfreq = 5.0;
    public String gp_agent4shootdir = "player";
    public double gp_agent4shootspeed = 10.0;
    public int gp_agent4bullettype = 0;
    public String gp_agent4bouncesides = "none";
    public int gp_agent4dieobjtype = 0;
    public int gp_agent4blockbgtype = 0;
    public int gp_agent4diebgtype = 0;
    public String gp_agent4dieaction = "not";
    public double gp_agent4diescore = 5.0;
    public boolean gp_agent5 = false;
    public int gp_agent5type = 0;
    public String gp_agent5sprite = "white16";
    public String gp_agent5createloc = "random";
    public double gp_agent5createinit = 1.0;
    public double gp_agent5createinterval = 0.0;
    public double gp_agent5createbegin = 0.0;
    public double gp_agent5createend = 999999.0;
    public double gp_agent5xspeed = 5.0;
    public String gp_agent5movexinit = "center";
    public boolean gp_agent5movexrandom = false;
    public double gp_agent5movexrandomchg = 1.0;
    public boolean gp_agent5movextoplayer = false;
    public double gp_agent5movextoplayermin = 0.0;
    public double gp_agent5movextoplayermax = 200.0;
    public boolean gp_agent5movexfrplayer = false;
    public double gp_agent5movexfrplayermin = 0.0;
    public double gp_agent5movexfrplayermax = 200.0;
    public double gp_agent5yspeed = 5.0;
    public String gp_agent5moveyinit = "center";
    public boolean gp_agent5moveyrandom = false;
    public double gp_agent5moveyrandomchg = 1.0;
    public boolean gp_agent5moveytoplayer = false;
    public double gp_agent5moveytoplayermin = 0.0;
    public double gp_agent5moveytoplayermax = 200.0;
    public boolean gp_agent5moveyfrplayer = false;
    public double gp_agent5moveyfrplayermin = 0.0;
    public double gp_agent5moveyfrplayermax = 200.0;
    public boolean gp_agent5shoot = false;
    public double gp_agent5shootfreq = 5.0;
    public String gp_agent5shootdir = "player";
    public double gp_agent5shootspeed = 10.0;
    public int gp_agent5bullettype = 0;
    public String gp_agent5bouncesides = "none";
    public int gp_agent5dieobjtype = 0;
    public int gp_agent5blockbgtype = 0;
    public int gp_agent5diebgtype = 0;
    public String gp_agent5dieaction = "not";
    public double gp_agent5diescore = 5.0;

    public static void main(String[] stringArray) {
        new SimpleGeneratedGame(SimpleGeneratedGame.parseSizeArgs(stringArray, 0));
    }

    public SimpleGeneratedGame() {
        this.initEngineApplet();
    }

    public SimpleGeneratedGame(JGPoint jGPoint) {
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(40, 30, 16, 16, null, null, null);
    }

    public void initGame() {
        String string = null;
        if (this.isApplet()) {
            string = this.getParameter("configfile");
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
            jFileChooser.setDialogTitle("Choose a config file");
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                string = jFileChooser.getSelectedFile().getAbsolutePath();
            } else {
                System.exit(0);
            }
        }
        this.gamecfg = new AppConfig("Game parameters", this, string);
        this.gamecfg.loadFromFile();
        this.gamecfg.defineFields("gp_", "", "", "");
        this.gamecfg.saveToObject();
        this.initMotionPars();
        this.gamecfg.setListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleGeneratedGame.this.start();
                SimpleGeneratedGame.this.requestGameFocus();
                SimpleGeneratedGame.this.initMotionPars();
            }
        });
        this.defineMedia("simplegeneratedgame.tbl");
        this.setFrameRate(35.0, 1.0);
    }

    public void initNewLife() {
        this.player = new Player();
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
    }

    public void doFrameTitle() {
        if (this.getKey(71)) {
            this.clearKey(71);
            this.gamecfg.openGui();
            this.stop();
        }
    }

    public void paintFrameTitle() {
        this.drawString(this.gp_gamename, this.pfWidth() / 2, this.pfHeight() / 3, 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.pfWidth() / 2, 6 * this.pfHeight() / 10, 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", this.pfWidth() / 2, 7 * this.pfHeight() / 10, 0, this.title_font, this.title_color);
    }

    public void defineLevel() {
        int n;
        this.fillBG(this.gp_basebgfill);
        if (!this.gp_basebg.equals("empty")) {
            if (this.gp_basebg.equals("border")) {
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
            } else if (this.gp_basebg.equals("wallhoriz")) {
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
                for (int i = 6; i < this.pfTilesX() - 6; ++i) {
                    this.setTile(i, this.pfTilesY() / 2, this.gp_basebgtile);
                    this.setTileCid(i, this.pfTilesY() / 2, this.gp_basebgtype);
                }
            } else if (this.gp_basebg.equals("wallvert")) {
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
                for (int i = 6; i < this.pfTilesY() - 6; ++i) {
                    this.setTile(this.pfTilesX() / 3, i, this.gp_basebgtile);
                    this.setTileCid(this.pfTilesX() / 3, i, this.gp_basebgtype);
                    this.setTile(2 * this.pfTilesX() / 3, i, this.gp_basebgtile);
                    this.setTileCid(2 * this.pfTilesX() / 3, i, this.gp_basebgtype);
                }
            } else if (this.gp_basebg.equals("maze")) {
                double d;
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
                double d2 = (double)this.pfTilesX() / this.gp_basebgmazexsize;
                double d3 = (double)this.pfTilesY() / this.gp_basebgmazeysize;
                for (d = 0.0; d < (double)this.pfTilesX() - 1.5; d += d2) {
                    for (double d4 = 0.0; d4 < (double)this.pfTilesY() - 1.5; d4 += d3) {
                        this.drawBGCross(d, d4, this.gp_basebgtile, this.gp_basebgtype);
                    }
                }
                for (d = 0.0; d < (double)this.pfTilesX() + d2; d += d2) {
                    this.drawBGCross(d, this.pfTilesY() - 1, this.gp_basebgtile, this.gp_basebgtype);
                }
                for (d = 0.0; d < (double)this.pfTilesY() + d3; d += d3) {
                    this.drawBGCross(this.pfTilesX() - 1, d, this.gp_basebgtile, this.gp_basebgtype);
                }
                this.drawBGCross(this.pfTilesX() - 1, this.pfTilesY() - 1, this.gp_basebgtile, this.gp_basebgtype);
            }
        }
        if (this.gp_randombg1) {
            this.drawRandomBG(this.gp_randombg1density, this.gp_randombg1type, this.gp_randombg1tile);
        }
        if (this.gp_randombg2) {
            this.drawRandomBG(this.gp_randombg2density, this.gp_randombg2type, this.gp_randombg2tile);
        }
        if (this.gp_randombg3) {
            this.drawRandomBG(this.gp_randombg3density, this.gp_randombg3type, this.gp_randombg3tile);
        }
        this.removeObjects(null, 0);
        this.player = new Player();
        JGRectangle jGRectangle = this.getTiles(new JGRectangle((int)this.player.x - 16, (int)this.player.y - 16, 48, 48));
        for (n = 0; n < jGRectangle.width; ++n) {
            for (int i = 0; i < jGRectangle.height; ++i) {
                this.setTile(jGRectangle.x + n, jGRectangle.y + i, this.gp_basebgfill);
            }
        }
        if (this.gp_agent1) {
            n = 0;
            while ((double)n < this.gp_agent1createinit) {
                this.newAgent(1);
                ++n;
            }
        }
        if (this.gp_agent2) {
            n = 0;
            while ((double)n < this.gp_agent2createinit) {
                this.newAgent(2);
                ++n;
            }
        }
        if (this.gp_agent3) {
            n = 0;
            while ((double)n < this.gp_agent3createinit) {
                this.newAgent(3);
                ++n;
            }
        }
        if (this.gp_agent4) {
            n = 0;
            while ((double)n < this.gp_agent4createinit) {
                this.newAgent(4);
                ++n;
            }
        }
        if (this.gp_agent5) {
            n = 0;
            while ((double)n < this.gp_agent5createinit) {
                this.newAgent(5);
                ++n;
            }
        }
    }

    void drawRandomBG(double d, int n, String string) {
        int n2 = (int)((double)(this.pfTilesX() * this.pfTilesY()) * d / 100.0);
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5 = 20;
            do {
                n4 = this.random(0, this.pfTilesX(), 1);
                n3 = this.random(0, this.pfTilesY(), 1);
                if (--n5 > 0) continue;
                return;
            } while (this.getTileCid(n4, n3) != 0 || this.getTileCid(n4 - 1, n3 - 1) != 0 || this.getTileCid(n4 + 1, n3 - 1) != 0 || this.getTileCid(n4 - 1, n3 + 1) != 0 || this.getTileCid(n4 + 1, n3 + 1) != 0);
            this.setTile(n4, n3, string);
            this.setTileCid(n4, n3, n);
        }
    }

    void drawBGBorder(String string, int n) {
        int n2;
        for (n2 = 0; n2 < this.pfTilesX(); ++n2) {
            this.setTile(n2, 0, string);
            this.setTileCid(n2, 0, n);
            this.setTile(n2, this.pfTilesY() - 1, string);
            this.setTileCid(n2, this.pfTilesY() - 1, n);
        }
        for (n2 = 0; n2 < this.pfTilesY(); ++n2) {
            this.setTile(0, n2, string);
            this.setTileCid(0, n2, n);
            this.setTile(this.pfTilesX() - 1, n2, string);
            this.setTileCid(this.pfTilesX() - 1, n2, n);
        }
    }

    public void drawBGCross(double d, double d2, String string, int n) {
        int n2 = (int)d;
        int n3 = (int)d2;
        this.setTile(n2, n3, string);
        this.setTileCid(n2, n3, n);
        this.setTile(n2 - 1, n3, string);
        this.setTileCid(n2 - 1, n3, n);
        this.setTile(n2 + 1, n3, string);
        this.setTileCid(n2 + 1, n3, n);
        this.setTile(n2, n3 - 1, string);
        this.setTileCid(n2, n3 - 1, n);
        this.setTile(n2, n3 + 1, string);
        this.setTileCid(n2, n3 + 1, n);
    }

    boolean checkForTiles(double d, double d2) {
        return this.checkBGCollision(new JGRectangle((int)d, (int)d2, 16, 16)) != 0;
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(15, 48);
        this.checkBGCollision(15, 48);
        this.checkCollision(16, 15);
        this.checkBGCollision(15, 15);
        if (this.gp_agent1 && this.gp_agent1createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent1createbegin), (int)(35.0 * this.gp_agent1createend), (int)(35.0 * this.gp_agent1createinterval))) {
            this.newAgent(1);
        }
        if (this.gp_agent2 && this.gp_agent2createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent2createbegin), (int)(35.0 * this.gp_agent2createend), (int)(35.0 * this.gp_agent2createinterval))) {
            this.newAgent(2);
        }
        if (this.gp_agent3 && this.gp_agent3createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent3createbegin), (int)(35.0 * this.gp_agent3createend), (int)(35.0 * this.gp_agent3createinterval))) {
            this.newAgent(3);
        }
        if (this.gp_agent4 && this.gp_agent4createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent4createbegin), (int)(35.0 * this.gp_agent4createend), (int)(35.0 * this.gp_agent4createinterval))) {
            this.newAgent(4);
        }
        if (this.gp_agent5 && this.gp_agent5createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent5createbegin), (int)(35.0 * this.gp_agent5createend), (int)(35.0 * this.gp_agent5createinterval))) {
            this.newAgent(5);
        }
        if (this.gp_endleveltimeout && this.gametime >= 35.0 * this.gp_endleveltimeoutlen || this.gp_endlevelobjcount && this.countObjects(null, this.gp_endlevelobjtype) == 0) {
            this.score += (int)this.gp_endlevelscore;
            this.levelDone();
        }
    }

    public Agent newAgent(int n) {
        switch (n) {
            case 1: {
                Agent agent = new Agent(this.gp_agent1type, this.gp_agent1sprite, this.gp_agent1bouncesides, this.gp_agent1createloc, this.gp_agent1dieobjtype, this.gp_agent1blockbgtype, this.gp_agent1diebgtype, this.gp_agent1dieaction, this.gp_agent1shoot, this.gp_agent1shootfreq, this.gp_agent1shootdir, this.gp_agent1shootspeed, this.gp_agent1bullettype, this.gp_agent1diescore, this.xmots[0], this.ymots[0]);
                return agent;
            }
            case 2: {
                Agent agent = new Agent(this.gp_agent2type, this.gp_agent2sprite, this.gp_agent2bouncesides, this.gp_agent2createloc, this.gp_agent2dieobjtype, this.gp_agent2blockbgtype, this.gp_agent2diebgtype, this.gp_agent2dieaction, this.gp_agent2shoot, this.gp_agent2shootfreq, this.gp_agent2shootdir, this.gp_agent2shootspeed, this.gp_agent2bullettype, this.gp_agent2diescore, this.xmots[1], this.ymots[1]);
                return agent;
            }
            case 3: {
                Agent agent = new Agent(this.gp_agent3type, this.gp_agent3sprite, this.gp_agent3bouncesides, this.gp_agent3createloc, this.gp_agent3dieobjtype, this.gp_agent3blockbgtype, this.gp_agent3diebgtype, this.gp_agent3dieaction, this.gp_agent3shoot, this.gp_agent3shootfreq, this.gp_agent3shootdir, this.gp_agent3shootspeed, this.gp_agent3bullettype, this.gp_agent3diescore, this.xmots[2], this.ymots[2]);
                return agent;
            }
            case 4: {
                Agent agent = new Agent(this.gp_agent4type, this.gp_agent4sprite, this.gp_agent4bouncesides, this.gp_agent4createloc, this.gp_agent4dieobjtype, this.gp_agent4blockbgtype, this.gp_agent4diebgtype, this.gp_agent4dieaction, this.gp_agent4shoot, this.gp_agent4shootfreq, this.gp_agent4shootdir, this.gp_agent4shootspeed, this.gp_agent4bullettype, this.gp_agent4diescore, this.xmots[3], this.ymots[3]);
                return agent;
            }
            case 5: {
                Agent agent = new Agent(this.gp_agent5type, this.gp_agent5sprite, this.gp_agent5bouncesides, this.gp_agent5createloc, this.gp_agent5dieobjtype, this.gp_agent5blockbgtype, this.gp_agent5diebgtype, this.gp_agent5dieaction, this.gp_agent5shoot, this.gp_agent5shootfreq, this.gp_agent5shootdir, this.gp_agent5shootspeed, this.gp_agent5bullettype, this.gp_agent5diescore, this.xmots[4], this.ymots[4]);
                return agent;
            }
        }
        return null;
    }

    void initMotionPars() {
        this.xmots[0] = new AgentMotion(this.gp_agent1xspeed, this.gp_agent1movexinit, this.gp_agent1movexrandom, this.gp_agent1movexrandomchg, this.gp_agent1movextoplayer, this.gp_agent1movextoplayermin, this.gp_agent1movextoplayermax, this.gp_agent1movexfrplayer, this.gp_agent1movexfrplayermin, this.gp_agent1movexfrplayermax);
        this.ymots[0] = new AgentMotion(this.gp_agent1yspeed, this.gp_agent1moveyinit, this.gp_agent1moveyrandom, this.gp_agent1moveyrandomchg, this.gp_agent1moveytoplayer, this.gp_agent1moveytoplayermin, this.gp_agent1moveytoplayermax, this.gp_agent1moveyfrplayer, this.gp_agent1moveyfrplayermin, this.gp_agent1moveyfrplayermax);
        this.xmots[1] = new AgentMotion(this.gp_agent2xspeed, this.gp_agent2movexinit, this.gp_agent2movexrandom, this.gp_agent2movexrandomchg, this.gp_agent2movextoplayer, this.gp_agent2movextoplayermin, this.gp_agent2movextoplayermax, this.gp_agent2movexfrplayer, this.gp_agent2movexfrplayermin, this.gp_agent2movexfrplayermax);
        this.ymots[1] = new AgentMotion(this.gp_agent2yspeed, this.gp_agent2moveyinit, this.gp_agent2moveyrandom, this.gp_agent2moveyrandomchg, this.gp_agent2moveytoplayer, this.gp_agent2moveytoplayermin, this.gp_agent2moveytoplayermax, this.gp_agent2moveyfrplayer, this.gp_agent2moveyfrplayermin, this.gp_agent2moveyfrplayermax);
        this.xmots[2] = new AgentMotion(this.gp_agent3xspeed, this.gp_agent3movexinit, this.gp_agent3movexrandom, this.gp_agent3movexrandomchg, this.gp_agent3movextoplayer, this.gp_agent3movextoplayermin, this.gp_agent3movextoplayermax, this.gp_agent3movexfrplayer, this.gp_agent3movexfrplayermin, this.gp_agent3movexfrplayermax);
        this.ymots[2] = new AgentMotion(this.gp_agent3yspeed, this.gp_agent3moveyinit, this.gp_agent3moveyrandom, this.gp_agent3moveyrandomchg, this.gp_agent3moveytoplayer, this.gp_agent3moveytoplayermin, this.gp_agent3moveytoplayermax, this.gp_agent3moveyfrplayer, this.gp_agent3moveyfrplayermin, this.gp_agent3moveyfrplayermax);
        this.xmots[3] = new AgentMotion(this.gp_agent4xspeed, this.gp_agent4movexinit, this.gp_agent4movexrandom, this.gp_agent4movexrandomchg, this.gp_agent4movextoplayer, this.gp_agent4movextoplayermin, this.gp_agent4movextoplayermax, this.gp_agent4movexfrplayer, this.gp_agent4movexfrplayermin, this.gp_agent4movexfrplayermax);
        this.ymots[3] = new AgentMotion(this.gp_agent4yspeed, this.gp_agent4moveyinit, this.gp_agent4moveyrandom, this.gp_agent4moveyrandomchg, this.gp_agent4moveytoplayer, this.gp_agent4moveytoplayermin, this.gp_agent4moveytoplayermax, this.gp_agent4moveyfrplayer, this.gp_agent4moveyfrplayermin, this.gp_agent4moveyfrplayermax);
        this.xmots[4] = new AgentMotion(this.gp_agent5xspeed, this.gp_agent5movexinit, this.gp_agent5movexrandom, this.gp_agent5movexrandomchg, this.gp_agent5movextoplayer, this.gp_agent5movextoplayermin, this.gp_agent5movextoplayermax, this.gp_agent5movexfrplayer, this.gp_agent5movexfrplayermin, this.gp_agent5movexfrplayermax);
        this.ymots[4] = new AgentMotion(this.gp_agent5yspeed, this.gp_agent5moveyinit, this.gp_agent5moveyrandom, this.gp_agent5moveyrandomchg, this.gp_agent5moveytoplayer, this.gp_agent5moveytoplayermin, this.gp_agent5moveytoplayermax, this.gp_agent5moveyfrplayer, this.gp_agent5moveyfrplayermin, this.gp_agent5moveyfrplayermax);
    }

    class AgentMotion {
        public double speed = 5.0;
        public String init = "center";
        public boolean random = false;
        public double randomchg = 1.0;
        public boolean toplayer = false;
        public double toplayermin = 0.0;
        public double toplayermax = 100.0;
        public boolean frplayer = false;
        public double frplayermin = 0.0;
        public double frplayermax = 100.0;

        public AgentMotion(double d, String string, boolean bl, double d2, boolean bl2, double d3, double d4, boolean bl3, double d5, double d6) {
            this.speed = d;
            this.init = string;
            this.random = bl;
            this.randomchg = d2;
            this.toplayer = bl2;
            this.toplayermin = d3;
            this.toplayermax = d4;
            this.frplayer = bl3;
            this.frplayermin = d5;
            this.frplayermax = d6;
        }
    }

    public class AgentBullet
    extends JGObject {
        int diebgtype;

        public AgentBullet(double d, double d2, int n, String string, int n2, double d3, double d4) {
            super("agentbullet", true, d + 4.0, d2 + 4.0, n, string + "bul", d3, d4, -2);
            this.diebgtype = n2;
        }

        public void hit_bg(int n) {
            if (AgentBullet.and(n, this.diebgtype)) {
                this.remove();
            }
        }
    }

    class Agent
    extends JGObject {
        int objtimer = 0;
        int type;
        String sprite;
        String bouncesides;
        int dieobjtype;
        int blockbgtype;
        int diebgtype;
        String dieaction;
        boolean shoot;
        double shootfreq;
        String shootdir;
        double shootspeed;
        int bullettype;
        double diescore;
        AgentMotion xmot;
        AgentMotion ymot;

        public Agent(int n, String string, String string2, String string3, int n2, int n3, int n4, String string4, boolean bl, double d, String string5, double d2, int n5, double d3, AgentMotion agentMotion, AgentMotion agentMotion2) {
            super("agent", true, 100.0, 100.0, n, string);
            this.type = n;
            this.sprite = string;
            this.bouncesides = string2;
            this.dieobjtype = n2;
            this.blockbgtype = n3;
            this.diebgtype = n4;
            this.dieaction = string4;
            this.shoot = bl;
            this.shootfreq = d;
            this.shootdir = string5;
            this.shootspeed = d2;
            this.bullettype = n5;
            this.diescore = d3;
            int n6 = 0;
            int n7 = 12;
            do {
                int n8;
                if (string3.equals("random")) {
                    this.setPos(SimpleGeneratedGame.this.random(0, SimpleGeneratedGame.this.pfWidth(), 1), SimpleGeneratedGame.this.random(0, SimpleGeneratedGame.this.pfHeight(), 1));
                } else if (string3.equals("corner")) {
                    n6 |= 0xF;
                } else if (string3.equals("top")) {
                    n6 |= 1;
                } else if (string3.equals("bottom")) {
                    n6 |= 2;
                } else if (string3.equals("topbottom")) {
                    n6 |= 3;
                } else if (string3.equals("left")) {
                    n6 |= 4;
                } else if (string3.equals("right")) {
                    n6 |= 8;
                } else if (string3.equals("leftright")) {
                    n6 |= 0xC;
                }
                if (n6 == 0) continue;
                while ((n6 & (n8 = 1 << SimpleGeneratedGame.this.random(0, 3, 1))) == 0) {
                }
                if (n8 == 1) {
                    this.y = -16.0;
                }
                if (n8 == 2) {
                    this.y = SimpleGeneratedGame.this.pfHeight();
                }
                if (n8 == 1 || n8 == 2) {
                    this.x = SimpleGeneratedGame.this.random(0.0, SimpleGeneratedGame.this.pfWidth() - 16);
                }
                if (n8 == 4) {
                    this.x = -16.0;
                }
                if (n8 == 8) {
                    this.x = SimpleGeneratedGame.this.pfWidth();
                }
                if (n8 != 4 && n8 != 8) continue;
                this.y = SimpleGeneratedGame.this.random(0.0, SimpleGeneratedGame.this.pfHeight() - 16);
            } while (n7-- > 0 && (SimpleGeneratedGame.this.checkForTiles(this.x, this.y) || SimpleGeneratedGame.this.player != null && (this.x > SimpleGeneratedGame.this.player.x - 16.0 && this.x < SimpleGeneratedGame.this.player.x + 32.0 || this.y > SimpleGeneratedGame.this.player.y - 16.0 && this.y < SimpleGeneratedGame.this.player.y + 32.0 || this.x > SimpleGeneratedGame.this.player.x - 48.0 && this.x < SimpleGeneratedGame.this.player.x + 64.0 && this.y > SimpleGeneratedGame.this.player.y - 48.0 && this.y < SimpleGeneratedGame.this.player.y + 64.0)));
            this.xmot = agentMotion;
            this.ymot = agentMotion2;
            if (agentMotion.init.equals("center") || agentMotion.init.equals("player") && SimpleGeneratedGame.this.player == null) {
                this.xspeed = (double)(this.x > (double)(SimpleGeneratedGame.this.pfWidth() / 2) ? -1 : 1) * agentMotion.speed;
            } else if (agentMotion.init.equals("player")) {
                this.xspeed = (double)(this.x > SimpleGeneratedGame.this.player.x ? -1 : 1) * agentMotion.speed;
            } else if (agentMotion.init.equals("random")) {
                this.xspeed = agentMotion.speed * (double)SimpleGeneratedGame.this.random(-1, 1, 2);
            } else if (agentMotion.init.equals("not")) {
                // empty if block
            }
            if (agentMotion2.init.equals("center") || agentMotion2.init.equals("player") && SimpleGeneratedGame.this.player == null) {
                this.yspeed = (double)(this.y > (double)(SimpleGeneratedGame.this.pfHeight() / 2) ? -1 : 1) * agentMotion2.speed;
            } else if (agentMotion2.init.equals("player")) {
                this.yspeed = (double)(this.y > SimpleGeneratedGame.this.player.y ? -1 : 1) * agentMotion2.speed;
            } else if (agentMotion2.init.equals("random")) {
                this.yspeed = agentMotion2.speed * (double)SimpleGeneratedGame.this.random(-1, 1, 2);
            } else if (agentMotion2.init.equals("not")) {
                // empty if block
            }
        }

        public void move() {
            ++this.objtimer;
            if (this.xmot.random && this.objtimer % (int)(35.0 * this.xmot.randomchg) == 0) {
                this.xspeed = this.xmot.speed * (double)SimpleGeneratedGame.this.random(-1, 1, 2);
            }
            if (this.ymot.random && this.objtimer % (int)(35.0 * this.ymot.randomchg) == 0) {
                this.yspeed = this.ymot.speed * (double)SimpleGeneratedGame.this.random(-1, 1, 2);
            }
            if (SimpleGeneratedGame.this.player != null) {
                double d = Math.sqrt((SimpleGeneratedGame.this.player.x - this.x) * (SimpleGeneratedGame.this.player.x - this.x) + (SimpleGeneratedGame.this.player.y - this.y) * (SimpleGeneratedGame.this.player.y - this.y)) * 100.0 / (double)SimpleGeneratedGame.this.pfWidth();
                if (this.xmot.toplayer && d > this.xmot.toplayermin && d < this.xmot.toplayermax) {
                    this.xspeed = 0.0;
                    this.x += this.xmot.speed * (double)(SimpleGeneratedGame.this.player.x > this.x ? 1 : -1);
                } else if (this.xmot.frplayer && d > this.xmot.frplayermin && d < this.xmot.frplayermax) {
                    this.xspeed = 0.0;
                    this.x += this.xmot.speed * (double)(SimpleGeneratedGame.this.player.x < this.x ? 1 : -1);
                }
                if (this.ymot.toplayer && d > this.ymot.toplayermin && d < this.ymot.toplayermax) {
                    this.yspeed = 0.0;
                    this.y += this.ymot.speed * (double)(SimpleGeneratedGame.this.player.y > this.y ? 1 : -1);
                } else if (this.ymot.frplayer && d > this.ymot.frplayermin && d < this.ymot.frplayermax) {
                    this.yspeed = 0.0;
                    this.y += this.ymot.speed * (double)(SimpleGeneratedGame.this.player.y < this.y ? 1 : -1);
                }
            }
            int n = 0;
            if (this.bouncesides.equals("any")) {
                n |= 0xF;
            } else if (this.bouncesides.equals("top")) {
                n |= 1;
            } else if (this.bouncesides.equals("bottom")) {
                n |= 2;
            } else if (this.bouncesides.equals("topbottom")) {
                n |= 3;
            } else if (this.bouncesides.equals("left")) {
                n |= 4;
            } else if (this.bouncesides.equals("right")) {
                n |= 8;
            } else if (this.bouncesides.equals("leftright")) {
                n |= 0xC;
            }
            if ((n & 1) != 0 && this.y < 0.0) {
                this.y = 0.0;
                if (this.yspeed < 0.0) {
                    this.yspeed = -this.yspeed;
                }
            }
            if ((n & 2) != 0 && this.y > (double)(SimpleGeneratedGame.this.pfHeight() - 16)) {
                this.y = SimpleGeneratedGame.this.pfHeight() - 16;
                if (this.yspeed > 0.0) {
                    this.yspeed = -this.yspeed;
                }
            }
            if ((n & 4) != 0 && this.x < 0.0) {
                this.x = 0.0;
                if (this.xspeed < 0.0) {
                    this.xspeed = -this.xspeed;
                }
            }
            if ((n & 8) != 0 && this.x > (double)(SimpleGeneratedGame.this.pfWidth() - 16)) {
                this.x = SimpleGeneratedGame.this.pfWidth() - 16;
                if (this.xspeed > 0.0) {
                    this.xspeed = -this.xspeed;
                }
            }
            if (this.shoot && this.shootfreq > 0.0 && this.objtimer % (int)(this.shootfreq * 35.0) == 0) {
                if (this.shootdir.equals("left")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, -this.shootspeed, 0.0);
                } else if (this.shootdir.equals("right")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, this.shootspeed, 0.0);
                } else if (this.shootdir.equals("up")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, 0.0, -this.shootspeed);
                } else if (this.shootdir.equals("down")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, 0.0, this.shootspeed);
                } else if (this.shootdir.equals("player") && SimpleGeneratedGame.this.player != null) {
                    double d = Math.atan2(SimpleGeneratedGame.this.player.x - this.x, SimpleGeneratedGame.this.player.y - this.y);
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, this.shootspeed * Math.sin(d), this.shootspeed * Math.cos(d));
                }
            }
        }

        public void hit(JGObject jGObject) {
            if (Agent.and(jGObject.colid, this.dieobjtype)) {
                this.die();
                if ((jGObject.colid & 0x10) != 0) {
                    jGObject.remove();
                }
            }
        }

        public void hit_bg(int n) {
            if (Agent.and(n, this.diebgtype)) {
                this.die();
            }
            if (Agent.and(n, this.blockbgtype)) {
                this.x = this.getLastX();
                this.y = this.getLastY();
                this.xspeed = -this.xspeed;
                this.yspeed = -this.yspeed;
            }
        }

        public void die() {
            SimpleGeneratedGame.this.score += (int)this.diescore;
            this.remove();
            if (!this.dieaction.equals("die")) {
                if (this.dieaction.equals("create1")) {
                    Agent agent = SimpleGeneratedGame.this.newAgent(1);
                    agent.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create2")) {
                    Agent agent = SimpleGeneratedGame.this.newAgent(2);
                    agent.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create3")) {
                    Agent agent = SimpleGeneratedGame.this.newAgent(3);
                    agent.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create4")) {
                    Agent agent = SimpleGeneratedGame.this.newAgent(4);
                    agent.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create5")) {
                    Agent agent = SimpleGeneratedGame.this.newAgent(5);
                    agent.setPos(this.x, this.y);
                }
            }
        }
    }

    public class PlayerBullet
    extends JGObject {
        public PlayerBullet(double d, double d2, double d3, double d4) {
            super("playerbullet", true, d + 4.0, d2 + 4.0, 16, null, d3, d4, -2);
            this.setImage(SimpleGeneratedGame.this.gp_playersprite + "bul");
        }

        public void hit_bg(int n) {
            if (PlayerBullet.and(n, SimpleGeneratedGame.this.gp_playerbulletdiebgtype)) {
                this.remove();
            }
        }
    }

    public class Player
    extends JGObject {
        int invulnerability = 105;
        double bulxdir = 0.0;
        double bulydir = 0.0;

        public Player() {
            super("player", false, 0.0, 0.0, 32, null);
            this.setPos(SimpleGeneratedGame.this.gp_playerx, SimpleGeneratedGame.this.gp_playery);
            this.setImage(SimpleGeneratedGame.this.gp_playersprite);
        }

        public void move() {
            if (this.invulnerability > 0) {
                --this.invulnerability;
                if ((this.invulnerability & 3) >= 2) {
                    this.setImage(null);
                } else {
                    this.setImage(SimpleGeneratedGame.this.gp_playersprite);
                }
            }
            if (SimpleGeneratedGame.this.gp_playerxmove.equals("linear")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_left)) {
                    this.x -= SimpleGeneratedGame.this.gp_playerxspeed;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_right)) {
                    this.x += SimpleGeneratedGame.this.gp_playerxspeed;
                }
            } else if (SimpleGeneratedGame.this.gp_playerxmove.equals("accel")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_left)) {
                    this.xspeed -= SimpleGeneratedGame.this.gp_playerxaccel;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_right)) {
                    this.xspeed += SimpleGeneratedGame.this.gp_playerxaccel;
                }
            }
            if (SimpleGeneratedGame.this.gp_playerymove.equals("linear")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_up)) {
                    this.y -= SimpleGeneratedGame.this.gp_playeryspeed;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_down)) {
                    this.y += SimpleGeneratedGame.this.gp_playeryspeed;
                }
            } else if (SimpleGeneratedGame.this.gp_playerymove.equals("accel")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_up)) {
                    this.yspeed -= SimpleGeneratedGame.this.gp_playeryaccel;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_down)) {
                    this.yspeed += SimpleGeneratedGame.this.gp_playeryaccel;
                }
            }
            if (this.x < 0.0) {
                this.x = 0.0;
            }
            if (this.x > (double)(SimpleGeneratedGame.this.pfWidth() - 16)) {
                this.x = SimpleGeneratedGame.this.pfWidth() - 16;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
            }
            if (this.y > (double)(SimpleGeneratedGame.this.pfHeight() - 16)) {
                this.y = SimpleGeneratedGame.this.pfHeight() - 16;
            }
            double d = this.x + this.xspeed - this.getLastX();
            double d2 = this.y + this.yspeed - this.getLastY();
            if (d != 0.0 || d2 != 0.0) {
                this.bulxdir = d;
                this.bulydir = d2;
            }
            if ((double)SimpleGeneratedGame.this.countObjects(null, 16) > SimpleGeneratedGame.this.gp_playermaxbullets - 0.01) {
                return;
            }
            if (SimpleGeneratedGame.this.gp_playershoot.equals("1dir")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fire)) {
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("left")) {
                        new PlayerBullet(this.x, this.y, -SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("right")) {
                        new PlayerBullet(this.x, this.y, SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("up")) {
                        new PlayerBullet(this.x, this.y, 0.0, -SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("down")) {
                        new PlayerBullet(this.x, this.y, 0.0, SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                }
            } else if (SimpleGeneratedGame.this.gp_playershoot.equals("2dir")) {
                if (SimpleGeneratedGame.this.gp_playershootaxis.equals("horizontal")) {
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireleft)) {
                        new PlayerBullet(this.x, this.y, -SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireright)) {
                        new PlayerBullet(this.x, this.y, SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                }
                if (SimpleGeneratedGame.this.gp_playershootaxis.equals("vertical")) {
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireup)) {
                        new PlayerBullet(this.x, this.y, 0.0, -SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_firedown)) {
                        new PlayerBullet(this.x, this.y, 0.0, SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                }
            } else if (SimpleGeneratedGame.this.gp_playershoot.equals("4dir")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireleft)) {
                    new PlayerBullet(this.x, this.y, -SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireright)) {
                    new PlayerBullet(this.x, this.y, SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireup)) {
                    new PlayerBullet(this.x, this.y, 0.0, -SimpleGeneratedGame.this.gp_playerbulletspeed);
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_firedown)) {
                    new PlayerBullet(this.x, this.y, 0.0, SimpleGeneratedGame.this.gp_playerbulletspeed);
                }
            } else if (SimpleGeneratedGame.this.gp_playershoot.equals("alldir") && SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fire) && (this.bulxdir != 0.0 || this.bulydir != 0.0)) {
                new PlayerBullet(this.x, this.y, this.bulxdir * SimpleGeneratedGame.this.gp_playerbulletspeed, this.bulydir * SimpleGeneratedGame.this.gp_playerbulletspeed);
            }
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fire);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fireup);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_firedown);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fireleft);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fireright);
        }

        public void hit(JGObject jGObject) {
            if (Player.and(jGObject.colid, SimpleGeneratedGame.this.gp_playerdieobjtype) && this.invulnerability == 0) {
                SimpleGeneratedGame.this.lifeLost();
            }
            if (Player.and(jGObject.colid, SimpleGeneratedGame.this.gp_playergetobjtype)) {
                jGObject.remove();
                SimpleGeneratedGame.this.score = (int)((double)SimpleGeneratedGame.this.score + SimpleGeneratedGame.this.gp_playergetscore);
                new StdScoring("pts", jGObject.x, jGObject.y, 0.0, -1.0, 40, (int)SimpleGeneratedGame.this.gp_playergetscore + " pts", SimpleGeneratedGame.this.scoring_font, new JGColor[]{JGColor.red, JGColor.yellow}, 2);
            }
        }

        public void hit_bg(int n) {
            if (Player.and(n, SimpleGeneratedGame.this.gp_playerbumpbgtype)) {
                this.x = this.getLastX();
                this.y = this.getLastY();
                this.snapToGrid(8.0, 8.0);
            }
            if (Player.and(n, SimpleGeneratedGame.this.gp_playerdiebgtype) && this.invulnerability == 0) {
                SimpleGeneratedGame.this.lifeLost();
            }
        }
    }
}

