/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Hashtable;
import jgame.JGColor;
import jgame.JGImage;
import jgame.JGPoint;
import jgame.impl.JGameError;
import jgame.platform.JREEngine;

class JREImage
implements JGImage {
    static Component output_comp = null;
    static MediaTracker mediatracker = null;
    DummyObserver observer = new DummyObserver();
    static Hashtable loadedimages = new Hashtable();
    public Image img = null;
    public Object texture = null;
    public Object stretched_texture = null;

    public void setComponent(Component component) {
        output_comp = component;
        mediatracker = new MediaTracker(output_comp);
        loadedimages = new Hashtable();
    }

    JREImage(Image image) {
        this.img = image;
    }

    JREImage() {
    }

    public JGImage loadImage(String string) {
        Image image = (Image)loadedimages.get(string);
        if (image == null) {
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                try {
                    File file = new File(string);
                    uRL = file.canRead() ? file.toURL() : new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new JGameError("File not found or malformed path or URL '" + string + "'.", true);
                }
            }
            image = output_comp.getToolkit().createImage(uRL);
            loadedimages.put(string, image);
        }
        try {
            JREImage.ensureLoaded(image);
        }
        catch (Exception exception) {
            throw new JGameError("Error loading image " + string);
        }
        return new JREImage(image);
    }

    public static JGImage loadImage(URL uRL) {
        Image image = (Image)loadedimages.get(uRL);
        if (image == null) {
            image = output_comp.getToolkit().createImage(uRL);
            loadedimages.put(uRL, image);
        }
        try {
            JREImage.ensureLoaded(image);
        }
        catch (Exception exception) {
            System.err.println("Error loading image " + uRL);
            return null;
        }
        return new JREImage(image);
    }

    public void purgeImage(String string) {
        if (loadedimages.containsKey(string)) {
            loadedimages.remove(string);
        }
    }

    public JGPoint getSize() {
        return new JGPoint(this.img.getWidth(this.observer), this.img.getHeight(this.observer));
    }

    public boolean isOpaque(int n) {
        int[] nArray = this.getPixels();
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] >> 24 & 0xFF) >= n) continue;
            return false;
        }
        return true;
    }

    public int[] getPixels() {
        JGPoint jGPoint = this.getSize();
        int[] nArray = new int[jGPoint.x * jGPoint.y];
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, 0, 0, jGPoint.x, jGPoint.y, nArray, 0, jGPoint.x);
        this.grabPixels(pixelGrabber);
        return nArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, n, n2, n3, n4, nArray, 0, n3);
        this.grabPixels(pixelGrabber);
        return nArray;
    }

    private void grabPixels(PixelGrabber pixelGrabber) {
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public JGImage rotate(int n) {
        Object var2_2 = null;
        JGPoint jGPoint = this.getSize();
        int[] nArray = this.getPixels();
        int[] nArray2 = new int[jGPoint.x * jGPoint.y];
        int n2 = n / 90 & 3;
        if (n2 == 0) {
            return this;
        }
        if (n2 == 1) {
            for (int i = 0; i < jGPoint.y; ++i) {
                for (int j = 0; j < jGPoint.x; ++j) {
                    nArray2[j * jGPoint.y + (jGPoint.y - 1 - i)] = nArray[i * jGPoint.x + j];
                }
            }
            return new JREImage(output_comp.createImage(new MemoryImageSource(jGPoint.y, jGPoint.x, nArray2, 0, jGPoint.y)));
        }
        if (n2 == 3) {
            for (int i = 0; i < jGPoint.y; ++i) {
                for (int j = 0; j < jGPoint.x; ++j) {
                    nArray2[(jGPoint.x - j - 1) * jGPoint.y + i] = nArray[i * jGPoint.x + j];
                }
            }
            return new JREImage(output_comp.createImage(new MemoryImageSource(jGPoint.y, jGPoint.x, nArray2, 0, jGPoint.y)));
        }
        if (n2 == 2) {
            for (int i = 0; i < jGPoint.y; ++i) {
                for (int j = 0; j < jGPoint.x; ++j) {
                    nArray2[(jGPoint.y - i - 1) * jGPoint.x + (jGPoint.x - j - 1)] = nArray[i * jGPoint.x + j];
                }
            }
        }
        return new JREImage(output_comp.createImage(new MemoryImageSource(jGPoint.x, jGPoint.y, nArray2, 0, jGPoint.x)));
    }

    public JGImage rotateAny(double d) {
        int n;
        JGPoint jGPoint = this.getSize();
        int n2 = jGPoint.x;
        int n3 = jGPoint.y;
        int n4 = n = (int)Math.max((double)Math.max(n2, n3), 0.75 * (double)(n2 + n3));
        int n5 = (n - n2) / 2;
        int n6 = (n4 - n3) / 2;
        BufferedImage bufferedImage = JREImage.createCompatibleImage(n, n4, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n5, n6);
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, n2 / 2, n3 / 2);
        affineTransform.concatenate(affineTransform2);
        graphics2D.drawImage(this.img, affineTransform, null);
        return new JREImage(bufferedImage);
    }

    public JGImage flip(boolean bl, boolean bl2) {
        int[] nArray;
        JGPoint jGPoint;
        block7: {
            int[] nArray2;
            block8: {
                block6: {
                    Object var3_3 = null;
                    jGPoint = this.getSize();
                    nArray2 = this.getPixels();
                    nArray = new int[jGPoint.x * jGPoint.y];
                    if (!bl2 || bl) break block6;
                    for (int i = 0; i < jGPoint.y; ++i) {
                        for (int j = 0; j < jGPoint.x; ++j) {
                            nArray[(jGPoint.y - i - 1) * jGPoint.x + j] = nArray2[i * jGPoint.x + j];
                        }
                    }
                    break block7;
                }
                if (!bl || bl2) break block8;
                for (int i = 0; i < jGPoint.y; ++i) {
                    for (int j = 0; j < jGPoint.x; ++j) {
                        nArray[i * jGPoint.x + (jGPoint.x - j - 1)] = nArray2[i * jGPoint.x + j];
                    }
                }
                break block7;
            }
            if (!bl || !bl2) break block7;
            for (int i = 0; i < jGPoint.y; ++i) {
                for (int j = 0; j < jGPoint.x; ++j) {
                    nArray[(jGPoint.y - i - 1) * jGPoint.x + (jGPoint.x - j - 1)] = nArray2[i * jGPoint.x + j];
                }
            }
        }
        return new JREImage(output_comp.createImage(new MemoryImageSource(jGPoint.x, jGPoint.y, nArray, 0, jGPoint.x)));
    }

    public JGImage scale(int n, int n2) {
        Image image = this.img.getScaledInstance(n, n2, 4);
        try {
            JREImage.ensureLoaded(image);
        }
        catch (Exception exception) {
            System.err.println("Error scaling image.");
        }
        return new JREImage(image);
    }

    public static void ensureLoaded(Image image) throws Exception {
        mediatracker.addImage(image, 0);
        try {
            mediatracker.waitForAll();
            if (mediatracker.getErrorsAny() != null) {
                mediatracker.removeImage(image);
                throw new Exception("Error loading image");
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        mediatracker.removeImage(image);
    }

    public JGImage crop(int n, int n2, int n3, int n4) {
        JGPoint jGPoint = this.getSize();
        int[] nArray = this.getPixels(n, n2, n3, n4);
        return new JREImage(output_comp.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3)));
    }

    public JGImage toDisplayCompatible(int n, JGColor jGColor, boolean bl, boolean bl2) {
        int[] nArray;
        Object object;
        Color color = new Color(jGColor.r, jGColor.g, jGColor.b);
        int n2 = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        JGPoint jGPoint = this.getSize();
        int[] nArray2 = this.getPixels();
        BufferedImage bufferedImage = bl2 ? JREImage.createCompatibleImage(jGPoint.x, jGPoint.y, 2) : JREImage.createCompatibleImage(jGPoint.x, jGPoint.y, 3);
        if (!bl) {
            object = bufferedImage.getGraphics();
            ((Graphics)object).setColor(color);
            ((Graphics)object).fillRect(0, 0, jGPoint.x, jGPoint.y);
            ((Graphics)object).drawImage(this.img, 0, 0, null);
            nArray = new JREImage(bufferedImage).getPixels();
        } else {
            nArray = nArray2;
        }
        object = new int[jGPoint.x * jGPoint.y];
        for (int i = 0; i < jGPoint.y; ++i) {
            for (int j = 0; j < jGPoint.x; ++j) {
                object[i * jGPoint.x + j] = (nArray2[i * jGPoint.x + j] >> 24 & 0xFF) >= n ? (Object)(nArray[i * jGPoint.x + j] | 0xFF000000) : (Object)n2;
            }
        }
        return new JREImage(output_comp.createImage(new MemoryImageSource(jGPoint.x, jGPoint.y, bufferedImage.getColorModel(), (int[])(bl2 ? object : (Object)nArray), 0, jGPoint.x)));
    }

    public static BufferedImage createCompatibleImage(int n, int n2, int n3) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, n3);
        return bufferedImage;
    }

    public static BufferedImage createRGBA8Image(int[] nArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage;
    }

    public static Image createScratchImage(int n, int n2) {
        try {
            Image image = (Image)JREImage.tryMethod(output_comp, "createVolatileImage", new Object[]{new Integer(n), new Integer(n2)});
            if (image == null) {
                return output_comp.createImage(n, n2);
            }
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Integer n3 = (Integer)JREImage.tryMethod(image, "validate", new Object[]{graphicsConfiguration});
            if (n3 == 2) {
                return output_comp.createImage(n, n2);
            }
            return image;
        }
        catch (AccessControlException accessControlException) {
            return output_comp.createImage(n, n2);
        }
    }

    public static boolean isScratchImageValid(Image image) {
        try {
            Boolean bl = (Boolean)JREImage.tryMethod(image, "contentsLost", new Object[0]);
            if (bl == null) {
                return true;
            }
            return bl == false;
        }
        catch (AccessControlException accessControlException) {
            return true;
        }
    }

    static Object tryMethod(Object object, String string, Object[] objectArray) {
        try {
            Method method = JREEngine.getMethod(object.getClass(), string, objectArray);
            if (method == null) {
                return null;
            }
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throwable.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unexpected exception:");
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    class DummyObserver
    implements ImageObserver {
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return true;
        }
    }
}

