/*
 * Decompiled with CFR 0.152.
 */
package jgame;

import jgame.JGObject;
import jgame.impl.JGEngineInterface;

public abstract class JGTimer {
    int frames = 0;
    double frames_left = 0.0;
    public boolean running = true;
    public boolean one_shot;
    public JGObject parent_obj = null;
    public String parent_state = null;
    JGEngineInterface eng;

    public JGTimer(int n, boolean bl) {
        this.set(n, bl);
        this.eng = JGObject.default_engine;
        this.eng.registerTimer(this);
    }

    public JGTimer(int n, boolean bl, JGObject jGObject) {
        this.set(n, bl);
        this.eng = JGObject.default_engine;
        this.eng.registerTimer(this);
        this.parent_obj = jGObject;
    }

    public JGTimer(int n, boolean bl, String string) {
        this.set(n, bl);
        this.eng = JGObject.default_engine;
        this.eng.registerTimer(this);
        this.parent_state = string;
    }

    public void set(int n, boolean bl) {
        this.frames = n;
        this.frames_left = this.frames;
        this.one_shot = bl;
    }

    public boolean tick(double d) {
        if (this.parent_state != null && !this.eng.inGameStateNextFrame(this.parent_state)) {
            return true;
        }
        if (this.parent_obj != null && !this.parent_obj.isAlive()) {
            return true;
        }
        if (this.running) {
            if (this.frames_left <= 0.0) {
                this.frames_left = this.frames;
                this.alarm();
                if (this.one_shot) {
                    return true;
                }
            } else {
                this.frames_left -= d;
            }
        }
        return false;
    }

    public abstract void alarm();
}

