/*
 * Decompiled with CFR 0.152.
 */
package jgame.impl;

public class Animation {
    String[] frames;
    public double speed;
    public int increment = 1;
    public boolean pingpong = false;
    int framenr = 0;
    double phase = 0.0;
    boolean running = true;

    public Animation(String[] stringArray, double d) {
        this.frames = stringArray;
        this.speed = d;
    }

    public Animation(String[] stringArray, double d, boolean bl) {
        this.frames = stringArray;
        this.speed = d;
        this.pingpong = bl;
    }

    public Animation(String[] stringArray, double d, boolean bl, int n) {
        this.frames = stringArray;
        this.speed = d;
        this.pingpong = bl;
        this.increment = n;
    }

    public void stop() {
        this.running = false;
    }

    public void start() {
        this.running = true;
    }

    public void reset() {
        this.framenr = 0;
        this.phase = 0.0;
    }

    public Animation copy() {
        Animation animation = new Animation(this.frames, this.speed, this.pingpong);
        animation.framenr = this.framenr;
        animation.phase = this.phase;
        animation.running = this.running;
        return animation;
    }

    public String getCurrentFrame() {
        if (this.framenr < 0 || this.framenr >= this.frames.length) {
            return this.frames[0];
        }
        return this.frames[this.framenr];
    }

    public String animate(double d) {
        String string = this.getCurrentFrame();
        if (this.running) {
            this.phase += this.speed * d;
            while (this.phase >= 1.0) {
                this.phase -= 1.0;
                this.framenr += this.increment;
                if (!this.pingpong) {
                    if (this.framenr >= this.frames.length) {
                        this.framenr -= this.frames.length;
                    }
                    if (this.framenr >= 0) continue;
                    this.framenr += this.frames.length;
                    continue;
                }
                if (this.framenr >= this.frames.length) {
                    this.framenr -= 2 * this.increment;
                    this.increment = -this.increment;
                }
                if (this.framenr >= 0) continue;
                this.framenr -= 2 * this.increment;
                this.increment = -this.increment;
            }
        }
        return string;
    }
}

