/*
 * Decompiled with CFR 0.152.
 */
package jgame.impl;

public class SortedArray {
    int capacity;
    int growspeed;
    public int size = 0;
    public String[] keys;
    public Object[] values;

    public SortedArray(int n) {
        this.capacity = n;
        this.growspeed = n;
        this.keys = new String[this.capacity];
        this.values = new Object[this.capacity];
    }

    public void clear() {
        this.clear(0);
    }

    void clear(int n) {
        for (int i = n; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = n;
    }

    public void put(SortedArray sortedArray) {
        int n;
        int n2;
        int[] nArray = new int[sortedArray.size];
        int n3 = this.size;
        int n4 = this.size;
        for (n2 = sortedArray.size - 1; n2 >= 0; --n2) {
            n = this.get(sortedArray.keys[n2]);
            if (n >= 0) {
                this.keys[n] = sortedArray.keys[n2];
                this.values[n] = sortedArray.values[n2];
                this.size = n;
            } else {
                this.size = -1 - n;
                ++n4;
            }
            nArray[n2] = -1 - n;
        }
        if (n4 > this.capacity) {
            this.grow(n4 - n3);
        }
        n2 = n3 - 1;
        n = n4 - 1;
        for (int i = sortedArray.size - 1; i >= 0; --i) {
            if (nArray[i] < 0) continue;
            while (n2 >= nArray[i]) {
                this.keys[n] = this.keys[n2];
                this.values[n--] = this.values[n2--];
            }
            this.keys[n] = sortedArray.keys[i];
            this.values[n--] = sortedArray.values[i];
        }
        this.size = n4;
    }

    public void put(String string, Object object) {
        int n = this.get(string);
        if (n >= 0) {
            this.keys[n] = string;
            this.values[n] = object;
            return;
        }
        if (this.size + 1 > this.capacity) {
            this.grow(1);
        }
        ++this.size;
        n = -1 - n;
        for (int i = this.size - 1; i > n; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[n] = string;
        this.values[n] = object;
    }

    void grow(int n) {
        this.capacity += n + this.growspeed;
        String[] stringArray = new String[this.capacity];
        Object[] objectArray = new Object[this.capacity];
        for (int i = 0; i < this.size; ++i) {
            stringArray[i] = this.keys[i];
            objectArray[i] = this.values[i];
        }
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void remove(String string) {
        int n = this.get(string);
        if (n >= 0) {
            this.values[n] = null;
            this.removeNullValues(n);
        }
    }

    public void remove(SortedArray sortedArray) {
        int n = this.size;
        int n2 = this.size;
        for (int i = sortedArray.size - 1; i >= 0; --i) {
            int n3 = this.get(sortedArray.keys[i]);
            if (n3 >= 0) {
                this.values[n3] = null;
                n = n3;
                this.size = n3;
                continue;
            }
            this.size = -1 - n3;
        }
        this.size = n2;
        if (n < this.size) {
            this.removeNullValues(n);
        }
    }

    void removeNullValues(int n) {
        for (int i = n; i < this.size; ++i) {
            if (this.values[i] == null) continue;
            this.keys[n] = this.keys[i];
            this.values[n++] = this.values[i];
        }
        this.clear(n);
    }

    public int get(String string) {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = 0;
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            n3 = this.keys[n4].compareTo(string);
            if (n3 > 0) {
                n2 = n4 - 1;
                continue;
            }
            if (n3 < 0) {
                n = n4 + 1;
                continue;
            }
            return n4;
        }
        return -1 - n;
    }

    public String toString() {
        String string = "SortedArray";
        for (int i = 0; i < this.size; ++i) {
            string = string + "{" + this.keys[i] + "/" + this.values[i] + "},";
        }
        return string;
    }
}

