/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import jgame.JGPoint;
import jgame.impl.EngineLogic;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;

class JREEngine
implements MouseListener,
MouseMotionListener,
FocusListener,
KeyListener,
WindowListener {
    JGEngineInterface eng;
    EngineLogic el;
    Component canvas;
    Window my_win;
    Frame my_frame;
    boolean win_decoration = true;
    boolean create_frame = true;
    boolean has_focus = false;
    Point mousepos = new Point(0, 0);
    boolean[] mousebutton = new boolean[]{false, false, false, false};
    boolean mouseinside = false;
    boolean[] keymap = new boolean[259];
    int lastkey = 0;
    char lastkeychar = '\u0000';
    int wakeup_key = 0;
    Hashtable channels = new Hashtable();
    Hashtable lastplayed = new Hashtable();
    Hashtable islooping = new Hashtable();
    Hashtable clipstriggered = new Hashtable();
    int unnamedchnr = 0;
    int nr_unnamedch = 6;
    boolean audioenabled = true;
    String localstorefile;
    Hashtable localstore = new Hashtable();
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;
    static /* synthetic */ Class class$java$awt$Frame;

    public JREEngine(EngineLogic engineLogic, JGEngineInterface jGEngineInterface) {
        this.el = engineLogic;
        this.eng = jGEngineInterface;
    }

    void updateMouse(MouseEvent mouseEvent, boolean bl, boolean bl2, boolean bl3) {
        this.mousepos = mouseEvent.getPoint();
        this.mousepos.x = (int)((double)(this.mousepos.x - this.el.canvas_xofs) / this.el.x_scale_fac);
        this.mousepos.y = (int)((double)(this.mousepos.y - this.el.canvas_yofs) / this.el.y_scale_fac);
        this.mouseinside = bl3;
        int n = 0;
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            n = 1;
        }
        if ((mouseEvent.getModifiers() & 8) != 0) {
            n = 2;
        }
        if ((mouseEvent.getModifiers() & 4) != 0) {
            n = 3;
        }
        if (n == 0) {
            return;
        }
        if (bl) {
            this.mousebutton[n] = true;
            this.keymap[255 + n] = true;
            if (!(this.wakeup_key != -1 && this.wakeup_key != 255 + n || this.eng.isRunning())) {
                this.eng.start();
                this.mousebutton[n] = false;
                this.keymap[255 + n] = false;
            }
        }
        if (bl2) {
            this.mousebutton[n] = false;
            this.keymap[255 + n] = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.has_focus) {
            this.canvas.requestFocus();
        }
        this.updateMouse(mouseEvent, false, false, true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateMouse(mouseEvent, false, false, true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateMouse(mouseEvent, false, false, false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updateMouse(mouseEvent, true, false, true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateMouse(mouseEvent, false, true, true);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateMouse(mouseEvent, false, false, true);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateMouse(mouseEvent, false, false, true);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.has_focus = true;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.has_focus = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (n >= 0 && n < 256) {
            this.keymap[n] = true;
            this.lastkey = n;
            this.lastkeychar = c;
            if (!(this.wakeup_key != -1 && this.wakeup_key != n || this.eng.isRunning())) {
                this.eng.start();
                this.keymap[n] = false;
            }
        }
        if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 27 && !this.eng.isApplet()) {
            System.exit(0);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (n >= 0 && n < 256) {
            this.keymap[n] = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("Closed");
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Window closed; exiting.");
        this.closeWindow();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void clearKeymap() {
        for (int i = 0; i < 259; ++i) {
            this.keymap[i] = false;
        }
    }

    public void wakeUpOnKey(int n) {
        this.wakeup_key = n;
    }

    public JGPoint getMousePos() {
        return new JGPoint(this.mousepos.x, this.mousepos.y);
    }

    public int getMouseX() {
        return this.mousepos.x;
    }

    public int getMouseY() {
        return this.mousepos.y;
    }

    public boolean getMouseButton(int n) {
        return this.mousebutton[n];
    }

    public void clearMouseButton(int n) {
        this.mousebutton[n] = false;
    }

    public void setMouseButton(int n) {
        this.mousebutton[n] = true;
    }

    public boolean getMouseInside() {
        return this.mouseinside;
    }

    public boolean getKey(int n) {
        return this.keymap[n];
    }

    public void clearKey(int n) {
        this.keymap[n] = false;
    }

    public void setKey(int n) {
        this.keymap[n] = true;
    }

    public int getLastKey() {
        return this.lastkey;
    }

    public char getLastKeyChar() {
        return this.lastkeychar;
    }

    public void clearLastKey() {
        this.lastkey = 0;
        this.lastkeychar = '\u0000';
    }

    public static String getKeyDescStatic(int n) {
        if (n == 32) {
            return "space";
        }
        if (n == 0) {
            return "(none)";
        }
        if (n == 10) {
            return "enter";
        }
        if (n == 27) {
            return "escape";
        }
        if (n == 38) {
            return "cursor up";
        }
        if (n == 40) {
            return "cursor down";
        }
        if (n == 37) {
            return "cursor left";
        }
        if (n == 39) {
            return "cursor right";
        }
        if (n == 16) {
            return "shift";
        }
        if (n == 18) {
            return "alt";
        }
        if (n == 17) {
            return "control";
        }
        if (n == 256) {
            return "left mouse button";
        }
        if (n == 257) {
            return "middle mouse button";
        }
        if (n == 258) {
            return "right mouse button";
        }
        if (n == 27) {
            return "escape";
        }
        if (n >= 33 && n <= 95) {
            return new String(new char[]{(char)n});
        }
        return "keycode " + n;
    }

    public static int getKeyCodeStatic(String string) {
        if ((string = string.toLowerCase().trim()).equals("space")) {
            return 32;
        }
        if (string.equals("escape")) {
            return 27;
        }
        if (string.equals("(none)")) {
            return 0;
        }
        if (string.equals("enter")) {
            return 10;
        }
        if (string.equals("cursor up")) {
            return 38;
        }
        if (string.equals("cursor down")) {
            return 40;
        }
        if (string.equals("cursor left")) {
            return 37;
        }
        if (string.equals("cursor right")) {
            return 39;
        }
        if (string.equals("shift")) {
            return 16;
        }
        if (string.equals("alt")) {
            return 18;
        }
        if (string.equals("control")) {
            return 17;
        }
        if (string.equals("left mouse button")) {
            return 256;
        }
        if (string.equals("middle mouse button")) {
            return 257;
        }
        if (string.equals("right mouse button")) {
            return 258;
        }
        if (string.startsWith("keycode")) {
            return Integer.parseInt(string.substring(7));
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        return 0;
    }

    public String getConfigPath(String string) {
        File file;
        if (this.eng.isApplet()) {
            return null;
        }
        try {
            file = new File(System.getProperty("user.home"), ".jgame");
        }
        catch (Exception exception) {
            return null;
        }
        if (!file.exists() && !file.mkdir()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, string);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!file2.canRead()) {
            return null;
        }
        if (!file2.canWrite()) {
            return null;
        }
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static Method getMethod(Class clazz, String string, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] instanceof Boolean ? Boolean.TYPE : (objectArray[i] instanceof Character ? Character.TYPE : (objectArray[i] instanceof Integer ? Integer.TYPE : (objectArray[i] instanceof Double ? Double.TYPE : (objectArray[i] instanceof Float ? Float.TYPE : (objectArray[i] instanceof GraphicsConfiguration ? (class$java$awt$GraphicsConfiguration == null ? JREEngine.class$("java.awt.GraphicsConfiguration") : class$java$awt$GraphicsConfiguration) : objectArray[i].getClass())))));
        }
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    boolean tryMethod(Object object, String string, Object[] objectArray) {
        try {
            Method method = JREEngine.getMethod(object.getClass(), string, objectArray);
            if (method == null) {
                return false;
            }
            method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof JGameError) {
                this.eng.exitEngine(this.eng.dbgExceptionToString(throwable));
            } else {
                this.eng.dbgShowException("MAIN", throwable);
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unexpected exception:");
            illegalAccessException.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean existsMethod(Class clazz, String string, Object[] objectArray) {
        return JREEngine.getMethod(clazz, string, objectArray) != null;
    }

    static boolean existsMethod(Class clazz, String string, Class[] classArray) {
        try {
            clazz.getMethod(string, classArray);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    void createWindow(Component component, boolean bl) {
        if (JREEngine.existsMethod(class$java$awt$Frame == null ? (class$java$awt$Frame = JREEngine.class$("java.awt.Frame")) : class$java$awt$Frame, "setUndecorated", new Class[]{Boolean.TYPE})) {
            this.my_win = new Frame();
            this.tryMethod(this.my_win, "setUndecorated", new Object[]{new Boolean(!bl)});
        } else if (!bl) {
            this.my_frame = new Frame();
            this.my_win = new Window(this.my_frame);
            this.tryMethod(this.my_win, "setFocusableWindowState", new Object[]{new Boolean(true)});
            this.my_frame.setVisible(true);
        } else {
            this.my_win = new Frame();
        }
        this.my_win.setLayout(new FlowLayout(1, 0, 0));
        this.setWindowSize(bl);
        this.my_win.add(component);
        this.my_win.addWindowListener(this);
    }

    void setWindowSize(boolean bl) {
        if (!bl) {
            this.my_win.setSize(this.el.winwidth, this.el.winheight);
        } else {
            Insets insets = this.my_win.getInsets();
            this.my_win.setSize(this.el.winwidth + insets.left + insets.right, this.el.winheight + insets.top + insets.bottom);
        }
    }

    void closeWindow() {
        this.my_win.setVisible(false);
        System.exit(0);
    }

    void audioNewFrame() {
        this.clipstriggered = new Hashtable();
    }

    public void enableAudio() {
        if (this.audioenabled) {
            return;
        }
        this.audioenabled = true;
        Enumeration enumeration = this.channels.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable;
            AudioClip audioClip;
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.islooping.get(string);
            if (string2 == null || (audioClip = (AudioClip)(hashtable = (Hashtable)this.channels.get(string)).get(string2)) == null) continue;
            audioClip.loop();
        }
    }

    public void disableAudio() {
        if (!this.audioenabled) {
            return;
        }
        this.audioenabled = false;
        Enumeration enumeration = this.channels.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable;
            AudioClip audioClip;
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.lastplayed.get(string);
            if (string2 == null || (audioClip = (AudioClip)(hashtable = (Hashtable)this.channels.get(string)).get(string2)) == null) continue;
            audioClip.stop();
        }
    }

    private AudioClip loadAudioClip(Applet applet, String string) {
        URL uRL = this.getClass().getResource((String)this.el.audioclips.get(string));
        AudioClip audioClip = this.eng.isApplet() ? applet.getAudioClip(uRL) : Applet.newAudioClip(uRL);
        return audioClip;
    }

    public String lastPlayedAudio(String string) {
        return (String)this.lastplayed.get(string);
    }

    public void playAudio(Applet applet, String string) {
        if (this.clipstriggered.containsKey(string)) {
            return;
        }
        this.clipstriggered.put(string, "yes");
        this.playAudio(applet, "_unnamed" + this.unnamedchnr, string, false);
        this.unnamedchnr = (this.unnamedchnr + 1) % this.nr_unnamedch;
    }

    public void playAudio(Applet applet, String string, String string2, boolean bl) {
        AudioClip audioClip = null;
        Hashtable<String, AudioClip> hashtable = (Hashtable<String, AudioClip>)this.channels.get(string);
        String string3 = (String)this.lastplayed.get(string);
        if (hashtable != null) {
            audioClip = (AudioClip)hashtable.get(string2);
        } else {
            hashtable = new Hashtable<String, AudioClip>();
            this.channels.put(string, hashtable);
        }
        if (audioClip == null) {
            audioClip = this.loadAudioClip(applet, string2);
            hashtable.put(string2, audioClip);
        }
        boolean bl2 = true;
        if (string3 != null && !string3.equals(string2)) {
            AudioClip audioClip2 = (AudioClip)hashtable.get(string3);
            if (this.audioenabled) {
                audioClip2.stop();
            }
        } else {
            String string4 = (String)this.islooping.get(string);
            bl2 = !bl || string4 == null || !string4.equals(string2);
        }
        if (bl) {
            if (bl2) {
                if (this.audioenabled) {
                    audioClip.loop();
                }
                this.islooping.put(string, string2);
            }
        } else {
            if (this.audioenabled) {
                audioClip.play();
            }
            this.islooping.remove(string);
        }
        this.lastplayed.put(string, string2);
    }

    public void stopAudio(String string) {
        String string2 = (String)this.lastplayed.get(string);
        if (string2 == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.channels.get(string);
        AudioClip audioClip = (AudioClip)hashtable.get(string2);
        if (audioClip != null && this.audioenabled) {
            audioClip.stop();
        }
        this.lastplayed.remove(string);
        this.islooping.remove(string);
    }

    public void stopAudio() {
        Enumeration enumeration = this.channels.keys();
        while (enumeration.hasMoreElements()) {
            this.stopAudio((String)enumeration.nextElement());
        }
    }

    void storeInit() {
        this.localstorefile = this.getConfigPath(this.eng.getClass().getName() + ".store");
        if (this.localstorefile == null) {
            return;
        }
        try {
            Object object;
            BufferedReader bufferedReader;
            Object object2;
            try {
                object2 = new File(this.localstorefile);
                if (!((File)object2).exists()) {
                    return;
                }
                bufferedReader = new BufferedReader(new FileReader((File)object2));
            }
            catch (AccessControlException accessControlException) {
                object = new URL(this.localstorefile);
                bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            }
            while ((object2 = bufferedReader.readLine()) != null) {
                object = ((String)object2).substring(0, ((String)object2).indexOf("\t"));
                String string = ((String)object2).substring(((String)object2).indexOf("\t") + 1);
                String string2 = string.substring(0, string.indexOf("\t"));
                String string3 = string.substring(string.indexOf("\t") + 1);
                if (string2.equals("int")) {
                    this.localstore.put(object, new Integer(Integer.parseInt(string3)));
                    continue;
                }
                if (string2.equals("double")) {
                    this.localstore.put(object, new Double(Double.parseDouble(string3)));
                    continue;
                }
                if (string2.equals("String")) {
                    this.localstore.put(object, string3);
                    continue;
                }
                throw new JGameError("Unknown type " + string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new JGameError("Error reading file '" + this.localstorefile + "'.", false);
        }
    }

    private void storeWrite() {
        try {
            if (this.localstorefile == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(this.localstorefile)));
            Enumeration enumeration = this.localstore.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.localstore.get(string);
                if (v instanceof Integer) {
                    printWriter.println(string + "\tint\t" + v);
                    continue;
                }
                if (v instanceof Double) {
                    printWriter.println(string + "\tdouble\t" + v);
                    continue;
                }
                if (!(v instanceof String)) continue;
                printWriter.println(string + "\tString\t" + v);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new JGameError("Error writing file '" + this.localstorefile + "'.", false);
        }
    }

    public void storeWriteInt(String string, int n) {
        this.localstore.put(string, new Integer(n));
        this.storeWrite();
    }

    public void storeWriteDouble(String string, double d) {
        this.localstore.put(string, new Double(d));
        this.storeWrite();
    }

    public void storeWriteString(String string, String string2) {
        this.localstore.put(string, string2);
        this.storeWrite();
    }

    public void storeRemove(String string) {
        this.localstore.remove(string);
        this.storeWrite();
    }

    public boolean storeExists(String string) {
        return this.localstore.containsKey(string);
    }

    public int storeReadInt(String string, int n) {
        if (!this.localstore.containsKey(string)) {
            return n;
        }
        return (Integer)this.localstore.get(string);
    }

    public double storeReadDouble(String string, double d) {
        if (!this.localstore.containsKey(string)) {
            return d;
        }
        return (Double)this.localstore.get(string);
    }

    public String storeReadString(String string, String string2) {
        if (!this.localstore.containsKey(string)) {
            return string2;
        }
        return (String)this.localstore.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

