/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class CavernsOfFire
extends StdGame {
    boolean do_scroll = false;
    boolean large_pf = false;
    Player player = null;
    int lavalevel = 0;
    int nr_pads = 0;
    int non_preferred_monster = 0;
    int lavaarea = 0;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Please supply \"scroll\" or \"noscroll\" as first argument.");
            System.exit(0);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray[0].equals("scroll")) {
            bl = true;
            bl2 = false;
        }
        new CavernsOfFire(CavernsOfFire.parseSizeArgs(stringArray, 1), bl, bl2);
    }

    public CavernsOfFire() {
        this.initEngineApplet();
    }

    public CavernsOfFire(JGPoint jGPoint, boolean bl, boolean bl2) {
        this.do_scroll = bl;
        this.large_pf = bl2;
        this.initEngine(jGPoint.x, jGPoint.y);
    }

    public void initCanvas() {
        if (this.isApplet()) {
            boolean bl = this.do_scroll = this.getParameter("scrolling") != null;
        }
        if (this.isMidlet()) {
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 5, 5, 5);
            this.setCanvasSettings(18, 18, 16, 16, null, null, null);
            this.do_scroll = true;
        } else if (this.do_scroll && !this.large_pf) {
            this.setCanvasSettings(20, 15, 16, 16, null, null, null);
        } else {
            this.setCanvasSettings(40, 30, 16, 16, null, null, null);
        }
    }

    public void initGame() {
        this.defineMedia("caverns_of_fire.tbl");
        this.setVideoSyncedUpdate(true);
        if (!this.isMidlet()) {
            this.setFrameRate(40.0, 1.0);
        } else {
            this.setFrameRate(12.0, 1.0);
            this.setGameSpeed(2.5);
        }
        this.startgame_ticks = 150;
        this.lifelost_ingame = true;
        this.setTileSettings("", 1, 0);
        if (this.large_pf) {
            this.setPFSize(100, 40);
        } else {
            this.setPFSize(40, 30);
        }
    }

    public void defineLevel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        int n7;
        int n8;
        int n9;
        this.setBGImage("cave_bg" + this.stage % 4);
        double d11 = 1.0;
        double d12 = 1.0;
        if (this.large_pf) {
            d11 = 2.5;
            d12 = 1.6666666666666667;
        }
        double d13 = d12 * (double)this.random(7, this.level < 8 ? 8 + 5 * this.level / 4 : 18, 1);
        this.lavalevel = (int)(d12 * (double)this.random(0, (int)Math.min(d13 - 2.0, this.level < 7 ? (double)(1 + this.level) : 8.0), 1));
        this.fillBG(".");
        for (n9 = 0; n9 < 500; ++n9) {
            this.setTile(this.random(0, this.pfTilesX(), 1), this.random(0, this.pfTilesY(), 1), ",");
        }
        this.removeObjects(null, 0);
        this.player = new Player(16.0, this.pfHeight() / 2);
        this.setViewOffset((int)this.player.x, (int)this.player.y, true);
        int n10 = 0;
        block1: while (true) {
            n9 = 30;
            n8 = this.pfTilesY();
            n7 = 0;
            d10 = this.random(0.0, 6.0);
            d9 = this.random(1.5, 4.0);
            d8 = d13 / 10.0 * this.random(2.5, 3.5);
            d7 = this.random(0.5, 1.5);
            d6 = d13 / 10.0 * this.random(0.5, 2.0);
            d5 = this.random(0.0, 6.0);
            d4 = this.random(1.5, 4.0);
            d3 = d13 / 10.0 * this.random(2.5, 3.5);
            d2 = this.random(0.5, 1.5);
            d = d13 / 10.0 * this.random(0.5, 2.0);
            for (n6 = 0; n6 < this.pfTilesX(); ++n6) {
                n5 = (int)(d13 / 2.0 + d8 * Math.sin(d10 + (double)n6 / d9) + d6 * Math.sin(d10 + (double)n6 / d7));
                int n11 = (int)(d13 / 2.0 + d3 * Math.sin(d5 + (double)(n6 - 2) / d4) + d * Math.sin(d5 + (double)(n6 - 2) / d2));
                int n12 = (int)(d13 / 2.0 + d3 * Math.sin(d5 + (double)(n6 - 1) / d4) + d * Math.sin(d5 + (double)(n6 - 1) / d2));
                int n13 = (int)(d13 / 2.0 + d3 * Math.sin(d5 + (double)n6 / d4) + d * Math.sin(d5 + (double)n6 / d2));
                int n14 = (int)(d13 / 2.0 + d3 * Math.sin(d5 + (double)(n6 + 1) / d4) + d * Math.sin(d5 + (double)(n6 + 1) / d2));
                int n15 = (int)(d13 / 2.0 + d3 * Math.sin(d5 + (double)(n6 + 2) / d4) + d * Math.sin(d5 + (double)(n6 + 2) / d2));
                double d14 = Math.min(this.pfTilesY() - n5 - n11, Math.min(this.pfTilesY() - n5 - n12, Math.min(this.pfTilesY() - n5 - n13, Math.min(this.pfTilesY() - n5 - n14, this.pfTilesY() - n5 - n15))));
                if (d14 < 4.0) continue block1;
                if (n6 > 4) {
                    n9 = (int)Math.min((double)n9, d14);
                }
                n8 = Math.min(n8, this.pfTilesY() - n13);
                n7 = Math.max(n7, n5);
                n10 = n7 - n8;
            }
            break;
        }
        for (n6 = 0; n6 < this.pfTilesX(); ++n6) {
            n5 = 0;
            while ((double)n5 < d13 / 2.0 + d8 * Math.sin(d10 + (double)n6 / d9) + d6 * Math.sin(d10 + (double)n6 / d7)) {
                this.setTile(n6, n5, "#");
                ++n5;
            }
            n5 = 0;
            while ((double)n5 < d13 / 2.0 + d3 * Math.sin(d5 + (double)n6 / d4) + d * Math.sin(d5 + (double)n6 / d2)) {
                this.setTile(n6, this.pfTilesY() - n5, "#");
                ++n5;
            }
        }
        this.setTiles(0, this.pfTilesY() / 2 - 1, new String[]{"...", ".,.", "..,", ",.."});
        for (n8 = this.lavalevel = this.pfTilesY() - this.lavalevel; n8 < this.pfTilesY(); ++n8) {
            for (n7 = 0; n7 < this.pfTilesX(); ++n7) {
                if (this.and(this.getTileCid(n7, n8), 1)) continue;
                this.setTile(n7, n8, this.random(0.0, 1.0) > 0.5 ? "<" : ">");
            }
        }
        this.nr_pads = 0;
        while (true) {
            n7 = 1;
            n4 = 102;
            for (n3 = 0; n3 < (this.large_pf ? 7 : 4); ++n3) {
                JGPoint jGPoint;
                block10: while (true) {
                    int n16 = -11 + n4 / 18;
                    if (n4 > 100) {
                        jGPoint = new JGPoint(this.random(this.pfTilesX() - 9, this.pfTilesX() - 2, 1), this.pfTilesY() - 1);
                        n16 = -12;
                    } else {
                        jGPoint = new JGPoint(this.random(4, this.pfTilesX() - 2, 1), this.pfTilesY() - 1);
                    }
                    if (n4-- <= 0) break;
                    n7 = 1;
                    for (n2 = 0; n2 > -12 - (this.large_pf ? 5 : 0); --n2) {
                        if (this.and(this.getTileCid(jGPoint, 0, n2), 6) || this.and(this.getTileCid(jGPoint, 1, n2), 6)) continue block10;
                        if (this.and(this.getTileCid(jGPoint, 0, n2) | this.getTileCid(jGPoint, 1, n2), 1) || n7 != 1 || n2 < n16) continue;
                        n7 = n2;
                    }
                    if (n7 != 1) break;
                }
                if (n7 >= 1) continue;
                if (jGPoint.y + n7 == this.lavalevel - 1) {
                    --n7;
                }
                if (jGPoint.y + n7 == this.lavalevel - 2) {
                    --n7;
                }
                this.setTiles(jGPoint.x, jGPoint.y + n7, new String[]{"[]", "##", "##"});
                ++this.nr_pads;
            }
            if (this.nr_pads >= (this.large_pf ? 4 : 2)) break;
            for (n3 = 0; n3 < this.pfTilesX(); ++n3) {
                if (!this.and(this.getTileCid(n3, this.lavalevel), 2)) continue;
                this.setTile(n3, this.lavalevel, ".");
            }
            ++this.lavalevel;
        }
        for (n7 = 0; n7 < this.pfTilesY(); ++n7) {
            for (n4 = 0; n4 < this.pfTilesX(); ++n4) {
                if ((this.getTileCid(n4, n7) & 7) == 1) {
                    n3 = this.getTileCid(n4, n7 - 1) & 1 | (this.getTileCid(n4, n7 + 1) & 1) * 2 | (this.getTileCid(n4 - 1, n7) & 1) * 4 | (this.getTileCid(n4 + 1, n7) & 1) * 8;
                    this.setTile(n4, n7, "#" + (15 - n3));
                    continue;
                }
                if (!this.and(this.getTileCid(n4, n7), 2) || (n3 = (this.getTileCid(n4, n7 - 1) == 1 ? 1 : 0) | (this.getTileCid(n4, n7 + 1) == 1 ? 2 : 0) | (this.getTileCid(n4 - 1, n7) == 1 ? 4 : 0) | (this.getTileCid(n4 + 1, n7) == 1 ? 8 : 0)) == 0) continue;
                this.setTile(n4, n7, "<" + n3);
            }
        }
        double[][] dArrayArray = new double[][]{{0.4, 0.5, 0.7, 1.2}, {0.5, 0.6, 0.8, 0.9}, {0.5, 0.6, 0.8, 0.8}, {0.6, 0.7, 1.0, 0.7}};
        this.lavaarea = 0;
        for (n4 = 0; n4 < this.pfTilesX(); ++n4) {
            if (!this.and(this.getTileCid(n4, this.lavalevel), 2)) continue;
            ++this.lavaarea;
        }
        this.lavaarea = (int)((double)this.lavaarea / d11);
        n4 = 0;
        if (n9 <= 13) {
            n4 = 1;
        }
        if (n9 <= 10) {
            n4 = 2;
        }
        if (n9 <= 8) {
            n4 = 3;
        }
        if (n9 <= 6) {
            n4 = 4;
        }
        if (n9 <= 5) {
            n4 = 5;
        }
        if (n10 > -6) {
            ++n4;
        }
        if (n10 > -1) {
            ++n4;
        }
        if ((n3 = this.lavaarea / 4 + n4) > 10) {
            n3 = 10;
        }
        int n17 = 0;
        n2 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 5 + this.level - n3;
        boolean bl = false;
        while (true) {
            double d15;
            int n21;
            n = this.level;
            if (this.level >= 0) {
                while ((n = this.random(0, 3, 1)) == this.non_preferred_monster) {
                }
            }
            if ((n21 = (int)((double)n20 / (d15 = dArrayArray[n4 / 2][n]))) <= 0) break;
            if (n21 > 10) {
                n21 = 10;
                this.non_preferred_monster = n;
            }
            if (!bl) {
                this.non_preferred_monster = n;
            }
            n20 = (int)((double)n20 - d15 * (double)n21);
            if (n == 0) {
                n17 += n21;
            }
            if (n == 1) {
                n2 += n21;
            }
            if (n == 2) {
                n18 += n21;
            }
            if (n == 3) {
                n19 += n21;
            }
            bl = true;
        }
        n = 0;
        while ((double)n < (double)n17 * d11) {
            JGPoint jGPoint;
            while (this.and(this.getTileCid(jGPoint = new JGPoint(this.random(5, this.pfTilesX() - 1, 1), this.random(0, this.pfTilesY(), 1)), 0, 0), 1)) {
            }
            new Coil(jGPoint.x * this.tileWidth(), (double)(jGPoint.y * this.tileHeight()), 0, this.random(-1, 1, 2), 4.0);
            ++n;
        }
        n = 0;
        while ((double)n < (double)n2 * d11) {
            JGPoint jGPoint;
            while (this.and(this.getTileCid(jGPoint = new JGPoint(this.random(9, this.pfTilesX() - 1, 1), this.random(0, this.pfTilesY(), 1)), 0, 0), 1) || this.and(this.getTileCid(jGPoint, 1, 0), 1) || this.and(this.getTileCid(jGPoint, -1, 0), 1) || this.and(this.getTileCid(jGPoint, 0, 1), 1) || this.and(this.getTileCid(jGPoint, 0, -1), 1)) {
            }
            new Jelly(jGPoint.x * this.tileWidth(), jGPoint.y * this.tileHeight(), this.random(-1, 1, 2), 2.5);
            ++n;
        }
        n = 0;
        while ((double)n < (double)n18 * d11) {
            JGPoint jGPoint = new JGPoint(this.random(9, this.pfTilesX() - 1, 1), 0);
            while (this.and(this.getTileCid(jGPoint, 0, 0), 1)) {
                ++jGPoint.y;
            }
            new Bat(jGPoint.x * this.tileWidth(), jGPoint.y * this.tileHeight(), 1, 4.0);
            ++n;
        }
        n = 0;
        while ((double)n < (double)n19 * d11 / 2.0) {
            JGPoint jGPoint = new JGPoint(this.random(5, this.pfTilesX() - 1, 1), this.pfTilesY() - 1);
            while (this.and(this.getTileCid(jGPoint, 0, 0), 1)) {
                --jGPoint.y;
            }
            new Tank(jGPoint.x * this.tileWidth(), jGPoint.y * this.tileHeight(), 1, 0.6);
            ++n;
        }
        n = 0;
        while ((double)n < (double)n19 * d11 / 2.0) {
            JGPoint jGPoint = new JGPoint(this.random(5, this.pfTilesX() - 1, 1), 0);
            while (this.and(this.getTileCid(jGPoint, 0, 0), 1)) {
                ++jGPoint.y;
            }
            new Tank(jGPoint.x * this.tileWidth(), jGPoint.y * this.tileHeight(), -1, 0.6);
            ++n;
        }
    }

    public void initNewGame(int n) {
        this.level = 0;
        this.stage = 0;
        this.score = 0;
        this.lives = 5;
    }

    public void incrementLevel() {
        if (this.level < 15) {
            ++this.level;
        }
        ++this.stage;
    }

    public void initNewLife() {
        this.player = new Player(16.0, this.pfHeight() / 2);
    }

    public void doFrameStartLevel() {
        if (this.seqtimer == 1.0) {
            this.moveObjects();
        }
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(28, 1);
        this.checkCollision(20, 2);
        this.checkBGCollision(1, 31);
        JGPoint jGPoint = new JGPoint(this.random(0, this.pfTilesX() - 1, 1), this.lavalevel);
        if (this.and(this.getTileCid(jGPoint, 0, 0), 2) && this.and(this.getTileCid(jGPoint, 1, 0), 2)) {
            double d = (double)(jGPoint.x * this.tileWidth()) + this.random(0.0, 15.0);
            double d2 = jGPoint.y * this.tileHeight();
            if (this.checkTime(15)) {
                new Fireball(d, d2, this.random(-1.0, 1.0), this.random(-3.5, -1.5), false, -2);
            } else {
                new Fireball(d, d2, 0.0, -0.5, !(this.random(0.0, 1.0) > 0.5), this.random(3, 11, 1));
            }
        }
        if (this.nr_pads == 0 || this.countObjects(null, 4) == 0 && this.lavaarea <= 12 || this.getKey(76)) {
            this.levelDone();
        }
        if (this.player != null) {
            int n = (int)this.player.x - this.viewWidth() / 2;
            int n2 = (int)this.player.y - this.viewHeight() / 2;
            this.setViewOffset((int)((double)n + this.player.xspeed * 5.0), (int)((double)n2 + this.player.yspeed * 5.0), false);
        }
    }

    public void doFrameLevelDone() {
        this.moveObjects("zexplo", 0);
    }

    public void doFrameStartGame() {
        this.moveObjects("zexplo", 0);
    }

    public void startLifeLost() {
        this.player.remove();
    }

    public void doFrameLifeLost() {
        if (this.checkTime(5)) {
            new Explo(this.player.x + this.random(-10.0, 10.0), this.player.y + this.random(-10.0, 10.0));
        }
    }

    public class Explo
    extends JGObject {
        public Explo(double d, double d2) {
            super("zexplo", true, d, d2, 0, null, 17);
        }

        public void paint() {
            CavernsOfFire.this.setColor(CavernsOfFire.this.cycleColor(new JGColor[]{JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta, JGColor.red}, CavernsOfFire.this.gametime, 0.25));
            CavernsOfFire.this.setStroke(1.0);
            for (int i = 0; i < 2; ++i) {
                double d = CavernsOfFire.this.random(7.0, 10.0 + this.expiry);
                double d2 = 20.0 - this.expiry;
                CavernsOfFire.this.drawOval((int)(this.x + CavernsOfFire.this.random(-d2, d2)), (int)(this.y + CavernsOfFire.this.random(-d2, d2)), (int)d, (int)d, true, true);
            }
        }
    }

    public class Fireball
    extends JGObject {
        boolean is_small;
        int invulnerability;

        public Fireball(double d, double d2, double d3, double d4, boolean bl, int n) {
            super("fireball", true, d, d2, 16, bl ? "fireball_sm" : "fireball", n);
            this.invulnerability = (int)(10.0 / CavernsOfFire.this.getGameSpeed());
            this.setSpeed(d3, d4);
            this.is_small = bl;
        }

        public void move() {
            this.yspeed += 0.03 + (this.is_small ? 0.03 : 0.0);
            --this.invulnerability;
        }

        public void hit_bg(int n, int n2, int n3) {
            if (!this.is_small && this.invulnerability < 0 && !Fireball.and(n, 2)) {
                this.remove();
                for (int i = 0; i < (CavernsOfFire.this.isMidlet() ? 4 : 7); ++i) {
                    new Fireball(this.x, this.y, this.xspeed + CavernsOfFire.this.random(-2.0, 2.0), CavernsOfFire.this.random(-2.0, 1.0), true, CavernsOfFire.this.random(20, 50, 1));
                }
            }
        }
    }

    public class EnemyBullet
    extends JGObject {
        public EnemyBullet(double d, double d2, double d3, double d4) {
            super("Enemybullet", true, d, d2, 8, "bomb", -2);
            this.setSpeed(d3, d4);
        }

        public void move() {
            this.yspeed += 0.05;
        }

        public void hit_bg(int n) {
            this.remove();
        }
    }

    public class Tank
    extends JGObject {
        double speed;
        int move_timer;
        int shoot_timer;

        public Tank(double d, double d2, int n, double d3) {
            super("tank", true, d, d2, 4, null);
            this.move_timer = CavernsOfFire.this.random(100, 500, 1);
            this.shoot_timer = 0;
            this.speed = d3;
            this.ydir = n;
            this.xdir = CavernsOfFire.this.random(-1, 1, 2);
            this.setTileBBox(2, n * 8, 10, 14);
        }

        public void move() {
            String string = "tank_";
            string = string + (this.ydir > 0 ? "u" : "d");
            string = string + (this.xdir > 0 ? "r" : "l");
            if ((double)this.xdir * this.yspeed > 0.5) {
                string = string + "d";
            }
            if ((double)this.xdir * this.yspeed < -0.5) {
                string = string + "u";
            }
            this.setGraphic(string);
            if (this.move_timer > 0) {
                JGPoint jGPoint;
                this.startAnim();
                if (--this.move_timer <= 0) {
                    this.shoot_timer = 100;
                }
                this.yspeed = Tank.and(CavernsOfFire.this.getTileCid(jGPoint = this.getCenterTile(), 0, 0), 1) || Tank.and(CavernsOfFire.this.getTileCid(jGPoint, this.xdir, 0), 1) ? (this.yspeed > 0.0 ? 0.0 : (this.yspeed += -0.05 * this.speed)) : (this.yspeed < 0.0 ? 0.0 : (this.yspeed += 0.1 * this.speed));
                this.xspeed = this.speed * 1.2 - Math.abs(this.yspeed);
                if (this.xspeed < 0.1) {
                    this.xspeed = 0.1;
                }
                if (this.x <= 8.0 && this.xdir < 0) {
                    this.xdir = 1;
                }
                if (this.x > (double)(CavernsOfFire.this.pfWidth() - 24) && this.xdir > 0) {
                    this.xdir = -1;
                }
            } else {
                this.stopAnim();
                if (--this.shoot_timer <= 0) {
                    this.move_timer = CavernsOfFire.this.random(300, 600, 1);
                    this.xdir = -this.xdir;
                }
                this.xspeed = 0.0;
                this.yspeed = 0.0;
                if (this.shoot_timer % 20 == 10) {
                    double d = CavernsOfFire.this.atan2(CavernsOfFire.this.player.x - this.x, CavernsOfFire.this.player.y - this.y);
                    if (this.y < CavernsOfFire.this.player.y) {
                        new EnemyBullet(this.x, this.y, 2.0 * Math.sin(d), 0.5 * Math.cos(d));
                    } else {
                        new EnemyBullet(this.x, this.y, 2.0 * Math.sin(d), 5.5 * Math.cos(d));
                    }
                }
            }
        }
    }

    public class Bat
    extends JGObject {
        double speed;
        int orient;
        int delay = 0;

        public Bat(double d, double d2, int n, double d3) {
            super("nat", true, d, d2, 4, "bat_d");
            this.speed = d3;
            this.orient = n;
            this.stopAnim();
        }

        public void move() {
            if (CavernsOfFire.this.player != null) {
                if (Math.abs(CavernsOfFire.this.player.x - this.x) < 100.0 && this.xspeed == 0.0 && this.yspeed == 0.0 && this.delay == 0) {
                    this.delay = CavernsOfFire.this.random(5, 25, 1);
                }
                if (this.delay > 0 && --this.delay == 0) {
                    JGPoint jGPoint = this.getCenterTile();
                    if ((this.y > CavernsOfFire.this.player.y && this.orient == -1 || this.y < CavernsOfFire.this.player.y && this.orient == 1) && (this.x < CavernsOfFire.this.player.x && !Bat.and(CavernsOfFire.this.getTileCid(jGPoint, 1, 0), 1) || this.x >= CavernsOfFire.this.player.x && !Bat.and(CavernsOfFire.this.getTileCid(jGPoint, -1, 0), 1))) {
                        double d = CavernsOfFire.this.atan2(CavernsOfFire.this.player.x - this.x, CavernsOfFire.this.player.y - this.y);
                        if (this.y > CavernsOfFire.this.player.y) {
                            this.xspeed = 2.0 * Math.sin(d);
                            this.yspeed = 7.0 * Math.cos(d);
                        } else {
                            this.xspeed = 2.0 * Math.sin(d);
                            this.yspeed = 0.5 * Math.cos(d);
                        }
                        this.startAnim();
                    } else if (Bat.and(CavernsOfFire.this.getTileCid(jGPoint, 1, 0), 1) && Bat.and(CavernsOfFire.this.getTileCid(jGPoint, -1, 0), 1)) {
                        this.yspeed = this.y > CavernsOfFire.this.player.y ? -7.0 : 0.5;
                        this.startAnim();
                    }
                }
            }
            if (this.xspeed != 0.0 || this.yspeed != 0.0) {
                this.yspeed += 0.07;
            }
        }

        public void hit_bg(int n) {
            int n2;
            this.xspeed = 0.0;
            this.yspeed = 0.0;
            this.snapToGrid(16.0, 16.0);
            JGPoint jGPoint = this.getCenterTile();
            this.orient = -1;
            for (n2 = 0; n2 < 20 && !Bat.and(CavernsOfFire.this.getTileCid(jGPoint, 0, n2), 1); ++n2) {
                if (!Bat.and(CavernsOfFire.this.getTileCid(jGPoint, 0, -n2), 1)) continue;
                this.orient = 1;
                break;
            }
            this.setGraphic("bat_" + (this.orient > 0 ? "d" : "u"));
            this.stopAnim();
            n2 = 0;
            int n3 = 0;
            for (int i = 20; i >= 0; --i) {
                for (int j = -1; j <= 1; j += 2) {
                    if (Bat.and(CavernsOfFire.this.getTileCid(jGPoint, j, -this.orient * (i - 1)), 1) && !Bat.and(CavernsOfFire.this.getTileCid(jGPoint, j, -this.orient * (i - 2)), 1)) {
                        n2 = j;
                        n3 = -this.orient * (i - 2);
                    }
                    if (!Bat.and(CavernsOfFire.this.getTileCid(jGPoint, 0, -this.orient * i), 1) || Bat.and(CavernsOfFire.this.getTileCid(jGPoint, 0, -this.orient * (i - 1)), 1)) continue;
                    n2 = 0;
                    n3 = -this.orient * (i - 1);
                }
            }
            this.x = (jGPoint.x + n2) * CavernsOfFire.this.tileWidth();
            this.y = (jGPoint.y + n3) * CavernsOfFire.this.tileHeight();
        }
    }

    public class Jelly
    extends JGObject {
        double speed;

        public Jelly(double d, double d2, int n, double d3) {
            super("jelly", true, d, d2, 4, null);
            this.setDirSpeed(n, 0, d3, d3 / 10.0);
            this.speed = d3;
        }

        public void move() {
            this.ydir = Math.abs(this.x - CavernsOfFire.this.player.x) < 64.0 ? (this.y > CavernsOfFire.this.player.y ? -1 : 1) : 0;
            this.setGraphic("jelly" + (this.xdir < 0 ? "l" : "r"));
        }

        public void hit_bg(int n) {
            this.xdir = -this.xdir;
            this.ydir = -this.ydir;
        }
    }

    public class Coil
    extends JGObject {
        double accel;

        public Coil(double d, double d2, int n, int n2, double d3) {
            super("coil", true, d, d2, 4, "coil");
            this.setDirSpeed(n, n2, 0.0, d3 / 2.0);
            this.accel = d3;
        }

        public void move() {
            JGPoint jGPoint = this.getCenterTile();
            if (Coil.and(CavernsOfFire.this.getTileCid(jGPoint, 0, this.ydir * 5), 1)) {
                this.ydir = -this.ydir;
                this.yspeed = -this.yspeed;
            }
            if (this.yspeed < this.accel) {
                this.yspeed += this.accel * 0.05;
            }
            this.setAnimSpeed((double)this.ydir * this.yspeed / 5.0);
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(double d, double d2, double d3, double d4) {
            super("bullet", true, d, d2, 2, "bullet", -2);
            this.setSpeed(d3, d4);
        }

        public void move() {
            this.yspeed += 0.1;
        }

        public void hit(JGObject jGObject) {
            this.remove();
            if (!Bullet.and(jGObject.colid, 16)) {
                jGObject.remove();
                CavernsOfFire.this.score = jGObject instanceof Bat ? (CavernsOfFire.this.score += 10) : (jGObject instanceof Tank ? (CavernsOfFire.this.score += 20) : (CavernsOfFire.this.score += 5));
                new Explo(this.x + 8.0, this.y + 8.0);
            }
        }

        public void hit_bg(int n) {
            this.remove();
        }
    }

    public class Player
    extends JGObject {
        int invulnerability;
        int landed;
        int gassing;

        public Player(double d, double d2) {
            super("player", false, d, d2, 1, "ship");
            this.invulnerability = (int)(80.0 / CavernsOfFire.this.getGameSpeed());
            this.landed = 0;
            this.gassing = 0;
        }

        public void move() {
            JGPoint jGPoint = this.getTopLeftTile();
            if (this.xspeed == 0.0 && this.yspeed < 1.0 && jGPoint != null && Player.and(CavernsOfFire.this.getTileCid(jGPoint, 0, 1), 4)) {
                int n = this.landed++;
                if ((double)n > 50.0 / CavernsOfFire.this.getGameSpeed() && CavernsOfFire.this.getTileStr(jGPoint.x, jGPoint.y + 1).equals("[")) {
                    CavernsOfFire.this.setTiles(jGPoint.x, jGPoint.y + 1, new String[]{"()"});
                    --CavernsOfFire.this.nr_pads;
                    CavernsOfFire.this.score += 25;
                }
            } else {
                this.landed = 0;
                this.yspeed += 0.01;
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_down)) {
                    this.yspeed += 0.3;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_left)) {
                    this.xspeed -= 0.3;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_right)) {
                    this.xspeed += 0.3;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_fire) && CavernsOfFire.this.countObjects("bullet", 0) < 7) {
                    CavernsOfFire.this.clearKey(CavernsOfFire.this.key_fire);
                    new Bullet(this.x, this.y, (int)(this.xspeed * 2.5), (int)(this.yspeed * 2.5 - 1.0));
                }
                if (this.x + this.xspeed * gamespeed < 0.0) {
                    this.xspeed = -this.xspeed;
                }
                if (this.x + this.xspeed * gamespeed >= (double)(CavernsOfFire.this.pfWidth() - 16)) {
                    this.xspeed = -this.xspeed;
                }
            }
            if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_up)) {
                this.yspeed -= 0.3;
                if (this.gassing < 4) {
                    ++this.gassing;
                }
            } else if (this.gassing > 0) {
                --this.gassing;
            }
            if (this.invulnerability >= 0) {
                this.setGraphic(this.invulnerability % 4 < 2 ? "ship" : null);
                --this.invulnerability;
            }
        }

        public void hit(JGObject jGObject) {
            if (this.invulnerability < 0) {
                CavernsOfFire.this.lifeLost();
            }
        }

        public void hit_bg(int n, int n2, int n3, int n4, int n5) {
            if (!Player.and(n, 4)) {
                CavernsOfFire.this.lifeLost();
            } else {
                JGPoint jGPoint = new JGPoint(n2, n3);
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        String string = CavernsOfFire.this.getTileStr(n2 + j, n3 + i);
                        if (string.equals("[") || string.equals("(")) {
                            jGPoint.x = n2 + j;
                            jGPoint.y = n3 + i;
                        }
                        if (!string.equals("]") && !string.equals(")")) continue;
                        jGPoint.x = n2 + j - 1;
                        jGPoint.y = n3 + i;
                    }
                }
                double d = jGPoint.x * CavernsOfFire.this.tileWidth() + 8;
                double d2 = jGPoint.y * CavernsOfFire.this.tileHeight() - 16;
                if (Math.abs(d - this.x) + Math.abs(d2 - this.y) > 16.0) {
                    CavernsOfFire.this.lifeLost();
                } else {
                    this.setPos(d, d2);
                    this.setSpeed(0.0, 0.0);
                }
            }
        }

        public void paint() {
            CavernsOfFire.this.setColor(CavernsOfFire.this.cycleColor(new JGColor[]{JGColor.red, JGColor.yellow}, CavernsOfFire.this.timer, 0.5));
            if (this.gassing > 1) {
                CavernsOfFire.this.drawOval((int)this.x + 8, (int)this.y + 16 + this.gassing, 3 * this.gassing / 2, this.gassing * 3, true, true);
            }
        }
    }
}

