/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdScoring;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGTimer;
import jgame.platform.JGEngine;

public class ChainReaction
extends JGEngine {
    int timer = 0;
    int score = 0;
    int bullets = 0;
    int level = 1;
    JGFont scoring_font = new JGFont("Helvetica", 0, 12.0);
    JGColor[] explo_col = new JGColor[]{JGColor.red, JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta};

    public static void main(String[] stringArray) {
        new ChainReaction(0, 0);
    }

    public ChainReaction() {
        this.initEngineApplet();
    }

    public ChainReaction(int n, int n2) {
        this.initEngine(n, n2);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 32, 32, null, null, null);
    }

    public void initGame() {
        this.defineMedia("chain_reaction.tbl");
        this.setFrameRate(40.0, 4.0);
        this.setGameState("Title");
        this.setMouseCursor(1);
        this.setBGImage("sky");
    }

    public void doFrameTitle() {
        if (this.getMouseButton(1)) {
            this.clearMouseButton(1);
            this.setGameState("InGame");
            this.score = 0;
            this.bullets = 15;
            this.timer = 0;
            this.level = 1;
        }
    }

    public void doFrameNextLevel() {
        this.moveObjects();
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(2, 1);
        if (this.getMouseButton(1) && this.bullets > 0) {
            new Explo(this.getMouseX(), this.getMouseY(), new Count());
            --this.bullets;
            this.clearMouseButton(1);
        }
        if (this.timer % 20 == 0) {
            if (this.countObjects("plane", 0) < 20) {
                new Enemy(-32 + this.random(0, 1, 1) * (this.pfWidth() + 32), this.random(0.0, this.pfHeight() - 48), this.random(1.5 + (double)this.level / 10.0, 3.0 + (double)this.level / 7.0), 0.0, "plane");
            }
            if (this.timer < 2000 && this.countObjects("paratrooper", 0) < 25) {
                new Enemy(this.random(0.0, this.pfWidth() - 32), -32.0, this.random(-0.7, 0.7), this.random(0.2 + (double)this.level / 50.0, 0.8 + (double)this.level / 12.0), "paratrooper");
            }
        }
        ++this.timer;
        if (this.timer >= 2000 && this.countObjects("paratrooper", 0) == 0) {
            this.setGameState("NextLevel");
            new JGTimer(160, true){

                public void alarm() {
                    ChainReaction.this.timer = 0;
                    ChainReaction.this.removeObjects(null, 0);
                    ChainReaction.this.score += ChainReaction.this.bullets * 150;
                    if (ChainReaction.this.level < 12) {
                        ++ChainReaction.this.level;
                    }
                    ChainReaction.this.bullets = 15;
                    ChainReaction.this.setGameState("InGame");
                }
            };
        }
    }

    public void paintFrame() {
        this.setColor(JGColor.white);
        this.drawString("Score " + this.score, 0.0, 0.0, -1);
        this.drawString("Bullets " + this.bullets, this.pfWidth() - 8, 0.0, 1);
    }

    public void paintFrameNextLevel() {
        this.drawImageString("WAVE " + this.level + " FINISHED !", 48.0, 130.0, -1, "font_map", 32, 0);
        this.drawImageString("BONUS " + this.bullets + "X150: " + this.bullets * 150, 32.0, 270.0, -1, "font_map", 32, 0);
    }

    public void paintFrameGameOver() {
        this.drawImageString("GAME OVER", 190.0, 200.0, -1, "font_map", 32, 0);
    }

    public void paintFrameTitle() {
        this.drawImageString("CHAIN REACTION", 100.0, 130.0, -1, "font_map", 32, 0);
        this.drawImageString("MOUSE BUTTON TO START", 0.0, 270.0, -1, "font_map", 32, -2);
    }

    public class Explo
    extends JGObject {
        double size = 16.0;
        double size_inc = 10.0;
        public Count count;

        public Explo(double d, double d2, Count count) {
            super("explo", true, d, d2, 2, null, 0.0, 0.0, 32);
            this.count = count;
            ++count.value;
        }

        public void move() {
            this.size += this.size_inc;
            this.size_inc -= 0.8;
            this.setBBox((int)(-this.size / 2.4), (int)(-this.size / 2.4), (int)(this.size / 1.2), (int)(this.size / 1.2));
        }

        public void paint() {
            ChainReaction.this.setColor(ChainReaction.this.explo_col[ChainReaction.this.timer / 4 % ChainReaction.this.explo_col.length]);
            ChainReaction.this.drawOval((int)this.x, (int)this.y, (int)this.size, (int)this.size, true, true);
        }
    }

    public class Enemy
    extends JGObject {
        String graphic;

        public Enemy(double d, double d2, double d3, double d4, String string) {
            super(string, true, d, d2, 1, null, d3, d4);
            this.graphic = string;
        }

        public void move() {
            if (this.x < 0.0 && this.xdir < 0) {
                this.xdir = 1;
            }
            if (this.x > (double)(ChainReaction.this.pfWidth() - 32) && this.xdir > 0) {
                this.xdir = -1;
            }
            if (this.y >= (double)(ChainReaction.this.pfHeight() - 32)) {
                this.setSpeed(0.0, 0.0);
                this.colid = 0;
                this.setGraphic("trooper_land");
                if (!ChainReaction.this.inGameState("GameOver")) {
                    ChainReaction.this.addGameState("GameOver");
                    new JGTimer(250, true){

                        public void alarm() {
                            ChainReaction.this.removeObjects(null, 0);
                            ChainReaction.this.setGameState("Title");
                        }
                    };
                }
            } else if (this.xdir < 0) {
                this.setGraphic(this.graphic + "_l");
            } else {
                this.setGraphic(this.graphic + "_r");
            }
        }

        public void hit(JGObject jGObject) {
            Count count = ((Explo)jGObject).count;
            ChainReaction.this.score += 10 * count.value;
            if (count.value > 4 && count.value < 10) {
                ++ChainReaction.this.bullets;
                new StdScoring("Scoring", this.x + 16.0, this.y, 0.0, -1.0, 80, "+1 bullet", ChainReaction.this.scoring_font, new JGColor[]{JGColor.yellow, new JGColor(128, 64, 0)}, 2);
            }
            new Explo(this.x + 16.0, this.y + 16.0, count);
            new StdScoring("Scoring", this.x + 16.0, this.y + 16.0, 0.0, -1.0, 80, count.value + "0 pts", ChainReaction.this.scoring_font, new JGColor[]{JGColor.blue, JGColor.blue, JGColor.cyan}, 2);
            this.remove();
        }
    }

    public class Scoring
    extends JGObject {
        String msg;
        JGColor[] cols;

        public Scoring(String string, double d, double d2, JGColor[] jGColorArray) {
            super("Scoring", true, d, d2, 0, null, 0.0, -1.0, 80);
            this.msg = string;
            this.cols = jGColorArray;
        }

        public void paint() {
            ChainReaction.this.setFont(ChainReaction.this.scoring_font);
            ChainReaction.this.setColor(this.cols[ChainReaction.this.timer / 2 % this.cols.length]);
            ChainReaction.this.drawString(this.msg, (int)this.x, (int)this.y, 0);
        }
    }

    public class Count {
        public int value = -1;
    }
}

